/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringJoiner;
import java.util.logging.Filter;
import java.util.logging.LogRecord;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Source;
import javax.xml.transform.stax.StAXSource;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.util.StandardDateFormat;
import org.apache.sis.internal.util.TemporalUtilities;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.geotiff.NativeMetadata;
import org.apache.sis.storage.geotiff.Reader;
import org.apache.sis.storage.geotiff.Tags;
import org.apache.sis.storage.geotiff.Type;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.XML;

final class XMLMetadata
implements Filter {
    private static final String ITEM = "Item";
    private static final String NAME = "name";
    private byte[] bytes;
    private String string;
    private String currentElement;
    private final StoreListeners listeners;
    private final boolean isGDAL;
    private XMLMetadata next;

    XMLMetadata(String string, boolean bl) {
        this.isGDAL = bl;
        this.string = string;
        this.listeners = null;
    }

    XMLMetadata(Reader reader, Type type, long l, short s) throws IOException {
        this.isGDAL = s == -23424;
        this.listeners = reader.store.listeners();
        block0 : switch (type) {
            case ASCII: {
                CharSequence[] charSequenceArray = type.readString(reader.input, l, reader.store.encoding);
                switch (charSequenceArray.length) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.string = charSequenceArray[0];
                        break block0;
                    }
                }
                this.string = String.join((CharSequence)System.lineSeparator(), charSequenceArray);
                break;
            }
            case BYTE: 
            case UBYTE: {
                this.bytes = ((ByteBuffer)type.readVector(reader.input, l).buffer().get()).array();
            }
        }
    }

    final void appendTo(XMLMetadata xMLMetadata) {
        while (xMLMetadata.next != null) {
            xMLMetadata = xMLMetadata.next;
        }
        xMLMetadata.next = this;
    }

    String tag() {
        return Tags.name(this.isGDAL ? (short)-23424 : -14627);
    }

    public boolean isEmpty() {
        return this.bytes == null && this.string == null;
    }

    public String toString() {
        if (this.string == null) {
            if (this.bytes == null) {
                return null;
            }
            this.string = new String(this.bytes, StandardCharsets.UTF_8);
        }
        return this.string;
    }

    private XMLEventReader toXML() throws XMLStreamException {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newFactory();
        if (this.bytes != null) {
            return xMLInputFactory.createXMLEventReader(new ByteArrayInputStream(this.bytes), "UTF-8");
        }
        if (this.string != null) {
            return xMLInputFactory.createXMLEventReader(new StringReader(this.string));
        }
        return null;
    }

    private void append(XMLEventReader xMLEventReader, StartElement startElement, TreeTable.Node node) throws XMLStreamException {
        Object object;
        Object object2;
        Object object3;
        String string = this.currentElement;
        this.currentElement = startElement.getName().getLocalPart();
        node.setValue(Root.NAME, (Object)this.currentElement);
        boolean bl = this.isGDAL && this.currentElement.equals(ITEM);
        Iterator<Attribute> iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            if (!object3.isSpecified()) continue;
            object2 = object3.getName().getLocalPart();
            object = object3.getValue();
            if (bl && ((String)object2).equals(NAME)) {
                node.setValue(Root.NAME, object);
                continue;
            }
            TreeTable.Node node2 = node.newChild();
            node2.setValue(Root.NAME, object2);
            node2.setValue(Root.VALUE, object);
        }
        object3 = new StringJoiner("");
        while (xMLEventReader.hasNext()) {
            object2 = xMLEventReader.nextEvent();
            if (object2.isStartElement()) {
                this.append(xMLEventReader, object2.asStartElement(), node.newChild());
            }
            if (object2.isCharacters() && !(object = object2.asCharacters()).isWhiteSpace()) {
                ((StringJoiner)object3).add(object.getData());
            }
            if (!object2.isEndElement()) continue;
            break;
        }
        if (!((String)(object2 = ((StringJoiner)object3).toString())).isEmpty()) {
            node.setValue(Root.VALUE, object2);
        }
        this.currentElement = string;
    }

    public XMLMetadata appendTo(MetadataBuilder metadataBuilder) throws XMLStreamException, JAXBException {
        XMLEventReader xMLEventReader = this.toXML();
        if (xMLEventReader != null) {
            if (this.isGDAL) {
                Parser parser = new Parser(xMLEventReader, metadataBuilder);
                while (xMLEventReader.hasNext()) {
                    XMLEvent xMLEvent = xMLEventReader.nextEvent();
                    if (!xMLEvent.isStartElement()) continue;
                    parser.root(xMLEvent.asStartElement());
                }
                parser.flush();
            } else {
                metadataBuilder.mergeMetadata(XML.unmarshal((Source)new StAXSource(xMLEventReader), Collections.singletonMap("org.apache.sis.xml.warningFilter", this)), this.listeners != null ? this.listeners.getLocale() : null);
            }
            xMLEventReader.close();
        }
        return this.next;
    }

    @Override
    public boolean isLoggable(LogRecord logRecord) {
        this.listeners.warning(logRecord);
        return false;
    }

    static final class Root
    extends DefaultTreeTable.Node {
        private static final TableColumn<CharSequence> NAME = NativeMetadata.NAME;
        private static final TableColumn<Object> VALUE = NativeMetadata.VALUE;
        private final String xml;

        public Object getUserObject() {
            return this.xml;
        }

        Root(XMLMetadata xMLMetadata, DefaultTreeTable.Node node, String string) {
            super(node);
            this.xml = xMLMetadata.toString();
            xMLMetadata.currentElement = string;
            this.setValue(NAME, string);
            try {
                XMLEventReader xMLEventReader = xMLMetadata.toXML();
                if (xMLEventReader != null) {
                    while (xMLEventReader.hasNext()) {
                        XMLEvent xMLEvent = xMLEventReader.nextEvent();
                        if (!xMLEvent.isStartElement()) continue;
                        xMLMetadata.append(xMLEventReader, xMLEvent.asStartElement(), (TreeTable.Node)this.newChild());
                    }
                    xMLEventReader.close();
                }
            }
            catch (XMLStreamException xMLStreamException) {
                this.getChildren().clear();
                this.setValue(VALUE, this.xml);
                DefaultTreeTable.Node node2 = this.newChild();
                node2.setValue(NAME, (Object)Errors.format((short)12, (Object)xMLMetadata.currentElement));
                node2.setValue(VALUE, (Object)xMLStreamException);
            }
            xMLMetadata.currentElement = null;
        }
    }

    private static final class Parser {
        private final XMLEventReader reader;
        private final QName name;
        private int depth;
        private final MetadataBuilder metadata;
        private Instant startTime;
        private Instant endTime;

        Parser(XMLEventReader xMLEventReader, MetadataBuilder metadataBuilder) {
            this.reader = xMLEventReader;
            this.metadata = metadataBuilder;
            this.name = new QName(XMLMetadata.NAME);
        }

        void root(StartElement startElement) throws XMLStreamException {
            boolean bl = startElement.getName().getLocalPart().equals("GDALMetadata");
            while (this.reader.hasNext()) {
                XMLEvent xMLEvent = this.reader.nextEvent();
                if (xMLEvent.isStartElement()) {
                    if (bl) {
                        this.item(xMLEvent.asStartElement());
                        continue;
                    }
                    this.root(xMLEvent.asStartElement());
                    continue;
                }
                if (!xMLEvent.isEndElement()) continue;
                break;
            }
        }

        private void item(StartElement startElement) throws XMLStreamException {
            Object object;
            Object object2;
            String string = null;
            if (this.depth == 0 && startElement.getName().getLocalPart().equals(XMLMetadata.ITEM) && (object2 = startElement.getAttributeByName(this.name)) != null) {
                string = object2.getValue();
            }
            object2 = new StringJoiner("");
            while (this.reader.hasNext() && !(object = this.reader.nextEvent()).isEndElement()) {
                if (object.isCharacters()) {
                    ((StringJoiner)object2).add(object.asCharacters().getData());
                    continue;
                }
                if (!object.isStartElement()) continue;
                ++this.depth;
                this.item(object.asStartElement());
                --this.depth;
            }
            if (string != null) {
                if (Character.isUpperCase(string.codePointAt(0))) {
                    string = string.toLowerCase(Locale.US);
                }
                if (!((String)(object = ((StringJoiner)object2).toString())).isEmpty()) {
                    switch (string) {
                        case "acquisitionStartDate": {
                            this.startTime = StandardDateFormat.parseInstantUTC((CharSequence)object);
                            break;
                        }
                        case "acquisitionEndDate": {
                            this.endTime = StandardDateFormat.parseInstantUTC((CharSequence)object);
                            break;
                        }
                        case "title": {
                            this.metadata.addTitle((CharSequence)object);
                        }
                    }
                }
            }
        }

        void flush() {
            this.metadata.addTemporalExtent(TemporalUtilities.toDate((Instant)this.startTime), TemporalUtilities.toDate((Instant)this.endTime));
        }
    }
}

