/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.util.resources.Errors;

final class ReversedBitsChannel
implements ReadableByteChannel,
SeekableByteChannel {
    private static final byte[] REVERSE = new byte[256];
    private final ChannelDataInput input;

    private ReversedBitsChannel(ChannelDataInput channelDataInput) {
        this.input = channelDataInput;
    }

    static ChannelDataInput wrap(ChannelDataInput channelDataInput) throws IOException {
        ChannelDataInput channelDataInput2 = new ChannelDataInput(channelDataInput.filename, new ReversedBitsChannel(channelDataInput), (ByteBuffer)ByteBuffer.allocate(2048).order(channelDataInput.buffer.order()).limit(0), true);
        channelDataInput2.setStreamPosition(channelDataInput.getStreamPosition());
        return channelDataInput2;
    }

    @Override
    public long size() throws IOException {
        if (this.input.channel instanceof SeekableByteChannel) {
            return ((SeekableByteChannel)this.input.channel).size();
        }
        throw ReversedBitsChannel.unsupported("size");
    }

    @Override
    public long position() {
        return this.input.getStreamPosition();
    }

    @Override
    public SeekableByteChannel position(long l) throws IOException {
        this.input.setStreamPosition(l);
        return this;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.remaining();
        if (n != 0) {
            ByteBuffer byteBuffer2 = this.input.buffer;
            if (!byteBuffer2.hasRemaining()) {
                this.input.ensureBufferContains(1);
            }
            int n2 = n = Math.min(n, byteBuffer2.remaining());
            while (--n2 >= 0) {
                byteBuffer.put(REVERSE[Byte.toUnsignedInt(byteBuffer2.get())]);
            }
        }
        return n;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        throw ReversedBitsChannel.unsupported("write");
    }

    @Override
    public SeekableByteChannel truncate(long l) throws IOException {
        throw ReversedBitsChannel.unsupported("truncate");
    }

    private static IOException unsupported(String string) {
        return new IOException(Errors.format((short)162, (Object)string));
    }

    @Override
    public final boolean isOpen() {
        return this.input.channel.isOpen();
    }

    @Override
    public final void close() {
    }

    static {
        for (int i = 0; i < 256; ++i) {
            ReversedBitsChannel.REVERSE[i] = (byte)(Integer.reverse(i) >>> 24);
        }
    }
}

