/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.geotiff.DeferredEntry;
import org.apache.sis.storage.geotiff.GeoTIFF;
import org.apache.sis.storage.geotiff.GeoTiffStore;
import org.apache.sis.storage.geotiff.ImageFileDirectory;
import org.apache.sis.storage.geotiff.MultiResolutionImage;
import org.apache.sis.storage.geotiff.Tags;
import org.apache.sis.storage.geotiff.Type;
import org.opengis.util.NameFactory;

final class Reader
extends GeoTIFF {
    final ChannelDataInput input;
    final long origin;
    final byte intSizeExpansion;
    private ImageFileDirectory lastIFD;
    private long nextIFD;
    private final Set<Long> doneIFD;
    private final List<GridCoverageResource> images = new ArrayList<GridCoverageResource>();
    private final LinkedList<DeferredEntry> deferredEntries = new LinkedList();
    private boolean deferredNeedsSort;
    final NameFactory nameFactory;

    Reader(GeoTiffStore geoTiffStore, ChannelDataInput channelDataInput) throws IOException, DataStoreException {
        super(geoTiffStore);
        boolean bl;
        this.input = channelDataInput;
        this.origin = channelDataInput.getStreamPosition();
        this.doneIFD = new HashSet<Long>();
        this.nameFactory = (NameFactory)DefaultFactories.forBuildin(NameFactory.class);
        short s = channelDataInput.readShort();
        boolean bl2 = bl = s == 19789;
        if (bl || s == 18761) {
            channelDataInput.buffer.order(bl ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            switch (channelDataInput.readShort()) {
                case 42: {
                    this.intSizeExpansion = 0;
                    this.readNextImageOffset();
                    return;
                }
                case 43: {
                    int n = channelDataInput.readUnsignedShort();
                    int n2 = Integer.numberOfTrailingZeros(n);
                    if ((long)n != 1L << n2 || channelDataInput.readShort() != 0) break;
                    this.intSizeExpansion = (byte)(n2 - 2);
                    if (this.intSizeExpansion != 1) break;
                    this.readNextImageOffset();
                    return;
                }
            }
        }
        throw new DataStoreContentException(geoTiffStore.errors().getString((short)139, (Object)"TIFF", (Object)channelDataInput.filename));
    }

    private void readNextImageOffset() throws IOException, DataStoreException {
        this.nextIFD = this.readUnsignedInt();
        if (!this.doneIFD.add(this.nextIFD)) {
            throw new DataStoreContentException(this.resources().getString((short)1, this.input.filename));
        }
    }

    private long readUnsignedInt() throws IOException, DataStoreException {
        if (this.intSizeExpansion == 0) {
            return this.input.readUnsignedInt();
        }
        long l = this.input.readLong();
        if (l >= 0L) {
            return l;
        }
        throw new DataStoreContentException(this.store.getLocale(), "TIFF", this.input.filename, null);
    }

    private long readUnsignedShort() throws IOException, DataStoreException {
        if (this.intSizeExpansion == 0) {
            return this.input.readUnsignedShort();
        }
        long l = this.input.readLong();
        if (l >= 0L) {
            return l;
        }
        throw new DataStoreContentException(this.store.getLocale(), "TIFF", this.input.filename, null);
    }

    private ImageFileDirectory getImageFileDirectory(int n) throws IOException, DataStoreException {
        if (this.nextIFD == 0L) {
            return null;
        }
        this.resolveDeferredEntries(null, this.nextIFD);
        this.input.seek(Math.addExact(this.origin, this.nextIFD));
        this.nextIFD = 0L;
        int n2 = 4 << this.intSizeExpansion;
        ImageFileDirectory imageFileDirectory = new ImageFileDirectory(this, n);
        long l = this.readUnsignedShort();
        while (--l >= 0L) {
            long l2;
            short s = (short)this.input.readUnsignedShort();
            Type type = Type.valueOf(this.input.readShort());
            long l3 = this.readUnsignedInt();
            long l4 = l2 = type != null ? Math.multiplyExact((long)type.size, l3) : 0L;
            if (l2 <= (long)n2) {
                long l5 = this.input.getStreamPosition();
                if (l2 != 0L) {
                    Object object;
                    try {
                        object = imageFileDirectory.addEntry(s, type, l3);
                    }
                    catch (IOException | DataStoreException exception) {
                        throw exception;
                    }
                    catch (Exception exception) {
                        object = exception;
                    }
                    if (object != null) {
                        this.warning(s, object);
                    }
                }
                this.input.seek(l5 + (long)n2);
                continue;
            }
            this.deferredEntries.add(new DeferredEntry(imageFileDirectory, s, type, l3, this.readUnsignedInt()));
            imageFileDirectory.hasDeferredEntries = true;
            this.deferredNeedsSort = true;
        }
        this.readNextImageOffset();
        return imageFileDirectory;
    }

    final void resolveDeferredEntries(ImageFileDirectory imageFileDirectory) throws IOException, DataStoreException {
        if (imageFileDirectory.hasDeferredEntries) {
            this.resolveDeferredEntries(imageFileDirectory, Long.MAX_VALUE);
            imageFileDirectory.hasDeferredEntries = false;
        }
        imageFileDirectory.validateMandatoryTags();
    }

    private void resolveDeferredEntries(ImageFileDirectory imageFileDirectory, long l) throws IOException, DataStoreException {
        Iterator<DeferredEntry> iterator;
        if (this.deferredNeedsSort) {
            this.deferredEntries.sort(null);
            this.deferredNeedsSort = false;
        }
        long l2 = this.input.getStreamPosition() - this.origin;
        DeferredEntry deferredEntry = null;
        if (imageFileDirectory != null) {
            iterator = this.deferredEntries.descendingIterator();
            while (iterator.hasNext()) {
                deferredEntry = iterator.next();
                if (deferredEntry.owner != imageFileDirectory) continue;
            }
        }
        iterator = this.deferredEntries.iterator();
        while (iterator.hasNext()) {
            DeferredEntry deferredEntry2 = iterator.next();
            if (deferredEntry2.owner == imageFileDirectory || deferredEntry2.offset >= l2 && deferredEntry2.offset <= l) {
                Object object;
                this.input.seek(Math.addExact(this.origin, deferredEntry2.offset));
                try {
                    object = deferredEntry2.owner.addEntry(deferredEntry2.tag, deferredEntry2.type, deferredEntry2.count);
                }
                catch (IOException | DataStoreException exception) {
                    throw exception;
                }
                catch (Exception exception) {
                    object = exception;
                }
                if (object != null) {
                    this.warning(deferredEntry2.tag, object);
                }
                iterator.remove();
            }
            if (deferredEntry2 != deferredEntry) continue;
            break;
        }
    }

    final GridCoverageResource getImage(int n) throws IOException, DataStoreException {
        while (n >= this.images.size()) {
            ImageFileDirectory imageFileDirectory;
            int n2 = this.images.size();
            ImageFileDirectory imageFileDirectory2 = this.lastIFD;
            if (imageFileDirectory2 == null && (imageFileDirectory2 = this.getImageFileDirectory(n2)) == null) {
                return null;
            }
            this.lastIFD = null;
            ++n2;
            ArrayList<ImageFileDirectory> arrayList = new ArrayList<ImageFileDirectory>();
            while ((imageFileDirectory = this.getImageFileDirectory(n2)) != null) {
                if (imageFileDirectory.isReducedResolution()) {
                    arrayList.add(imageFileDirectory);
                    continue;
                }
                this.lastIFD = imageFileDirectory;
                break;
            }
            if (arrayList.isEmpty()) {
                this.images.add(imageFileDirectory2);
                continue;
            }
            arrayList.add(0, imageFileDirectory2);
            this.images.add(new MultiResolutionImage(arrayList));
        }
        GridCoverageResource gridCoverageResource = this.images.get(n);
        if (gridCoverageResource instanceof ImageFileDirectory) {
            this.resolveDeferredEntries((ImageFileDirectory)gridCoverageResource);
        }
        return gridCoverageResource;
    }

    private void warning(short s, Object object) {
        Exception exception;
        Object[] objectArray;
        short s2;
        if (object instanceof Exception) {
            s2 = 15;
            objectArray = new Object[1];
            exception = (Exception)object;
        } else {
            s2 = 146;
            objectArray = new Object[2];
            objectArray[1] = object;
            exception = null;
        }
        objectArray[0] = Tags.name(s);
        this.store.listeners().warning(this.errors().getString(s2, (Object)objectArray), exception);
    }

    @Override
    public void close() throws IOException {
        this.input.channel.close();
    }
}

