/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.storage.GridResourceWrapper;
import org.apache.sis.internal.storage.TiledGridResource;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.geotiff.DataCube;
import org.apache.sis.storage.geotiff.ImageFileDirectory;
import org.opengis.geometry.DirectPosition;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.NameSpace;

final class MultiResolutionImage
extends GridResourceWrapper {
    private NameSpace namespace;
    private final ImageFileDirectory[] levels;
    private final double[][] resolutions;
    private volatile CoordinateOperation lastOperation;

    MultiResolutionImage(List<ImageFileDirectory> list) {
        this.levels = list.toArray(new ImageFileDirectory[list.size()]);
        this.resolutions = new double[this.levels.length][];
    }

    @Override
    protected final Object getSynchronizationLock() {
        return this.levels[0].getSynchronizationLock();
    }

    @Override
    protected GridCoverageResource createSource() throws DataStoreException {
        try {
            return this.getImageFileDirectory(0);
        }
        catch (IOException iOException) {
            throw this.levels[0].reader.store.errorIO(iOException);
        }
    }

    private ImageFileDirectory getImageFileDirectory(int n) throws IOException, DataStoreException {
        assert (Thread.holdsLock(this.getSynchronizationLock()));
        ImageFileDirectory imageFileDirectory = this.levels[n];
        if (imageFileDirectory.hasDeferredEntries) {
            imageFileDirectory.reader.resolveDeferredEntries(imageFileDirectory);
        }
        if (imageFileDirectory.validateMandatoryTags() && n != 0) {
            if (this.namespace == null) {
                ImageFileDirectory imageFileDirectory2 = this.levels[0];
                this.namespace = imageFileDirectory2.reader.nameFactory.createNameSpace(imageFileDirectory2.getIdentifier().get(), null);
            }
            imageFileDirectory.setOverviewIdentifier(this.namespace, n);
        }
        return imageFileDirectory;
    }

    private double[] resolution(int n) throws DataStoreException {
        double[] dArray = this.resolutions[n];
        if (dArray == null) {
            try {
                ImageFileDirectory imageFileDirectory = this.getImageFileDirectory(n);
                ImageFileDirectory imageFileDirectory2 = this.getImageFileDirectory(0);
                GridGeometry gridGeometry = imageFileDirectory2.getGridGeometry();
                GridExtent gridExtent = gridGeometry.getExtent();
                GridExtent gridExtent2 = imageFileDirectory.getExtent();
                double[] dArray2 = new double[gridExtent.getDimension()];
                for (int i = 0; i < dArray2.length; ++i) {
                    dArray2[i] = gridExtent.getSize(i, false) / gridExtent2.getSize(i, false);
                }
                imageFileDirectory.initReducedResolution(imageFileDirectory2, dArray2);
                if (gridGeometry.isDefined(8)) {
                    MatrixSIS matrixSIS = MatrixSIS.castOrCopy((Matrix)gridGeometry.getGridToCRS(PixelInCell.CELL_CENTER).derivative((DirectPosition)new DirectPositionView.Double(gridExtent.getPointOfInterest())));
                    dArray = matrixSIS.multiply(dArray2);
                } else {
                    dArray = dArray2;
                }
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = Math.abs(dArray[i]);
                }
                this.resolutions[n] = dArray;
            }
            catch (TransformException transformException) {
                throw new DataStoreReferencingException(transformException);
            }
            catch (IOException iOException) {
                throw this.levels[n].reader.store.errorIO(iOException);
            }
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<double[]> getResolutions() throws DataStoreException {
        double[][] dArrayArray = new double[this.resolutions.length][];
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            for (int i = 0; i < dArrayArray.length; ++i) {
                dArrayArray[i] = (double[])this.resolution(i).clone();
            }
        }
        return Arrays.asList(dArrayArray);
    }

    private double[] getResolution(GridGeometry gridGeometry) throws DataStoreException {
        if (gridGeometry == null || !gridGeometry.isDefined(16)) {
            return null;
        }
        double[] dArray = gridGeometry.getResolution(true);
        if (gridGeometry.isDefined(3)) {
            try {
                GridGeometry gridGeometry2;
                CoordinateReferenceSystem coordinateReferenceSystem = gridGeometry.getCoordinateReferenceSystem();
                CoordinateOperation coordinateOperation = this.lastOperation;
                if (coordinateOperation == null || !coordinateReferenceSystem.equals((Object)coordinateOperation.getTargetCRS())) {
                    gridGeometry2 = this.getGridGeometry();
                    this.lastOperation = coordinateOperation = CRS.findOperation((CoordinateReferenceSystem)coordinateReferenceSystem, (CoordinateReferenceSystem)gridGeometry2.getCoordinateReferenceSystem(), (GeographicBoundingBox)gridGeometry2.getGeographicExtent().orElse(null));
                }
                if (!(gridGeometry2 = coordinateOperation.getMathTransform()).isIdentity()) {
                    DirectPositionView.Double double_ = new DirectPositionView.Double(gridGeometry.getExtent().getPointOfInterest());
                    double_ = gridGeometry.getGridToCRS(PixelInCell.CELL_CENTER).transform((DirectPosition)double_, null);
                    MatrixSIS matrixSIS = MatrixSIS.castOrCopy((Matrix)gridGeometry2.derivative((DirectPosition)double_));
                    dArray = matrixSIS.multiply(dArray);
                    for (int i = 0; i < dArray.length; ++i) {
                        dArray[i] = Math.abs(dArray[i]);
                    }
                }
            }
            catch (TransformException | FactoryException throwable) {
                throw new DataStoreReferencingException(throwable);
            }
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridCoverage read(GridGeometry gridGeometry, int ... nArray) throws DataStoreException {
        double[] dArray = this.getResolution(gridGeometry);
        int n = dArray != null ? this.resolutions.length : 1;
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            Object object2;
            block5: while (--n > 0) {
                object2 = this.resolution(n);
                for (int i = 0; i < dArray.length; ++i) {
                    if (!(dArray[i] >= object2[i])) continue block5;
                }
            }
            try {
                object2 = this.getImageFileDirectory(n);
            }
            catch (IOException iOException) {
                throw this.levels[n].reader.store.errorIO(iOException);
            }
            ((TiledGridResource)object2).setLoadingStrategy(this.getLoadingStrategy());
            return ((DataCube)object2).read(gridGeometry, nArray);
        }
    }
}

