/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.sis.math.Vector;
import org.apache.sis.referencing.operation.builder.LocalizationGridBuilder;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class Localization {
    static final int RECORD_LENGTH = 6;
    private static final double PRECISION = 1.0E-6;

    private Localization() {
    }

    static MathTransform nonLinear(Vector vector) throws FactoryException, TransformException {
        return Localization.localizationGrid(vector, null);
    }

    private static MathTransform localizationGrid(Vector vector, Map<Envelope, MathTransform> map) throws FactoryException, TransformException {
        int n = vector.size();
        int n2 = n / 6;
        if (n2 == 0) {
            return null;
        }
        Vector vector2 = vector.subSampling(0, 6, n2);
        Vector vector3 = vector.subSampling(1, 6, n2);
        try {
            LocalizationGridBuilder localizationGridBuilder = new LocalizationGridBuilder(vector2, vector3);
            LinearTransform linearTransform = localizationGridBuilder.getSourceToGrid();
            double[] dArray = new double[2];
            for (int i = 0; i < n; i += 6) {
                dArray[0] = vector.doubleValue(i);
                dArray[1] = vector.doubleValue(i + 1);
                linearTransform.transform(dArray, 0, dArray, 0, 1);
                localizationGridBuilder.setControlPoint(Math.toIntExact(Math.round(dArray[0])), Math.toIntExact(Math.round(dArray[1])), new double[]{vector.doubleValue(i + 3), vector.doubleValue(i + 4)});
            }
            localizationGridBuilder.setDesiredPrecision(1.0E-6);
            MathTransform mathTransform = localizationGridBuilder.create(null);
            if (map != null && map.put(localizationGridBuilder.getSourceEnvelope(false), mathTransform) != null) {
                throw new FactoryException();
            }
            return mathTransform;
        }
        catch (ArithmeticException | FactoryException throwable) {
            HashSet<Double> hashSet = new HashSet<Double>(100);
            double d = Localization.threshold(vector2, hashSet);
            double d2 = Localization.threshold(vector3, hashSet);
            if (Double.isNaN(d) && Double.isNaN(d2)) {
                throw throwable;
            }
            int[][] nArray = new int[4][n];
            int[] nArray2 = new int[4];
            int n3 = 0;
            while (n3 < n) {
                double d3 = vector.doubleValue(n3);
                double d4 = vector.doubleValue(n3 + 1);
                int n4 = 0;
                if (d3 > d) {
                    n4 = 1;
                }
                if (d4 > d2) {
                    n4 |= 2;
                }
                int n5 = 1 << n4;
                if (d3 == d) {
                    n5 |= 1 << (n4 | 1);
                }
                if (d4 == d2) {
                    n5 |= 1 << (n4 | 2);
                }
                if (n5 == 7) {
                    n5 = 15;
                    assert (d3 == d && d4 == d2);
                }
                int n6 = n3 + 6;
                do {
                    n4 = Integer.numberOfTrailingZeros(n5);
                    int[] nArray3 = nArray[n4];
                    int n7 = nArray2[n4];
                    int n8 = n3;
                    while (n8 < n6) {
                        nArray3[n7++] = n8++;
                    }
                    nArray2[n4] = n7;
                } while ((n5 &= ~(1 << n4)) != 0);
                n3 = n6;
            }
            n3 = 0;
            int n9 = 0;
            for (int i = 0; i < nArray.length; ++i) {
                int n10 = nArray2[i];
                if (n10 >= n) {
                    throw throwable;
                }
                nArray[i] = Arrays.copyOf(nArray[i], n10);
                if (n10 <= n3) continue;
                n3 = n10;
                n9 = i;
            }
            MathTransform mathTransform = null;
            LinkedHashMap<Envelope, MathTransform> linkedHashMap = new LinkedHashMap<Envelope, MathTransform>(4);
            for (int i = 0; i < nArray.length; ++i) {
                Vector vector4 = vector.pick(nArray[i]);
                if (i == n9) {
                    mathTransform = Localization.localizationGrid(vector4, null);
                    continue;
                }
                Localization.localizationGrid(vector4, linkedHashMap);
            }
            return MathTransforms.specialize(mathTransform, linkedHashMap);
        }
    }

    private static double threshold(Vector vector, Set<Double> set) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            set.add(vector.doubleValue(i));
        }
        Object[] objectArray = set.toArray(new Double[set.size()]);
        set.clear();
        int n2 = objectArray.length;
        if (n2 >= 3) {
            Arrays.sort(objectArray);
            double d = (Double)objectArray[--n2];
            double d2 = (Double)objectArray[--n2];
            double d3 = d - d2;
            do {
                double d4;
                if (d2 - (d4 = ((Double)objectArray[--n2]).doubleValue()) != d3) {
                    return d2;
                }
                d2 = d4;
            } while (n2 > 0);
        }
        return Double.NaN;
    }
}

