/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.util.NoSuchElementException;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridOrientation;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.math.Vector;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.storage.geotiff.CRSBuilder;
import org.apache.sis.storage.geotiff.GeoKeysLoader;
import org.apache.sis.storage.geotiff.Localization;
import org.apache.sis.storage.geotiff.Reader;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

final class GridGeometryBuilder
extends GeoKeysLoader {
    public Vector modelTiePoints;
    private MatrixSIS affine;
    private boolean completeMatrixSpecified;
    private String description;
    private CellGeometry cellGeometry;

    public void setGridToCRS(Vector vector, int n) {
        int n2 = vector.size();
        this.completeMatrixSpecified = true;
        this.affine = Matrices.createZero((int)n, (int)n);
        this.affine.setElement(n - 1, n - 1, 1.0);
        for (int i = 0; i < n2; ++i) {
            this.affine.setElement(i / n, i % n, vector.doubleValue(i));
        }
    }

    public void setScaleFactors(Vector vector) {
        int n = vector.size();
        this.completeMatrixSpecified = false;
        this.affine = Matrices.createZero((int)(n + 1), (int)(n + 1));
        this.affine.setElement(n, n, 1.0);
        for (int i = 0; i < n; ++i) {
            double d = vector.doubleValue(i);
            if (i == 1) {
                d = -d;
            }
            this.affine.setElement(i, i, d);
            this.affine.setElement(i, n, Double.NaN);
        }
    }

    GridGeometryBuilder() {
    }

    public boolean validateMandatoryTags() {
        MatrixSIS matrixSIS = this.affine;
        if (matrixSIS == null || this.completeMatrixSpecified) {
            return true;
        }
        Vector vector = this.modelTiePoints;
        if (vector != null) {
            int n = 0;
            double d = Double.POSITIVE_INFINITY;
            int n2 = vector.size();
            for (int i = 0; i < n2; i += 6) {
                double d2 = vector.doubleValue(i);
                double d3 = d2 * d2;
                d2 = vector.doubleValue(i + 1);
                double d4 = d3 + d2 * d2;
                d2 = vector.doubleValue(i + 2);
                double d5 = d4 + d2 * d2;
                if (!(d5 < d)) continue;
                d = d5;
                n = i;
                if (d5 == 0.0) break;
            }
            if (d != Double.POSITIVE_INFINITY) {
                DoubleDouble doubleDouble = new DoubleDouble();
                int n3 = matrixSIS.getNumRow() - 1;
                int n4 = matrixSIS.getNumCol() - 1;
                for (int i = 0; i < n3; ++i) {
                    doubleDouble.value = -vector.doubleValue(n + i);
                    doubleDouble.error = DoubleDouble.errorForWellKnownValue((double)doubleDouble.value);
                    doubleDouble.multiplyGuessError(matrixSIS.getNumber(i, i));
                    doubleDouble.addGuessError(vector.doubleValue(n + i + 3));
                    matrixSIS.setNumber(i, n4, (Number)doubleDouble);
                }
                return true;
            }
        }
        return false;
    }

    public GridGeometry build(Reader reader, long l, long l2) throws FactoryException {
        GridGeometry gridGeometry;
        CoordinateReferenceSystem coordinateReferenceSystem;
        block15: {
            coordinateReferenceSystem = null;
            if (this.keyDirectory != null) {
                CRSBuilder cRSBuilder = new CRSBuilder(reader);
                try {
                    coordinateReferenceSystem = cRSBuilder.build(this);
                    this.description = cRSBuilder.description;
                    this.cellGeometry = cRSBuilder.cellGeometry;
                }
                catch (ParameterNotFoundException | NoSuchIdentifierException throwable) {
                    short s = 23;
                    if (throwable instanceof NoSuchAuthorityCodeException) {
                        s = 22;
                    }
                    reader.store.listeners().warning(reader.resources().getString(s, reader.store.getDisplayName()), (Exception)throwable);
                }
                catch (ClassCastException | IllegalArgumentException | NoSuchElementException runtimeException) {
                    if (cRSBuilder.alreadyReported) break block15;
                    GridGeometryBuilder.canNotCreate(reader, runtimeException);
                }
            }
        }
        int n = coordinateReferenceSystem != null ? coordinateReferenceSystem.getCoordinateSystem().getDimension() : 2;
        DimensionNameType[] dimensionNameTypeArray = new DimensionNameType[n];
        long[] lArray = new long[n];
        switch (n) {
            default: {
                dimensionNameTypeArray[2] = DimensionNameType.VERTICAL;
            }
            case 2: {
                dimensionNameTypeArray[1] = DimensionNameType.ROW;
                lArray[1] = l2 - 1L;
            }
            case 1: {
                dimensionNameTypeArray[0] = DimensionNameType.COLUMN;
                lArray[0] = l - 1L;
            }
            case 0: 
        }
        GridExtent gridExtent = new GridExtent(dimensionNameTypeArray, null, lArray, true);
        boolean bl = CellGeometry.POINT.equals((Object)this.cellGeometry);
        MathTransformFactory mathTransformFactory = (MathTransformFactory)DefaultFactories.forBuildin(MathTransformFactory.class);
        try {
            MathTransform mathTransform;
            if (this.affine != null) {
                mathTransform = mathTransformFactory.createAffineTransform(Matrices.resizeAffine((Matrix)this.affine, (int)(++n), (int)n));
            } else {
                bl = true;
                mathTransform = Localization.nonLinear(this.modelTiePoints);
                mathTransform = mathTransformFactory.createPassThroughTransform(0, mathTransform, n - 2);
            }
            gridGeometry = new GridGeometry(gridExtent, bl ? PixelInCell.CELL_CENTER : PixelInCell.CELL_CORNER, mathTransform, coordinateReferenceSystem);
        }
        catch (TransformException transformException) {
            GeneralEnvelope generalEnvelope = null;
            if (coordinateReferenceSystem != null) {
                generalEnvelope = new GeneralEnvelope(coordinateReferenceSystem);
                generalEnvelope.setToNaN();
            }
            gridGeometry = new GridGeometry(gridExtent, (Envelope)generalEnvelope, GridOrientation.HOMOTHETY);
            GridGeometryBuilder.canNotCreate(reader, (Exception)((Object)transformException));
        }
        this.keyDirectory = null;
        this.numericParameters = null;
        this.asciiParameters = null;
        this.modelTiePoints = null;
        this.affine = null;
        return gridGeometry;
    }

    public void completeMetadata(GridGeometry gridGeometry, MetadataBuilder metadataBuilder) {
        if (metadataBuilder.addSpatialRepresentation(this.description, gridGeometry, true)) {
            PixelOrientation pixelOrientation;
            metadataBuilder.setCellGeometry(this.cellGeometry);
            if (CellGeometry.POINT.equals((Object)this.cellGeometry)) {
                pixelOrientation = PixelOrientation.CENTER;
            } else if (CellGeometry.AREA.equals((Object)this.cellGeometry)) {
                pixelOrientation = PixelOrientation.UPPER_LEFT;
            } else {
                return;
            }
            metadataBuilder.setPointInPixel(pixelOrientation);
        }
    }

    private static void canNotCreate(Reader reader, Exception exception) {
        reader.store.listeners().warning(reader.resources().getString((short)26, reader.input.filename), exception);
    }
}

