/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.sis.internal.storage.Capability;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.geotiff.GeoTiffStore;
import org.apache.sis.util.Version;
import org.opengis.parameter.ParameterDescriptorGroup;

@StoreMetadata(formatName="GeoTIFF", fileSuffixes={"tiff", "tif"}, capabilities={Capability.READ}, resourceTypes={Aggregate.class, GridCoverageResource.class})
public class GeoTiffStoreProvider
extends DataStoreProvider {
    private static final String MIME_TYPE = "image/tiff";
    private static final Version VERSION = new Version("6.0");
    private static final ParameterDescriptorGroup OPEN_DESCRIPTOR = URIDataStore.Provider.descriptor("GeoTIFF");

    @Override
    public String getShortName() {
        return "GeoTIFF";
    }

    @Override
    public ParameterDescriptorGroup getOpenParameters() {
        return OPEN_DESCRIPTOR;
    }

    @Override
    public ProbeResult probeContent(StorageConnector storageConnector) throws DataStoreException {
        return this.probeContent(storageConnector, ByteBuffer.class, byteBuffer -> {
            if (byteBuffer.remaining() < 4) {
                return ProbeResult.INSUFFICIENT_BYTES;
            }
            switch (byteBuffer.getShort()) {
                case 18761: {
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                }
                case 19789: {
                    switch (byteBuffer.getShort()) {
                        case 42: 
                        case 43: {
                            return new ProbeResult(true, MIME_TYPE, VERSION);
                        }
                    }
                }
            }
            return ProbeResult.UNSUPPORTED_STORAGE;
        });
    }

    @Override
    public DataStore open(StorageConnector storageConnector) throws DataStoreException {
        return new GeoTiffStore(this, storageConnector);
    }
}

