/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.inflater;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.sis.internal.geotiff.Resources;
import org.apache.sis.internal.storage.inflater.PixelChannel;
import org.apache.sis.internal.storage.io.ChannelDataInput;

abstract class CompressionChannel
extends PixelChannel {
    private static final int BUFFER_SIZE = 4096;
    protected final ChannelDataInput input;
    private long endPosition;

    protected CompressionChannel(ChannelDataInput channelDataInput) {
        this.input = channelDataInput;
    }

    @Override
    public void setInputRegion(long l, long l2) throws IOException {
        this.endPosition = Math.addExact(l, l2);
        this.input.seek(l);
    }

    protected final boolean finished() {
        return this.input.getStreamPosition() >= this.endPosition;
    }

    final ChannelDataInput createDataInput(PixelChannel pixelChannel) throws IOException {
        ByteBuffer byteBuffer = (ByteBuffer)ByteBuffer.allocate(4096).order(this.input.buffer.order()).limit(0);
        return new ChannelDataInput(this.input.filename, pixelChannel, byteBuffer, true);
    }

    static void repeat(ByteBuffer byteBuffer, byte by, int n) {
        while (--n >= 0) {
            byteBuffer.put(by);
        }
    }

    @Override
    public final boolean isOpen() {
        return this.input.channel.isOpen();
    }

    @Override
    public void close() {
    }

    final Resources resources() {
        return Resources.forLocale(null);
    }
}

