/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.inflater;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.sis.internal.storage.inflater.CompressionChannel;
import org.apache.sis.internal.storage.io.ChannelDataInput;

final class CCITTRLE
extends CompressionChannel {
    private static final short[] WHITE_RUNLENGTH_TREE = new short[]{184, 107, 70, 49, 42, 37, 34, 9, 0, 23, 16, 13, -1793, 15, -1985, -2049, 20, 19, -2113, -2177, 22, -2241, -2305, 27, 26, -1857, -1921, 31, 30, -2369, -2433, 33, -2497, -2561, 36, -30, -31, 41, 40, -46, -47, -23, 48, 45, -24, 47, -48, -49, -14, 63, 56, 53, -21, 55, -34, -35, 60, 59, -36, -37, 62, -38, -39, 69, 66, -20, 68, -32, -33, -2, 92, 79, 74, -13, 78, 77, -54, -55, -27, 87, 84, 83, -40, -41, 86, -42, -43, 91, 90, -44, -45, -22, 106, 99, 96, -29, 98, -62, -63, 103, 102, -64, -1, 105, -321, -385, -11, 147, 126, 111, -12, 117, 114, -28, 116, -60, -61, 125, 122, 121, -1473, -1537, 124, -1601, -1729, -19, 138, 133, 130, -25, 132, -50, -51, 137, 136, -52, -53, -26, 146, 143, 142, -56, -57, 145, -58, -59, -193, 183, 160, 151, -1665, 155, 154, -449, -513, 159, 158, -705, -769, -641, 174, 167, 164, -577, 166, -833, -897, 171, 170, -961, -1025, 173, -1089, -1153, 182, 179, 178, -1217, -1281, 181, -1345, -1409, -257, -3, 198, 191, 188, -4, 190, -129, -9, 197, 194, -10, 196, -17, -18, -5, 206, 201, -6, 205, 204, -15, -16, -65, 208, -7, -8};
    private static final short[] BLACK_RUNLENGTH_TREE = new short[]{206, 203, 200, 195, 152, 101, 34, 9, 0, 23, 16, 13, -1793, 15, -1985, -2049, 20, 19, -2113, -2177, 22, -2241, -2305, 27, 26, -1857, -1921, 31, 30, -2369, -2433, 33, -2497, -2561, 68, 49, 38, -19, 44, 41, -53, 43, -641, -705, 48, 47, -769, -833, -56, 61, 56, 53, -57, 55, -1281, -1345, 60, 59, -1409, -1473, -60, 67, 64, -61, 66, -1537, -1601, -25, 86, 77, 72, -26, 76, 75, -1665, -1729, -321, 81, 80, -385, -449, 85, 84, -513, -577, -54, 100, 93, 90, -55, 92, -897, -961, 97, 96, -1025, -1089, 99, -1153, -1217, -65, 127, 104, -14, 118, 111, 108, -24, 110, -51, -52, 115, 114, -45, -46, 117, -47, -48, 126, 123, 122, -58, -59, 125, -62, -257, -17, 151, 138, 131, -18, 135, 134, -49, -50, 137, -63, -64, 146, 143, 142, -31, -32, 145, -33, -34, 150, 149, -41, -42, -23, -15, 156, 155, -11, -12, 194, 173, 160, -16, 168, 165, 164, -129, -193, 167, -27, -28, 172, 171, -29, -30, -20, 187, 180, 177, -21, 179, -35, -36, 184, 183, -37, -38, 186, -39, -40, 193, 190, -22, 192, -43, -44, -1, -13, 199, 198, -10, -9, -8, 202, -7, -6, 205, -2, -5, 208, -4, -3};
    static final int TERMINATING_LIMIT = 64;
    private final int bitsPerRow;
    private int remainingBitsInRow;
    private boolean runIsWhite;
    private int runLength;
    private static final int SIZE_SHIFT = 3;

    CCITTRLE(ChannelDataInput channelDataInput, int n) {
        super(channelDataInput);
        this.bitsPerRow = n;
    }

    @Override
    public void setInputRegion(long l, long l2) throws IOException {
        super.setInputRegion(l, l2);
        this.remainingBitsInRow = this.bitsPerRow;
        this.runIsWhite = false;
        this.runLength = 0;
    }

    final int getRunLength(short[] sArray) throws IOException {
        int n;
        int n2 = 0;
        do {
            int n3 = 0;
            while ((n = sArray[n3]) >= 0) {
                if (n == 0) {
                    long l = this.input.readBits(this.runIsWhite ? 4 : 3);
                    if (l != (long)(this.runIsWhite ? 1 : 0)) {
                        throw new IOException("Unexpected EOL");
                    }
                    this.input.skipRemainingBits();
                    this.runIsWhite = false;
                    return this.remainingBitsInRow;
                }
                n3 = this.input.readBit() != 0 ? n : n3 + 1;
            }
            n2 += (n ^= 0xFFFFFFFF);
        } while (n >= 64);
        return n2;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.position();
        int n2 = 0;
        int n3 = 0;
        while (byteBuffer.hasRemaining()) {
            int n4;
            while (this.runLength == 0) {
                if (this.remainingBitsInRow <= 0) {
                    this.remainingBitsInRow = this.bitsPerRow;
                    this.input.skipRemainingBits();
                    if (n3 != 0) {
                        byteBuffer.put((byte)(n2 << 8 - n3));
                    }
                    n3 = 0;
                    this.runIsWhite = false;
                }
                if (this.finished()) {
                    n4 = byteBuffer.position() - n;
                    if (n4 > 0) {
                        return n4;
                    }
                    this.runLength = this.remainingBitsInRow;
                } else {
                    this.runIsWhite = !this.runIsWhite;
                    this.runLength = this.getRunLength(this.runIsWhite ? WHITE_RUNLENGTH_TREE : BLACK_RUNLENGTH_TREE);
                }
                this.remainingBitsInRow -= this.runLength;
            }
            if (n3 != 0) {
                n4 = Math.min(8 - n3, this.runLength);
                n2 <<= n4;
                if (!this.runIsWhite) {
                    n2 |= (1 << n4) - 1;
                }
                if ((n3 += n4) >= 8) {
                    byteBuffer.put((byte)n2);
                    n3 = 0;
                }
                this.runLength -= n4;
                continue;
            }
            n4 = byteBuffer.remaining();
            int n5 = Math.min(this.runLength >>> 3, n4);
            byte by = this.runIsWhite ? (byte)0 : -1;
            CCITTRLE.repeat(byteBuffer, by, n5);
            this.runLength -= n5 << 3;
            if (n5 == n4) break;
            if ((this.runLength & 0xFFFFFFF8) != 0) continue;
            n3 = this.runLength;
            n2 = by & (1 << n3) - 1;
            this.runLength = 0;
        }
        assert (n3 == 0) : n3;
        return byteBuffer.position() - n;
    }
}

