/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.earth.netcdf;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import org.apache.sis.internal.netcdf.Convention;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Linearizer;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.VariableRole;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.operation.transform.TransferFunction;
import org.apache.sis.storage.netcdf.AttributeNames;
import org.apache.sis.util.CharSequences;

public final class GCOM_W
extends Convention {
    static final String SENTINEL_ATTRIBUTE = "PlatformShortName";
    static final Pattern SENTINEL_VALUE = Pattern.compile(".*\\bGCOM-W1\\b.*");
    private static final Map<String, String> ATTRIBUTES;
    static final String LATITUDE = "Latitude";
    static final String LONGITUDE = "Longitude";
    private static final short NO_DATA = Short.MIN_VALUE;

    @Override
    protected boolean isApplicableTo(Decoder decoder) {
        String string = decoder.stringValue(SENTINEL_ATTRIBUTE);
        return string != null && SENTINEL_VALUE.matcher(string).matches();
    }

    @Override
    public String mapAttributeName(String string) {
        return ATTRIBUTES.getOrDefault(string, string);
    }

    static boolean isCoordinateAxis(String string) {
        return CharSequences.startsWith((CharSequence)string, (CharSequence)LATITUDE, (boolean)true) || CharSequences.startsWith((CharSequence)string, (CharSequence)LONGITUDE, (boolean)true);
    }

    @Override
    public VariableRole roleOf(Variable variable) {
        VariableRole variableRole = super.roleOf(variable);
        if (variableRole == VariableRole.COVERAGE && GCOM_W.isCoordinateAxis(variable.getName())) {
            return VariableRole.AXIS;
        }
        return variableRole;
    }

    @Override
    public Set<Linearizer> linearizers(Decoder decoder) {
        return Collections.singleton(new Linearizer(CommonCRS.WGS84, Linearizer.Type.UNIVERSAL));
    }

    @Override
    public CommonCRS defaultHorizontalCRS(boolean bl) {
        return CommonCRS.WGS84;
    }

    @Override
    public Map<Number, Object> nodataValues(Variable variable) {
        Map<Number, Object> map = super.nodataValues(variable);
        if (map.isEmpty() && this.roleOf(variable) == VariableRole.COVERAGE) {
            map.put((short)Short.MIN_VALUE, 3);
        }
        return map;
    }

    @Override
    public TransferFunction transferFunction(Variable variable) {
        TransferFunction transferFunction = super.transferFunction(variable);
        if (transferFunction.isIdentity()) {
            double d = variable.getAttributeAsNumber("SCALE FACTOR");
            double d2 = variable.getAttributeAsNumber("OFFSET");
            if (Double.isFinite(d)) {
                transferFunction.setScale(d);
            }
            if (Double.isFinite(d2)) {
                transferFunction.setOffset(d2);
            }
        }
        return transferFunction;
    }

    @Override
    public Unit<?> getUnitFallback(Variable variable) throws ParserException {
        String string = variable.getAttributeAsString("UNIT");
        if (string == null) {
            return super.getUnitFallback(variable);
        }
        if (string.equals("C")) {
            return Units.CELSIUS;
        }
        return Units.valueOf((String)string);
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("title", "ProductName");
        hashMap.put("product_version", "ProductVersion");
        hashMap.put(AttributeNames.IDENTIFIER.TEXT, "GranuleID");
        hashMap.put("date_created", "ProductionDateTime");
        hashMap.put(AttributeNames.TIME.MINIMUM, "ObservationStartDateTime");
        hashMap.put(AttributeNames.TIME.MAXIMUM, "ObservationEndDateTime");
        hashMap.put(AttributeNames.CREATOR.INSTITUTION, "ProcessingCenter");
        hashMap.put("summary", "GeophysicalName");
        hashMap.put(AttributeNames.PLATFORM.TEXT, SENTINEL_ATTRIBUTE);
        hashMap.put(AttributeNames.INSTRUMENT.TEXT, "SensorShortName");
        hashMap.put("source", "InputFileName");
        ATTRIBUTES = hashMap;
    }
}

