/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.earth.netcdf;

import org.apache.sis.internal.earth.netcdf.GCOM_W;
import org.apache.sis.util.CharSequences;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.spi.CoordSystemBuilderFactory;
import ucar.nc2.internal.dataset.CoordSystemBuilder;

public final class FactoryForUCAR
implements CoordSystemBuilderFactory {
    public String getConventionName() {
        return "GCOM";
    }

    public boolean isMine(NetcdfFile netcdfFile) {
        String string;
        Attribute attribute = netcdfFile.findGlobalAttributeIgnoreCase("PlatformShortName");
        if (attribute != null && (string = attribute.getStringValue()) != null) {
            return GCOM_W.SENTINEL_VALUE.matcher(string).matches();
        }
        return false;
    }

    public CoordSystemBuilder open(NetcdfDataset.Builder builder) {
        return new CSBuilder(builder);
    }

    private static final class CSBuilder
    extends CoordSystemBuilder {
        CSBuilder(NetcdfDataset.Builder<?> builder) {
            super(builder);
        }

        protected void identifyCoordinateAxes() {
            for (CoordSystemBuilder.VarProcess varProcess : this.varList) {
                if (varProcess.isCoordinateVariable) continue;
                varProcess.isCoordinateVariable = GCOM_W.isCoordinateAxis(varProcess.vb.shortName);
            }
            super.identifyCoordinateAxes();
        }

        protected AxisType getAxisType(VariableDS.Builder builder) {
            AxisType axisType = super.getAxisType(builder);
            if (axisType == null) {
                String string = builder.shortName;
                if (CharSequences.startsWith((CharSequence)string, (CharSequence)"Longitude", (boolean)true)) {
                    return AxisType.Lon;
                }
                if (CharSequences.startsWith((CharSequence)string, (CharSequence)"Latitude", (boolean)true)) {
                    return AxisType.Lat;
                }
            }
            return axisType;
        }
    }
}

