/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.map.coverage;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.text.NumberFormat;
import java.util.Arrays;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.io.TableAppender;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.RasterLoadingStrategy;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public class MultiResolutionCoverageLoader {
    private static final int DEFAULT_SIZE = 512;
    private static final int DEFAULT_SCALE_LOG = 3;
    private static final int DEFAULT_NUM_LEVELS = 4;
    public final GridCoverageResource resource;
    private final double[][] resolutionSquared;
    private final Reference<GridCoverage>[] coverages;
    private final Envelope areaOfInterest;
    private final int[] readRanges;

    public MultiResolutionCoverageLoader(GridCoverageResource gridCoverageResource, Envelope envelope, int[] nArray) throws DataStoreException {
        this.resource = gridCoverageResource;
        this.areaOfInterest = envelope;
        this.readRanges = nArray;
        double[][] dArray = CollectionsExt.toArray(gridCoverageResource.getResolutions(), double[].class);
        if (dArray.length <= 1) {
            GridGeometry object = gridCoverageResource.getGridGeometry();
            if (dArray.length != 0) {
                dArray = MultiResolutionCoverageLoader.defaultResolutions(object, dArray[0]);
            } else if (object.isDefined(16)) {
                dArray = MultiResolutionCoverageLoader.defaultResolutions(object, object.getResolution(true));
            }
        }
        this.resolutionSquared = dArray;
        for (double[] dArray2 : dArray) {
            for (int i = 0; i < dArray2.length; ++i) {
                int n = i;
                dArray2[n] = dArray2[n] * dArray2[i];
            }
        }
        this.coverages = new Reference[Math.max(dArray.length, 1)];
        gridCoverageResource.setLoadingStrategy(RasterLoadingStrategy.AT_GET_TILE_TIME);
    }

    private static double[][] defaultResolutions(GridGeometry gridGeometry, double[] dArray) {
        int n;
        Object object;
        int n2 = 1;
        if (gridGeometry.isDefined(2)) {
            object = gridGeometry.getEnvelope();
            n = object.getDimension();
            while (--n >= 0) {
                double d = object.getSpan(n) / (512.0 * dArray[n]);
                int n3 = Math.getExponent(d);
                if (n3 >= 1023 || (n3 /= 3) <= n2) continue;
                n2 = n3;
            }
        } else {
            n2 = 4;
        }
        object = new double[n2][];
        object[0] = (Envelope)dArray;
        for (n = 1; n < n2; ++n) {
            dArray = (double[])dArray.clone();
            object[n] = (Envelope)dArray;
            int n4 = 0;
            while (n4 < dArray.length) {
                int n5 = n4++;
                dArray[n5] = dArray[n5] * 8.0;
            }
        }
        return object;
    }

    final int getLastLevel() {
        return Math.max(this.resolutionSquared.length - 1, 0);
    }

    final int findPyramidLevel(MathTransform mathTransform, LinearTransform linearTransform, DirectPosition directPosition) throws TransformException {
        int n = this.getLastLevel();
        if (n != 0) {
            LinearTransform linearTransform2 = linearTransform.inverse();
            Matrix matrix = linearTransform2.getMatrix();
            Matrix matrix2 = mathTransform != null && !mathTransform.isIdentity() ? mathTransform.inverse().derivative(directPosition) : null;
            int n2 = matrix.getNumCol() - 1;
            int n3 = matrix.getNumRow() - 1;
            int n4 = matrix2 != null ? matrix2.getNumRow() : n3;
            block0: for (int i = 0; i < n4; ++i) {
                double d;
                int n5;
                double d2 = 0.0;
                for (n5 = 0; n5 < n2; ++n5) {
                    if (matrix2 == null) {
                        d = matrix.getElement(i, n5);
                    } else {
                        d = 0.0;
                        for (int j = 0; j < n3; ++j) {
                            d += matrix2.getElement(i, j) * matrix.getElement(j, n5);
                        }
                    }
                    d2 += d * d;
                }
                n5 = n;
                d = Double.POSITIVE_INFINITY;
                while (true) {
                    double d3;
                    double d4 = this.resolutionSquared[n][i];
                    if (!(d3 > d2)) continue block0;
                    if (d4 < d) {
                        d = d4;
                        n5 = n;
                    }
                    if (n == 0) {
                        n = n5;
                        break block0;
                    }
                    --n;
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GridCoverage getOrLoad(int n) throws DataStoreException {
        Object object;
        Object object2;
        GridGeometry gridGeometry = this.coverages;
        synchronized (gridGeometry) {
            object2 = this.coverages[n];
            if (object2 != null) {
                object = ((Reference)object2).get();
                if (object != null) {
                    return object;
                }
                this.coverages[n] = null;
            }
        }
        gridGeometry = null;
        if (this.resolutionSquared.length != 0) {
            object2 = (double[])this.resolutionSquared[n].clone();
            for (int i = 0; i < ((Object)object2).length; ++i) {
                object2[i] = Math.sqrt((double)object2[i]);
            }
            object = MathTransforms.scale((double[])object2);
            gridGeometry = new GridGeometry(PixelInCell.CELL_CORNER, object, this.areaOfInterest, GridRoundingMode.ENCLOSING);
        }
        object2 = this.resource.read(this.getReadDomain(gridGeometry), this.readRanges);
        object = this.coverages;
        synchronized (this.coverages) {
            GridCoverage gridCoverage;
            Reference<GridCoverage> reference = this.coverages[n];
            if (reference != null && (gridCoverage = reference.get()) != null) {
                // ** MonitorExit[var4_4 /* !! */ ] (shouldn't be in output)
                return gridCoverage;
            }
            this.coverages[n] = new SoftReference<Object>(object2);
            // ** MonitorExit[var4_4 /* !! */ ] (shouldn't be in output)
            return object2;
        }
    }

    public final GridCoverage getOrLoad(GridGeometry gridGeometry, int[] nArray) throws DataStoreException {
        if (gridGeometry == null && this.areaOfInterest == null && Arrays.equals(this.readRanges, nArray)) {
            return this.getOrLoad(0);
        }
        if (gridGeometry == null) {
            gridGeometry = this.resource.getGridGeometry();
        }
        return this.resource.read(this.getReadDomain(gridGeometry), this.readRanges);
    }

    protected GridGeometry getReadDomain(GridGeometry gridGeometry) {
        return gridGeometry;
    }

    public String toString() {
        int n = this.getLastLevel();
        double d = this.magnitude(0);
        if (n != 0) {
            d = (this.magnitude(n) - d) / (double)n;
        }
        int n2 = Math.max(Math.min(DecimalFunctions.fractionDigitsForDelta(d, false), 6), 0);
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumFractionDigits(n2);
        numberFormat.setMaximumFractionDigits(n2);
        TableAppender tableAppender = new TableAppender("  ");
        tableAppender.setCellAlignment((byte)1);
        for (int i = 0; i <= n; ++i) {
            double[] dArray = this.resolutionSquared[i];
            for (double d2 : dArray) {
                tableAppender.append(numberFormat.format(Math.sqrt(d2)));
                tableAppender.nextColumn();
            }
            Object object = this.coverages[i];
            if (object != null && ((Reference)object).get() != null) {
                tableAppender.append("cached");
            }
            tableAppender.nextLine();
        }
        return tableAppender.toString();
    }

    private double magnitude(int n) {
        return Math.sqrt(Arrays.stream(this.resolutionSquared[n]).average().orElse(1.0));
    }
}

