/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.xml.stream;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.storage.io.ChannelFactory;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.internal.storage.io.Markable;
import org.apache.sis.internal.storage.xml.stream.FormattedWriter;
import org.apache.sis.internal.storage.xml.stream.InputType;
import org.apache.sis.internal.storage.xml.stream.OutputType;
import org.apache.sis.internal.storage.xml.stream.StaxDataStoreProvider;
import org.apache.sis.internal.storage.xml.stream.StaxStreamReader;
import org.apache.sis.internal.storage.xml.stream.StaxStreamWriter;
import org.apache.sis.internal.util.AbstractMap;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.io.InvalidSeekException;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.ConcurrentReadException;
import org.apache.sis.storage.ConcurrentWriteException;
import org.apache.sis.storage.DataStoreClosedException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.ForwardOnlyStorageException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;

public abstract class StaxDataStore
extends URIDataStore {
    protected final Locale locale;
    protected final TimeZone timezone;
    protected final Charset encoding;
    final Config configuration;
    private Object storage;
    private AutoCloseable stream;
    private long streamPosition;
    private final InputType storageToReader;
    private final OutputType storageToWriter;
    private XMLInputFactory inputFactory;
    private XMLOutputFactory outputFactory;
    private final ChannelFactory channelFactory;
    private final byte indentation;
    private byte state;
    private static final byte START = 0;
    private static final byte READING = 1;
    private static final byte WRITING = 2;
    private static final byte FINISHED = 3;

    protected StaxDataStore(StaxDataStoreProvider staxDataStoreProvider, StorageConnector storageConnector) throws DataStoreException {
        super((DataStoreProvider)staxDataStoreProvider, storageConnector);
        this.storage = storageConnector.getStorage();
        this.locale = (Locale)storageConnector.getOption(OptionKey.LOCALE);
        this.timezone = (TimeZone)storageConnector.getOption(OptionKey.TIMEZONE);
        this.encoding = (Charset)storageConnector.getOption(OptionKey.ENCODING);
        Integer n = (Integer)storageConnector.getOption(OptionKey.INDENTATION);
        this.indentation = (byte)(n == null ? 2 : (byte)Math.max(-1, Math.min(120, n)));
        this.configuration = new Config();
        this.storageToWriter = OutputType.forType(this.storage.getClass());
        this.storageToReader = InputType.forType(this.storage.getClass());
        if (this.storageToReader == null) {
            this.stream = (AutoCloseable)storageConnector.getStorageAs(InputStream.class);
        }
        if (this.stream == null && this.storage instanceof AutoCloseable) {
            this.stream = (AutoCloseable)this.storage;
        }
        this.channelFactory = (ChannelFactory)storageConnector.getStorageAs(ChannelFactory.class);
        storageConnector.closeAllExcept((Object)this.stream);
        try {
            this.mark();
        }
        catch (IOException iOException) {
            throw new DataStoreException((Throwable)iOException);
        }
    }

    private void mark() throws IOException {
        this.streamPosition = -1L;
        if (this.stream instanceof Markable) {
            Markable markable = (Markable)this.stream;
            this.streamPosition = markable.getStreamPosition();
            markable.mark();
        }
    }

    private boolean reset() throws IOException {
        if (this.streamPosition >= 0L) {
            try {
                Markable markable = (Markable)this.stream;
                markable.reset(this.streamPosition);
                markable.mark();
                this.state = 0;
                return true;
            }
            catch (InvalidSeekException invalidSeekException) {
                this.listeners.warning((Exception)invalidSeekException);
            }
        }
        return false;
    }

    public final StaxDataStoreProvider getProvider() {
        return (StaxDataStoreProvider)this.provider;
    }

    public final String getFormatName() {
        return this.provider.getShortName();
    }

    final XMLInputFactory inputFactory() {
        assert (Thread.holdsLock((Object)this));
        if (this.inputFactory == null) {
            this.inputFactory = XMLInputFactory.newInstance();
            this.inputFactory.setXMLReporter(this.configuration);
        }
        return this.inputFactory;
    }

    final XMLOutputFactory outputFactory() {
        assert (Thread.holdsLock((Object)this));
        if (this.outputFactory == null) {
            this.outputFactory = XMLOutputFactory.newInstance();
        }
        return this.outputFactory;
    }

    final synchronized XMLStreamReader createReader(StaxStreamReader staxStreamReader) throws Exception {
        Object object;
        Object object2 = this.storage;
        if (object2 == null) {
            throw new DataStoreClosedException(this.getLocale(), this.getFormatName(), new OpenOption[]{StandardOpenOption.READ});
        }
        AutoCloseable autoCloseable = this.stream;
        InputType inputType = this.storageToReader;
        switch (this.state) {
            default: {
                throw new AssertionError(this.state);
            }
            case 2: {
                throw new ConcurrentWriteException(this.getLocale(), this.getDisplayName());
            }
            case 0: {
                break;
            }
            case 3: {
                if (this.reset()) break;
                if (autoCloseable != null) {
                    this.stream = null;
                    autoCloseable.close();
                    autoCloseable = null;
                }
            }
            case 1: {
                if (inputType == InputType.NODE) break;
                object = this.getDisplayName();
                if (this.channelFactory == null) {
                    throw new ForwardOnlyStorageException(this.getLocale(), (String)object, new OpenOption[]{StandardOpenOption.READ});
                }
                autoCloseable = this.channelFactory.inputStream((String)object, this.listeners);
                object2 = autoCloseable;
                inputType = InputType.STREAM;
                if (this.stream != null) break;
                this.stream = autoCloseable;
                this.state = 0;
                this.mark();
            }
        }
        if (inputType == null) {
            if (this.storageToWriter != null && (object = this.storageToWriter.snapshot(object2)) != null) {
                XMLStreamReader xMLStreamReader = this.storageToWriter.inputType.create(this, object);
                staxStreamReader.stream = object;
                return xMLStreamReader;
            }
            inputType = InputType.STREAM;
            if ((autoCloseable = IOUtilities.toInputStream((AutoCloseable)autoCloseable)) == null) {
                throw new UnsupportedStorageException(this.getLocale(), this.getFormatName(), this.storage, new OpenOption[]{StandardOpenOption.READ});
            }
            object2 = autoCloseable;
            if (autoCloseable != this.stream) {
                this.stream = autoCloseable;
                this.mark();
            }
        }
        object = inputType.create(this, object2);
        staxStreamReader.stream = autoCloseable;
        this.state = 1;
        return object;
    }

    final synchronized XMLStreamWriter createWriter(StaxStreamWriter staxStreamWriter) throws DataStoreException, XMLStreamException, IOException {
        Object object = this.storage;
        if (object == null) {
            throw new DataStoreClosedException(this.getLocale(), this.getFormatName(), new OpenOption[]{StandardOpenOption.WRITE});
        }
        switch (this.state) {
            default: {
                throw new AssertionError(this.state);
            }
            case 1: {
                throw new ConcurrentReadException(this.getLocale(), this.getDisplayName());
            }
            case 2: {
                throw new ConcurrentWriteException(this.getLocale(), this.getDisplayName());
            }
            case 0: {
                break;
            }
            case 3: {
                if (this.reset()) break;
                throw new ForwardOnlyStorageException(this.getLocale(), this.getDisplayName(), new OpenOption[]{StandardOpenOption.WRITE});
            }
        }
        AutoCloseable autoCloseable = this.stream;
        OutputType outputType = this.storageToWriter;
        if (outputType == null) {
            outputType = OutputType.STREAM;
            if ((autoCloseable = IOUtilities.toOutputStream((AutoCloseable)autoCloseable)) == null) {
                throw new UnsupportedStorageException(this.getLocale(), this.getFormatName(), this.storage, new OpenOption[]{StandardOpenOption.WRITE});
            }
            object = autoCloseable;
            if (autoCloseable != this.stream) {
                this.stream = autoCloseable;
                this.mark();
            }
        }
        Object object2 = outputType.create(this, object);
        if (this.indentation >= 0) {
            object2 = new FormattedWriter((XMLStreamWriter)object2, this.indentation);
        }
        staxStreamWriter.stream = autoCloseable;
        this.state = (byte)2;
        return object2;
    }

    final synchronized boolean canClose(AutoCloseable autoCloseable) {
        if (autoCloseable == this.stream) {
            this.state = (byte)3;
            return false;
        }
        return true;
    }

    public synchronized void close() throws DataStoreException {
        AutoCloseable autoCloseable = this.stream;
        this.stream = null;
        this.storage = null;
        this.inputFactory = null;
        this.outputFactory = null;
        if (autoCloseable != null) {
            try {
                autoCloseable.close();
            }
            catch (Exception exception) {
                throw new DataStoreException((Throwable)exception);
            }
        }
    }

    private final class Config
    extends AbstractMap<String, Object>
    implements XMLReporter,
    Filter {
        Config() {
        }

        @Override
        public Object get(Object object) {
            if (object instanceof String) {
                switch ((String)object) {
                    case "org.apache.sis.xml.locale": {
                        return StaxDataStore.this.locale;
                    }
                    case "org.apache.sis.xml.timezone": {
                        return StaxDataStore.this.timezone;
                    }
                    case "org.apache.sis.xml.warningFilter": {
                        return this;
                    }
                }
            }
            return null;
        }

        @Override
        protected AbstractMap.EntryIterator<String, Object> entryIterator() {
            return new AbstractMap.KeyIterator(this, "org.apache.sis.xml.locale", "org.apache.sis.xml.timezone", "org.apache.sis.xml.warningFilter");
        }

        @Override
        public void report(String string, String string2, Object object, Location location) {
            LogRecord logRecord = new LogRecord(Level.WARNING, string);
            logRecord.setSourceClassName(((Object)((Object)StaxDataStore.this)).getClass().getCanonicalName());
            StaxDataStore.this.listeners.warning(logRecord);
        }

        @Override
        public boolean isLoggable(LogRecord logRecord) {
            logRecord.setLoggerName(null);
            StaxDataStore.this.listeners.warning(logRecord);
            return false;
        }

        @Override
        public String toString() {
            return Strings.toString(this.getClass(), "locale", StaxDataStore.this.locale, "timezone", StaxDataStore.this.timezone);
        }
    }
}

