/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.gpx;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.citation.DefaultResponsibility;
import org.apache.sis.metadata.iso.constraint.DefaultConstraints;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.metadata.citation.Series;
import org.opengis.metadata.constraint.LegalConstraints;
import org.opengis.metadata.constraint.Restriction;
import org.opengis.util.InternationalString;

public final class Copyright
implements LegalConstraints,
ResponsibleParty,
Citation,
CitationDate {
    @XmlAttribute(name="author", required=true)
    public String author;
    @XmlElement(name="year")
    public Integer year;
    @XmlElement(name="license")
    public URI license;

    public Copyright() {
    }

    private Copyright(LegalConstraints legalConstraints, Locale locale) {
        if (!(legalConstraints instanceof DefaultConstraints)) {
            return;
        }
        block0: for (DefaultResponsibility defaultResponsibility : ((DefaultConstraints)legalConstraints).getResponsibleParties()) {
            for (AbstractParty abstractParty : defaultResponsibility.getParties()) {
                this.author = Types.toString((InternationalString)abstractParty.getName(), (Locale)locale);
                if (this.author == null) continue;
                break block0;
            }
        }
        block2: for (DefaultResponsibility defaultResponsibility : ((DefaultConstraints)legalConstraints).getReferences()) {
            for (AbstractParty abstractParty : defaultResponsibility.getDates()) {
                Date date = abstractParty.getDate();
                if (date == null) continue;
                this.year = date.getYear() + 1900;
                break;
            }
            if (!(defaultResponsibility instanceof DefaultCitation)) continue;
            for (AbstractParty abstractParty : ((DefaultCitation)defaultResponsibility).getOnlineResources()) {
                this.license = abstractParty.getLinkage();
                if (this.license == null) continue;
                continue block2;
            }
        }
    }

    public static Copyright castOrCopy(LegalConstraints legalConstraints, Locale locale) {
        return legalConstraints == null || legalConstraints instanceof Copyright ? (Copyright)legalConstraints : new Copyright(legalConstraints, locale);
    }

    public Collection<Restriction> getAccessConstraints() {
        return Collections.singleton(Restriction.COPYRIGHT);
    }

    public Collection<Restriction> getUseConstraints() {
        if (this.license != null) {
            return Arrays.asList(Restriction.COPYRIGHT, Restriction.valueOf((String)"LICENCE"));
        }
        return Collections.singleton(Restriction.COPYRIGHT);
    }

    public Collection<InternationalString> getOtherConstraints() {
        return Collections.emptySet();
    }

    public Collection<InternationalString> getUseLimitations() {
        return Collections.emptySet();
    }

    public Role getRole() {
        return Role.OWNER;
    }

    public InternationalString getOrganisationName() {
        return null;
    }

    public InternationalString getPositionName() {
        return null;
    }

    public String getIndividualName() {
        return this.author;
    }

    public Contact getContactInfo() {
        return null;
    }

    public InternationalString getTitle() {
        return null;
    }

    public Collection<InternationalString> getAlternateTitles() {
        return Collections.emptySet();
    }

    public Collection<? extends CitationDate> getDates() {
        return this.thisOrEmpty(this.year != null);
    }

    public Date getDate() {
        if (this.year != null) {
            return new Date(this.year - 1900, 0, 1);
        }
        return null;
    }

    public DateType getDateType() {
        return DateType.valueOf((String)"IN_FORCE");
    }

    public InternationalString getEdition() {
        return null;
    }

    public Date getEditionDate() {
        return null;
    }

    public Collection<Identifier> getIdentifiers() {
        return Collections.emptySet();
    }

    public Collection<ResponsibleParty> getCitedResponsibleParties() {
        return Collections.emptySet();
    }

    public Collection<PresentationForm> getPresentationForms() {
        return Collections.singleton(PresentationForm.DOCUMENT_DIGITAL);
    }

    public Series getSeries() {
        return null;
    }

    public InternationalString getOtherCitationDetails() {
        return null;
    }

    @Deprecated
    public InternationalString getCollectiveTitle() {
        return null;
    }

    public String getISBN() {
        return null;
    }

    public String getISSN() {
        return null;
    }

    private Collection<Copyright> thisOrEmpty(boolean bl) {
        return bl ? Collections.singleton(this) : Collections.emptySet();
    }

    public boolean equals(Object object) {
        if (object instanceof Copyright) {
            Copyright copyright = (Copyright)object;
            return Objects.equals(this.author, copyright.author) && Objects.equals(this.year, copyright.year) && Objects.equals(this.license, copyright.license);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.author, this.year, this.license);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Copyright");
        if (this.year != null) {
            stringBuilder.append(' ').append(this.year);
        }
        if (this.author != null) {
            stringBuilder.append(' ').append(this.author);
        }
        if (this.license != null) {
            stringBuilder.append(System.lineSeparator()).append(this.license);
        }
        return stringBuilder.toString();
    }
}

