/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.util.GenericName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;

public final class ResourceDefinition {
    private static volatile NameSpace tableNS;
    private final GenericName name;
    final String query;

    private ResourceDefinition(GenericName genericName, String string) {
        this.name = genericName;
        this.query = string;
    }

    static ResourceDefinition[] wrap(GenericName[] genericNameArray, Map<?, ?> map) {
        int n;
        int n2 = genericNameArray != null ? genericNameArray.length : 0;
        ResourceDefinition[] resourceDefinitionArray = new ResourceDefinition[map != null ? map.size() + n2 : n2];
        for (n = 0; n < n2; ++n) {
            GenericName genericName = genericNameArray[n];
            ArgumentChecks.ensureNonNullElement("tables", n, genericName);
            resourceDefinitionArray[n] = new ResourceDefinition(genericName, null);
        }
        if (map != null) {
            n = 0;
            for (Map.Entry entry : map.entrySet()) {
                Object object = entry.getKey();
                ArgumentChecks.ensureNonNullElement("queries[#].key", n, object);
                GenericName genericName = object instanceof GenericName ? (GenericName)object : DefaultFactories.forBuildin(NameFactory.class).createLocalName(null, (CharSequence)object.toString());
                object = entry.getValue();
                ArgumentChecks.ensureNonNullElement("queries[#].value", n, object);
                String string = object.toString();
                ArgumentChecks.ensureNonEmpty("sql", string);
                resourceDefinitionArray[n2 + n] = new ResourceDefinition(genericName, string);
            }
        }
        return resourceDefinitionArray;
    }

    public static ResourceDefinition table(String string) {
        return ResourceDefinition.table(null, null, string);
    }

    public static ResourceDefinition table(String string, String string2, String string3) {
        int n;
        ArgumentChecks.ensureNonNull("tablePattern", string3);
        if (string != null) {
            n = 3;
            if (string2 == null) {
                string2 = "%";
            }
        } else {
            n = string2 != null && !string2.equals("%") ? 2 : 1;
        }
        CharSequence[] charSequenceArray = new String[n];
        int n2 = 0;
        switch (n) {
            default: {
                throw new AssertionError(n);
            }
            case 3: {
                charSequenceArray[n2++] = string;
            }
            case 2: {
                charSequenceArray[n2++] = string2;
            }
            case 1: 
        }
        charSequenceArray[n2] = string3;
        NameFactory nameFactory = DefaultFactories.forBuildin(NameFactory.class);
        NameSpace nameSpace = tableNS;
        if (nameSpace == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>(4);
            hashMap.put("separator", ".");
            hashMap.put("separator.head", ":");
            tableNS = nameSpace = nameFactory.createNameSpace((GenericName)nameFactory.createLocalName(null, (CharSequence)"database"), hashMap);
        }
        return new ResourceDefinition(nameFactory.createGenericName(nameSpace, charSequenceArray), null);
    }

    public static ResourceDefinition query(String string, String string2) {
        ArgumentChecks.ensureNonEmpty("name", string);
        ArgumentChecks.ensureNonEmpty("query", string2);
        NameFactory nameFactory = DefaultFactories.forBuildin(NameFactory.class);
        return new ResourceDefinition((GenericName)nameFactory.createLocalName(null, (CharSequence)string), string2);
    }

    public GenericName getName() {
        return this.name;
    }

    public Optional<String> getQuery() {
        return Optional.ofNullable(this.query);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ResourceDefinition) {
            ResourceDefinition resourceDefinition = (ResourceDefinition)object;
            return this.name.equals((Object)resourceDefinition.name) && Objects.equals(this.query, resourceDefinition.query);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() * 71 + Objects.hashCode(this.query);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Resource[\"").append(this.name).append('\"');
        if (this.query != null) {
            stringBuilder.append(" = ").append(this.query);
        }
        return stringBuilder.append(']').toString();
    }
}

