/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.stream;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.BaseStream;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.sis.internal.stream.BaseStreamWrapper;

public abstract class StreamWrapper<T>
extends BaseStreamWrapper<T, Stream<T>>
implements Stream<T> {
    Stream<T> source;

    StreamWrapper() {
    }

    protected StreamWrapper(Stream<T> stream) {
        super(stream);
        this.source = stream;
    }

    @Override
    protected final Stream<T> source() {
        if (this.source != null) {
            return this.source;
        }
        throw this.inactive();
    }

    protected final Stream<T> delegate() {
        BaseStream baseStream = this.source();
        this.source = null;
        return baseStream;
    }

    private Stream<T> update(Stream<T> stream) {
        if (this.source == null) {
            return stream;
        }
        this.source = stream;
        return this;
    }

    @Override
    public Stream<T> parallel() {
        return this.update((Stream)this.source().parallel());
    }

    @Override
    public Stream<T> sequential() {
        return this.update((Stream)this.source().sequential());
    }

    @Override
    public Stream<T> unordered() {
        return this.update((Stream)this.source().unordered());
    }

    @Override
    public Stream<T> filter(Predicate<? super T> predicate) {
        return this.update(this.source().filter(predicate));
    }

    @Override
    public <R> Stream<R> map(Function<? super T, ? extends R> function) {
        return this.delegate().map(function);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> toIntFunction) {
        return this.delegate().mapToInt(toIntFunction);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> toLongFunction) {
        return this.delegate().mapToLong(toLongFunction);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> toDoubleFunction) {
        return this.delegate().mapToDouble(toDoubleFunction);
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> function) {
        return this.delegate().flatMap(function);
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> function) {
        return this.delegate().flatMapToInt(function);
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> function) {
        return this.delegate().flatMapToLong(function);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> function) {
        return this.delegate().flatMapToDouble(function);
    }

    @Override
    public Stream<T> distinct() {
        return this.update(this.source().distinct());
    }

    @Override
    public Stream<T> sorted() {
        return this.update(this.source().sorted());
    }

    @Override
    public Stream<T> sorted(Comparator<? super T> comparator) {
        return this.update(this.source().sorted(comparator));
    }

    @Override
    public Stream<T> peek(Consumer<? super T> consumer) {
        return this.update(this.source().peek(consumer));
    }

    @Override
    public Stream<T> limit(long l) {
        return this.update(this.source().limit(l));
    }

    @Override
    public Stream<T> skip(long l) {
        return this.update(this.source().skip(l));
    }

    @Override
    public void forEach(Consumer<? super T> consumer) {
        this.source().forEach(consumer);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> consumer) {
        this.source().forEachOrdered(consumer);
    }

    @Override
    public T reduce(T t, BinaryOperator<T> binaryOperator) {
        return this.source().reduce(t, binaryOperator);
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> binaryOperator) {
        return this.source().reduce(binaryOperator);
    }

    @Override
    public <U> U reduce(U u, BiFunction<U, ? super T, U> biFunction, BinaryOperator<U> binaryOperator) {
        return this.source().reduce(u, biFunction, binaryOperator);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> biConsumer, BiConsumer<R, R> biConsumer2) {
        return this.source().collect(supplier, biConsumer, biConsumer2);
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.source().collect(collector);
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.source().min(comparator);
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.source().max(comparator);
    }

    @Override
    public long count() {
        return this.source().count();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.source().anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return this.source().allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.source().noneMatch(predicate);
    }

    @Override
    public Optional<T> findFirst() {
        return this.source().findFirst();
    }

    @Override
    public Optional<T> findAny() {
        return this.source().findAny();
    }

    @Override
    public Iterator<T> iterator() {
        return this.source().iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.source().spliterator();
    }

    @Override
    public Object[] toArray() {
        return this.source().toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> intFunction) {
        return this.source().toArray(intFunction);
    }

    @Override
    public Stream<T> onClose(Runnable runnable) {
        return this.update((Stream)this.source().onClose(runnable));
    }
}

