/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.stream;

import java.util.DoubleSummaryStatistics;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.sis.internal.stream.BaseStreamWrapper;

public abstract class DoubleStreamWrapper
extends BaseStreamWrapper<Double, DoubleStream>
implements DoubleStream {
    private DoubleStream source;

    protected DoubleStreamWrapper(DoubleStream doubleStream) {
        super(doubleStream);
        this.source = doubleStream;
    }

    @Override
    final DoubleStream source() {
        if (this.source != null) {
            return this.source;
        }
        throw this.inactive();
    }

    final DoubleStream delegate() {
        DoubleStream doubleStream = this.source();
        this.source = null;
        return doubleStream;
    }

    private DoubleStream update(DoubleStream doubleStream) {
        if (this.source == null) {
            return doubleStream;
        }
        this.source = doubleStream;
        return this;
    }

    @Override
    public DoubleStream parallel() {
        return this.update(this.source().parallel());
    }

    @Override
    public DoubleStream sequential() {
        return this.update(this.source().sequential());
    }

    @Override
    public DoubleStream unordered() {
        return this.update((DoubleStream)this.source().unordered());
    }

    @Override
    public DoubleStream filter(DoublePredicate doublePredicate) {
        return this.update(this.source().filter(doublePredicate));
    }

    @Override
    public DoubleStream map(DoubleUnaryOperator doubleUnaryOperator) {
        return this.update(this.source().map(doubleUnaryOperator));
    }

    @Override
    public <U> Stream<U> mapToObj(DoubleFunction<? extends U> doubleFunction) {
        return this.delegate().mapToObj(doubleFunction);
    }

    @Override
    public IntStream mapToInt(DoubleToIntFunction doubleToIntFunction) {
        return this.delegate().mapToInt(doubleToIntFunction);
    }

    @Override
    public LongStream mapToLong(DoubleToLongFunction doubleToLongFunction) {
        return this.delegate().mapToLong(doubleToLongFunction);
    }

    @Override
    public DoubleStream flatMap(DoubleFunction<? extends DoubleStream> doubleFunction) {
        return this.update(this.source().flatMap(doubleFunction));
    }

    @Override
    public DoubleStream distinct() {
        return this.update(this.source().distinct());
    }

    @Override
    public DoubleStream sorted() {
        return this.update(this.source().sorted());
    }

    @Override
    public DoubleStream peek(DoubleConsumer doubleConsumer) {
        return this.update(this.source().peek(doubleConsumer));
    }

    @Override
    public DoubleStream limit(long l) {
        return this.update(this.source().limit(l));
    }

    @Override
    public DoubleStream skip(long l) {
        return this.update(this.source().skip(l));
    }

    @Override
    public void forEach(DoubleConsumer doubleConsumer) {
        this.source().forEach(doubleConsumer);
    }

    @Override
    public void forEachOrdered(DoubleConsumer doubleConsumer) {
        this.source().forEachOrdered(doubleConsumer);
    }

    @Override
    public double reduce(double d, DoubleBinaryOperator doubleBinaryOperator) {
        return this.source().reduce(d, doubleBinaryOperator);
    }

    @Override
    public OptionalDouble reduce(DoubleBinaryOperator doubleBinaryOperator) {
        return this.source().reduce(doubleBinaryOperator);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> objDoubleConsumer, BiConsumer<R, R> biConsumer) {
        return this.source().collect(supplier, objDoubleConsumer, biConsumer);
    }

    @Override
    public double sum() {
        return this.source().sum();
    }

    @Override
    public OptionalDouble min() {
        return this.source().min();
    }

    @Override
    public OptionalDouble max() {
        return this.source().max();
    }

    @Override
    public long count() {
        return this.source().count();
    }

    @Override
    public OptionalDouble average() {
        return this.source().average();
    }

    @Override
    public DoubleSummaryStatistics summaryStatistics() {
        return this.source().summaryStatistics();
    }

    @Override
    public boolean anyMatch(DoublePredicate doublePredicate) {
        return this.source().anyMatch(doublePredicate);
    }

    @Override
    public boolean allMatch(DoublePredicate doublePredicate) {
        return this.source().allMatch(doublePredicate);
    }

    @Override
    public boolean noneMatch(DoublePredicate doublePredicate) {
        return this.source().noneMatch(doublePredicate);
    }

    @Override
    public OptionalDouble findFirst() {
        return this.source().findFirst();
    }

    @Override
    public OptionalDouble findAny() {
        return this.source().findAny();
    }

    @Override
    public Stream<Double> boxed() {
        return this.delegate().boxed();
    }

    @Override
    public PrimitiveIterator.OfDouble iterator() {
        return this.source().iterator();
    }

    @Override
    public Spliterator.OfDouble spliterator() {
        return this.source().spliterator();
    }

    @Override
    public double[] toArray() {
        return this.source().toArray();
    }

    @Override
    public DoubleStream onClose(Runnable runnable) {
        return this.update((DoubleStream)this.source().onClose(runnable));
    }
}

