/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.stream;

import java.util.stream.BaseStream;
import org.apache.sis.util.ArgumentChecks;

public abstract class BaseStreamWrapper<T, S extends BaseStream<T, S>>
implements BaseStream<T, S> {
    S toClose;

    BaseStreamWrapper() {
    }

    protected BaseStreamWrapper(S s) {
        ArgumentChecks.ensureNonNull("source", s);
        this.toClose = s;
    }

    abstract S source();

    final IllegalStateException inactive() {
        return new IllegalStateException("This stream is no longer active.");
    }

    @Override
    public boolean isParallel() {
        return this.source().isParallel();
    }

    @Override
    public void close() {
        S s = this.toClose;
        if (s != null) {
            this.toClose = null;
            s.close();
        }
    }
}

