/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.postgis;

import java.awt.geom.AffineTransform;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.image.PixelIterator;
import org.apache.sis.internal.sql.feature.InfoStatements;
import org.apache.sis.internal.sql.feature.Resources;
import org.apache.sis.internal.sql.postgis.Band;
import org.apache.sis.internal.sql.postgis.RasterFormat;
import org.apache.sis.internal.storage.io.ChannelDataOutput;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class RasterWriter
extends RasterFormat {
    private ByteOrder byteOrder = ByteOrder.nativeOrder();
    private AffineTransform gridToCRS;
    private int srid;
    private Number[] noDataValues;

    public RasterWriter(InfoStatements infoStatements) {
        super(infoStatements);
    }

    public void reset() {
        this.byteOrder = ByteOrder.nativeOrder();
        this.gridToCRS = null;
        this.srid = 0;
    }

    public void setGridToCRS(GridGeometry gridGeometry) throws Exception {
        if (gridGeometry.isDefined(1)) {
            CoordinateReferenceSystem coordinateReferenceSystem = gridGeometry.getCoordinateReferenceSystem();
            if (this.spatialRefSys != null) {
                this.srid = this.spatialRefSys.findSRID(coordinateReferenceSystem);
            } else {
                Integer n = IdentifiedObjects.lookupEPSG((IdentifiedObject)coordinateReferenceSystem);
                if (n == null) {
                    throw new IllegalArgumentException(Resources.format((short)15, IdentifiedObjects.getDisplayName((IdentifiedObject)coordinateReferenceSystem, null)));
                }
                this.srid = n;
            }
        } else {
            this.srid = 0;
        }
        this.gridToCRS = AffineTransforms2D.castOrCopy(gridGeometry.isDefined(8) ? gridGeometry.getGridToCRS(ANCHOR) : null);
    }

    public void setNodataValues(List<? extends SampleDimension> list) {
        this.noDataValues = new Number[list.size()];
        for (int i = 0; i < this.noDataValues.length; ++i) {
            SampleDimension sampleDimension = list.get(i);
            this.noDataValues[i] = sampleDimension.getBackground().orElse(null);
        }
    }

    public void write(GridCoverage gridCoverage, ChannelDataOutput channelDataOutput) throws Exception {
        this.setGridToCRS(gridCoverage.getGridGeometry());
        this.setNodataValues(gridCoverage.getSampleDimensions());
        this.write(gridCoverage.render(null), channelDataOutput);
    }

    public void write(RenderedImage renderedImage, ChannelDataOutput channelDataOutput) throws IOException {
        Raster raster = renderedImage.getNumXTiles() == 1 && renderedImage.getNumYTiles() == 1 ? renderedImage.getTile(renderedImage.getMinTileX(), renderedImage.getMinTileY()) : renderedImage.getData();
        this.write(raster, channelDataOutput);
    }

    public void write(Raster raster, ChannelDataOutput channelDataOutput) throws IOException {
        int n;
        if (this.gridToCRS == null) {
            this.gridToCRS = new AffineTransform();
        }
        SampleModel sampleModel = raster.getSampleModel();
        int n2 = sampleModel.getNumBands();
        int n3 = raster.getWidth();
        int n4 = raster.getHeight();
        boolean bl = false;
        int n5 = sampleModel.getDataType();
        int n6 = Band.bufferToPixelType(n5);
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            if (n2 == 1) {
                bl = ((SinglePixelPackedSampleModel)sampleModel).getScanlineStride() == n3;
            } else {
                n = Arrays.stream(sampleModel.getSampleSize()).max().orElse(0);
                if (n >= 1 && n <= 16) {
                    n5 = n <= 8 ? 0 : 1;
                    n6 = Band.bufferToPixelType(n5);
                }
            }
        } else if (sampleModel instanceof MultiPixelPackedSampleModel) {
            if (n5 == 0) {
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                int n7 = multiPixelPackedSampleModel.getPixelBitStride();
                bl = multiPixelPackedSampleModel.getScanlineStride() * 8 == n3 * n7;
                n6 = Band.sizeToPixelType(n7);
            }
        } else if (sampleModel instanceof ComponentSampleModel) {
            bl = ((ComponentSampleModel)sampleModel).getScanlineStride() == n3;
        }
        channelDataOutput.buffer.order(this.byteOrder);
        channelDataOutput.writeByte(ByteOrder.LITTLE_ENDIAN.equals(this.byteOrder) ? 1 : 0);
        channelDataOutput.writeShort(0);
        channelDataOutput.writeShort(RasterWriter.ensureUnsignedShort("numBands", n2));
        channelDataOutput.writeDouble(this.gridToCRS.getScaleX());
        channelDataOutput.writeDouble(this.gridToCRS.getScaleY());
        channelDataOutput.writeDouble(this.gridToCRS.getTranslateX());
        channelDataOutput.writeDouble(this.gridToCRS.getTranslateY());
        channelDataOutput.writeDouble(this.gridToCRS.getShearX());
        channelDataOutput.writeDouble(this.gridToCRS.getShearY());
        channelDataOutput.writeInt(this.srid);
        channelDataOutput.writeShort(RasterWriter.ensureUnsignedShort("width", n3));
        channelDataOutput.writeShort(RasterWriter.ensureUnsignedShort("height", n4));
        for (n = 0; n < n2; ++n) {
            Object object;
            Number number = this.noDataValues != null && n < this.noDataValues.length ? (Number)this.noDataValues[n] : (Number)null;
            Band band = new Band(n6, number);
            channelDataOutput.writeByte(band.header);
            switch (n5) {
                case 1: 
                case 2: {
                    channelDataOutput.writeShort(number != null ? number.intValue() : 0);
                    break;
                }
                case 0: {
                    channelDataOutput.writeByte(number != null ? number.intValue() : 0);
                    break;
                }
                case 3: {
                    channelDataOutput.writeInt(number != null ? number.intValue() : 0);
                    break;
                }
                case 4: {
                    channelDataOutput.writeFloat(number != null ? number.floatValue() : Float.NaN);
                    break;
                }
                case 5: {
                    channelDataOutput.writeDouble(number != null ? number.doubleValue() : Double.NaN);
                    break;
                }
                default: {
                    throw new RasterFormatException(Errors.format((short)163, n5));
                }
            }
            if (bl) {
                object = raster.getDataBuffer();
                int n8 = ((DataBuffer)object).getOffsets()[n];
                int n9 = n3 * n4;
                switch (n5) {
                    case 0: {
                        channelDataOutput.write(((DataBufferByte)object).getData(n), n8, n9);
                        break;
                    }
                    case 1: {
                        channelDataOutput.writeShorts(((DataBufferUShort)object).getData(n), n8, n9);
                        break;
                    }
                    case 2: {
                        channelDataOutput.writeShorts(((DataBufferShort)object).getData(n), n8, n9);
                        break;
                    }
                    case 3: {
                        channelDataOutput.writeInts(((DataBufferInt)object).getData(n), n8, n9);
                        break;
                    }
                    case 4: {
                        channelDataOutput.writeFloats(((DataBufferFloat)object).getData(n), n8, n9);
                        break;
                    }
                    case 5: {
                        channelDataOutput.writeDoubles(((DataBufferDouble)object).getData(n), n8, n9);
                    }
                }
                continue;
            }
            object = new PixelIterator.Builder().create(raster);
            while (((PixelIterator)object).next()) {
                switch (n5) {
                    case 1: 
                    case 2: {
                        channelDataOutput.writeShort(((PixelIterator)object).getSample(n));
                        break;
                    }
                    case 0: {
                        channelDataOutput.writeByte(((PixelIterator)object).getSample(n));
                        break;
                    }
                    case 3: {
                        channelDataOutput.writeInt(((PixelIterator)object).getSample(n));
                        break;
                    }
                    case 4: {
                        channelDataOutput.writeFloat((float)((PixelIterator)object).getSample(n));
                        break;
                    }
                    case 5: {
                        channelDataOutput.writeDouble((double)((PixelIterator)object).getSample(n));
                    }
                }
            }
        }
    }

    private static int ensureUnsignedShort(String string, int n) {
        if ((n & 0xFFFF0000) == 0) {
            return n;
        }
        throw new RasterFormatException(Errors.format((short)166, string, 1, 65535, n));
    }
}

