/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.postgis;

import java.io.InputStream;
import java.sql.ResultSet;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.internal.sql.feature.BinaryEncoding;
import org.apache.sis.internal.sql.feature.InfoStatements;
import org.apache.sis.internal.sql.feature.ValueGetter;
import org.apache.sis.internal.sql.postgis.ExtendedInfo;
import org.apache.sis.internal.sql.postgis.RasterReader;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class RasterGetter
extends ValueGetter<GridCoverage> {
    private final CoordinateReferenceSystem defaultCRS;
    private final BinaryEncoding encoding;

    RasterGetter(CoordinateReferenceSystem coordinateReferenceSystem, BinaryEncoding binaryEncoding) {
        super(GridCoverage.class);
        this.defaultCRS = coordinateReferenceSystem;
        this.encoding = binaryEncoding;
    }

    @Override
    public GridCoverage getValue(InfoStatements infoStatements, ResultSet resultSet, int n) throws Exception {
        InputStream inputStream = resultSet.getBinaryStream(n);
        if (inputStream != null && infoStatements instanceof ExtendedInfo) {
            inputStream = this.encoding.decode(inputStream);
            RasterReader rasterReader = ((ExtendedInfo)infoStatements).getRasterReader();
            rasterReader.defaultCRS = this.defaultCRS;
            return rasterReader.readAsCoverage(rasterReader.channel(inputStream));
        }
        return null;
    }
}

