/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.Collection;
import org.apache.sis.internal.sql.feature.BinaryEncoding;
import org.apache.sis.internal.sql.feature.InfoStatements;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.math.Vector;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Numbers;

public abstract class ValueGetter<T> {
    protected final Class<? extends T> valueType;

    protected ValueGetter(Class<? extends T> clazz) {
        ArgumentChecks.ensureNonNull("valueType", clazz);
        this.valueType = clazz;
    }

    public abstract T getValue(InfoStatements var1, ResultSet var2, int var3) throws Exception;

    protected static Collection<?> toCollection(InfoStatements infoStatements, ValueGetter<?> valueGetter, java.sql.Array array) throws Exception {
        if (array == null) {
            return null;
        }
        Object object = array.getArray();
        if (valueGetter == null && infoStatements != null) {
            valueGetter = infoStatements.getComponentMapping(array);
        }
        Class<Object> clazz = Numbers.primitiveToWrapper(object.getClass().getComponentType());
        if (valueGetter != null && !valueGetter.valueType.isAssignableFrom(clazz)) {
            clazz = Numbers.wrapperToPrimitive(valueGetter.valueType);
            int n = Array.getLength(object);
            object = Array.newInstance(clazz, n);
            try (ResultSet resultSet = array.getResultSet();){
                while (resultSet.next()) {
                    Array.set(object, resultSet.getInt(1) - 1, valueGetter.getValue(infoStatements, resultSet, 2));
                }
            }
        }
        array.free();
        if (Numbers.isNumber(clazz)) {
            return Vector.create(object, true);
        }
        return UnmodifiableArrayList.wrap((Object[])object);
    }

    static final class AsArray
    extends ValueGetter<Collection<?>> {
        public final ValueGetter<?> cmget;
        public static final AsArray INSTANCE = new AsArray(null);

        AsArray(ValueGetter<?> valueGetter) {
            super(Collection.class);
            this.cmget = valueGetter;
        }

        @Override
        public Collection<?> getValue(InfoStatements infoStatements, ResultSet resultSet, int n) throws Exception {
            return AsArray.toCollection(infoStatements, this.cmget, resultSet.getArray(n));
        }
    }

    static final class AsOffsetTime
    extends ValueGetter<OffsetTime> {
        public static final AsOffsetTime INSTANCE = new AsOffsetTime();

        private AsOffsetTime() {
            super(OffsetTime.class);
        }

        @Override
        public OffsetTime getValue(InfoStatements infoStatements, ResultSet resultSet, int n) throws SQLException {
            Time time = resultSet.getTime(n);
            if (time == null) {
                return null;
            }
            int n2 = time.getTimezoneOffset();
            return time.toLocalTime().atOffset(ZoneOffset.ofHoursMinutes(n2 / 60, n2 % 60));
        }
    }

    static final class AsOffsetDateTime
    extends ValueGetter<OffsetDateTime> {
        public static final AsOffsetDateTime INSTANCE = new AsOffsetDateTime();

        private AsOffsetDateTime() {
            super(OffsetDateTime.class);
        }

        @Override
        public OffsetDateTime getValue(InfoStatements infoStatements, ResultSet resultSet, int n) throws SQLException {
            Timestamp timestamp = resultSet.getTimestamp(n);
            if (timestamp == null) {
                return null;
            }
            int n2 = timestamp.getTimezoneOffset();
            return timestamp.toInstant().atOffset(ZoneOffset.ofHoursMinutes(n2 / 60, n2 % 60));
        }
    }

    static final class AsInstant
    extends ValueGetter<Instant> {
        public static final AsInstant INSTANCE = new AsInstant();

        private AsInstant() {
            super(Instant.class);
        }

        @Override
        public Instant getValue(InfoStatements infoStatements, ResultSet resultSet, int n) throws SQLException {
            Timestamp timestamp = resultSet.getTimestamp(n);
            return timestamp != null ? timestamp.toInstant() : null;
        }
    }

    static final class AsLocalTime
    extends ValueGetter<LocalTime> {
        public static final AsLocalTime INSTANCE = new AsLocalTime();

        private AsLocalTime() {
            super(LocalTime.class);
        }

        @Override
        public LocalTime getValue(InfoStatements infoStatements, ResultSet resultSet, int n) throws SQLException {
            Time time = resultSet.getTime(n);
            return time != null ? time.toLocalTime() : null;
        }
    }

    static final class AsDate
    extends ValueGetter<Date> {
        public static final AsDate INSTANCE = new AsDate();

        private AsDate() {
            super(Date.class);
        }

        @Override
        public Date getValue(InfoStatements infoStatements, ResultSet resultSet, int n) throws SQLException {
            return resultSet.getDate(n);
        }
    }

    static final class AsBoolean
    extends ValueGetter<Boolean> {
        public static final AsBoolean INSTANCE = new AsBoolean();

        private AsBoolean() {
            super(Boolean.class);
        }

        @Override
        public Boolean getValue(InfoStatements infoStatements, ResultSet resultSet, int n) throws SQLException {
            boolean bl = resultSet.getBoolean(n);
            return resultSet.wasNull() ? null : Boolean.valueOf(bl);
        }
    }

    static final class AsBigDecimal
    extends ValueGetter<BigDecimal> {
        public static final AsBigDecimal INSTANCE = new AsBigDecimal();

        private AsBigDecimal() {
            super(BigDecimal.class);
        }

        @Override
        public BigDecimal getValue(InfoStatements infoStatements, ResultSet resultSet, int n) throws SQLException {
            return resultSet.getBigDecimal(n);
        }
    }

    static final class AsDouble
    extends ValueGetter<Double> {
        public static final AsDouble INSTANCE = new AsDouble();

        private AsDouble() {
            super(Double.class);
        }

        @Override
        public Double getValue(InfoStatements infoStatements, ResultSet resultSet, int n) throws SQLException {
            double d = resultSet.getDouble(n);
            return resultSet.wasNull() ? null : Double.valueOf(d);
        }
    }

    static final class AsFloat
    extends ValueGetter<Float> {
        public static final AsFloat INSTANCE = new AsFloat();

        private AsFloat() {
            super(Float.class);
        }

        @Override
        public Float getValue(InfoStatements infoStatements, ResultSet resultSet, int n) throws SQLException {
            float f = resultSet.getFloat(n);
            return resultSet.wasNull() ? null : Float.valueOf(f);
        }
    }

    static final class AsLong
    extends ValueGetter<Long> {
        public static final AsLong INSTANCE = new AsLong();

        private AsLong() {
            super(Long.class);
        }

        @Override
        public Long getValue(InfoStatements infoStatements, ResultSet resultSet, int n) throws SQLException {
            long l = resultSet.getLong(n);
            return resultSet.wasNull() ? null : Long.valueOf(l);
        }
    }

    static final class AsInteger
    extends ValueGetter<Integer> {
        public static final AsInteger INSTANCE = new AsInteger();

        private AsInteger() {
            super(Integer.class);
        }

        @Override
        public Integer getValue(InfoStatements infoStatements, ResultSet resultSet, int n) throws SQLException {
            int n2 = resultSet.getInt(n);
            return resultSet.wasNull() ? null : Integer.valueOf(n2);
        }
    }

    static final class AsShort
    extends ValueGetter<Short> {
        public static final AsShort INSTANCE = new AsShort();

        private AsShort() {
            super(Short.class);
        }

        @Override
        public Short getValue(InfoStatements infoStatements, ResultSet resultSet, int n) throws SQLException {
            short s = resultSet.getShort(n);
            return resultSet.wasNull() ? null : Short.valueOf(s);
        }
    }

    static final class AsByte
    extends ValueGetter<Byte> {
        public static final AsByte INSTANCE = new AsByte();

        private AsByte() {
            super(Byte.class);
        }

        @Override
        public Byte getValue(InfoStatements infoStatements, ResultSet resultSet, int n) throws SQLException {
            byte by = resultSet.getByte(n);
            return resultSet.wasNull() ? null : Byte.valueOf(by);
        }
    }

    static final class AsBytes
    extends ValueGetter<byte[]> {
        private final BinaryEncoding encoding;
        public static final AsBytes INSTANCE = new AsBytes(BinaryEncoding.RAW);
        public static final AsBytes HEXADECIMAL = new AsBytes(BinaryEncoding.HEXADECIMAL);

        private AsBytes(BinaryEncoding binaryEncoding) {
            super(byte[].class);
            this.encoding = binaryEncoding;
        }

        @Override
        public byte[] getValue(InfoStatements infoStatements, ResultSet resultSet, int n) throws SQLException {
            return this.encoding.getBytes(resultSet, n);
        }
    }

    static final class AsString
    extends ValueGetter<String> {
        public static final AsString INSTANCE = new AsString();

        private AsString() {
            super(String.class);
        }

        @Override
        public String getValue(InfoStatements infoStatements, ResultSet resultSet, int n) throws SQLException {
            return resultSet.getString(n);
        }
    }

    static final class AsObject
    extends ValueGetter<Object> {
        public static final AsObject INSTANCE = new AsObject();

        private AsObject() {
            super(Object.class);
        }

        @Override
        public Object getValue(InfoStatements infoStatements, ResultSet resultSet, int n) throws Exception {
            Collection<?> collection = resultSet.getObject(n);
            if (collection instanceof java.sql.Array) {
                collection = AsObject.toCollection(infoStatements, null, (java.sql.Array)((Object)collection));
            }
            return collection;
        }
    }
}

