/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.util.Objects;
import java.util.function.Consumer;
import org.apache.sis.internal.sql.feature.Analyzer;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.storage.sql.SQLStoreProvider;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;

public class TableReference {
    public final String catalog;
    public final String schema;
    public final String table;
    final String freeText;

    TableReference(String string, String string2, String string3, String string4) {
        this.catalog = string;
        this.schema = string2;
        this.table = string3;
        this.freeText = Strings.trimOrNull(string4);
    }

    TableReference(GenericName genericName, String string) {
        String[] stringArray = TableReference.splitName(genericName);
        this.catalog = stringArray[2];
        this.schema = stringArray[1];
        this.table = stringArray[0];
        this.freeText = Strings.trimOrNull(string);
    }

    static String[] splitName(GenericName genericName) {
        Object[] objectArray = (String[])genericName.getParsedNames().stream().map(LocalName::toString).toArray(String[]::new);
        ArraysExt.reverse(objectArray);
        return (String[])ArraysExt.resize(objectArray, 3);
    }

    final GenericName getName(Analyzer analyzer) {
        return analyzer.nameFactory.createLocalName(analyzer.namespace(Strings.trimOrNull(this.catalog), Strings.trimOrNull(this.schema)), (CharSequence)this.table);
    }

    public final boolean equals(Object object) {
        if (object instanceof TableReference) {
            TableReference tableReference = (TableReference)object;
            return this.table.equals(tableReference.table) && Objects.equals(this.schema, tableReference.schema) && Objects.equals(this.catalog, tableReference.catalog);
        }
        return false;
    }

    public final int hashCode() {
        return this.table.hashCode() + 31 * Objects.hashCode(this.schema) + 37 * Objects.hashCode(this.catalog);
    }

    static TreeTable.Node newChild(TreeTable.Node node, String string) {
        TreeTable.Node node2 = node.newChild();
        node2.setValue(TableColumn.NAME, string);
        return node2;
    }

    static String toString(Object object, Consumer<TreeTable.Node> consumer) {
        DefaultTreeTable defaultTreeTable = new DefaultTreeTable(TableColumn.NAME);
        TreeTable.Node node = defaultTreeTable.getRoot();
        node.setValue(TableColumn.NAME, object.getClass().getSimpleName());
        consumer.accept(node);
        return defaultTreeTable.toString();
    }

    public String toString() {
        return SQLStoreProvider.createTableName(Strings.trimOrNull(this.catalog), Strings.trimOrNull(this.schema), this.table).toString();
    }
}

