/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.sis.internal.metadata.sql.SQLUtilities;
import org.apache.sis.internal.sql.feature.Analyzer;
import org.apache.sis.internal.sql.feature.Column;
import org.apache.sis.internal.sql.feature.FeatureAnalyzer;
import org.apache.sis.internal.sql.feature.InfoStatements;
import org.apache.sis.internal.sql.feature.Relation;
import org.apache.sis.internal.sql.feature.SchemaModifier;
import org.apache.sis.internal.sql.feature.TableReference;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.storage.DataStoreException;

final class TableAnalyzer
extends FeatureAnalyzer {
    private final TableReference dependencyOf;
    private final String tableEsc;
    private final String schemaEsc;

    TableAnalyzer(Analyzer analyzer, TableReference tableReference, TableReference tableReference2) throws SQLException {
        super(analyzer, tableReference);
        this.dependencyOf = tableReference2;
        this.tableEsc = this.escape(tableReference.table);
        this.schemaEsc = this.escape(tableReference.schema);
        try (ResultSet resultSet = analyzer.metadata.getPrimaryKeys(tableReference.catalog, tableReference.schema, tableReference.table);){
            while (resultSet.next()) {
                this.primaryKey.add(analyzer.getUniqueString(resultSet, "COLUMN_NAME"));
            }
        }
    }

    private String escape(String string) {
        return SQLUtilities.escape((String)string, (String)this.analyzer.escape);
    }

    @Override
    final Relation[] getForeignerKeys(Relation.Direction direction) throws SQLException, DataStoreException {
        ArrayList<Relation> arrayList = new ArrayList<Relation>();
        boolean bl = direction == Relation.Direction.IMPORT;
        try (ResultSet resultSet = bl ? this.analyzer.metadata.getImportedKeys(this.id.catalog, this.id.schema, this.id.table) : this.analyzer.metadata.getExportedKeys(this.id.catalog, this.id.schema, this.id.table);){
            if (resultSet.next()) {
                do {
                    Relation relation;
                    if ((relation = new Relation(this.analyzer, direction, resultSet)).equals(this.dependencyOf)) {
                        if (!bl) continue;
                        SchemaModifier schemaModifier = this.analyzer.customizer;
                        boolean bl2 = relation.excluded = schemaModifier == null || !schemaModifier.isCyclicAssociationAllowed(this.id);
                    }
                    if (bl) {
                        this.addForeignerKeys(relation);
                    } else if (relation.excluded) continue;
                    arrayList.add(relation);
                } while (!resultSet.isClosed());
            }
        }
        int n = arrayList.size();
        return n != 0 ? arrayList.toArray(new Relation[n]) : Relation.EMPTY;
    }

    @Override
    final Column[] createAttributes() throws Exception {
        Object object;
        LinkedHashMap<String, Column> linkedHashMap = new LinkedHashMap<String, Column>();
        String string = this.analyzer.metadata.getIdentifierQuoteString();
        try (AutoCloseable autoCloseable = this.analyzer.metadata.getColumns(this.id.catalog, this.schemaEsc, this.tableEsc, null);){
            while (autoCloseable.next()) {
                object = new Column(this.analyzer, (ResultSet)autoCloseable, string);
                if (linkedHashMap.put(((Column)object).name, (Column)object) == null) continue;
                throw this.duplicatedColumn((Column)object);
            }
        }
        autoCloseable = this.analyzer.spatialInformation;
        if (autoCloseable != null) {
            ((InfoStatements)autoCloseable).completeIntrospection(this.id, linkedHashMap);
        }
        object = new ArrayList();
        for (Column column : linkedHashMap.values()) {
            if (!this.createAttribute(column)) continue;
            object.add(column);
        }
        return object.toArray(new Column[object.size()]);
    }

    @Override
    public String getRemarks() throws SQLException {
        if (this.id instanceof Relation) {
            try (ResultSet resultSet = this.analyzer.metadata.getTables(this.id.catalog, this.schemaEsc, this.tableEsc, null);){
                while (resultSet.next()) {
                    String string = Strings.trimOrNull(this.analyzer.getUniqueString(resultSet, "REMARKS"));
                    if (string == null) continue;
                    String string2 = string;
                    return string2;
                }
            }
        }
        return super.getRemarks();
    }
}

