/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.internal.sql.feature.Analyzer;
import org.apache.sis.internal.sql.feature.PrimaryKey;
import org.apache.sis.internal.sql.feature.Table;
import org.apache.sis.internal.sql.feature.TableReference;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.InternalDataStoreException;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.resources.Errors;

final class Relation
extends TableReference {
    static final Relation[] EMPTY = new Relation[0];
    private final Map<String, String> columns;
    private Table searchTable;
    String propertyName;
    private boolean useFullKey;
    boolean excluded;

    Relation(Analyzer analyzer, Direction direction, ResultSet resultSet) throws SQLException, DataStoreContentException {
        super(analyzer.getUniqueString(resultSet, direction.catalog), analyzer.getUniqueString(resultSet, direction.schema), analyzer.getUniqueString(resultSet, direction.table), analyzer.getUniqueString(resultSet, "FK_NAME"));
        Set<String> set;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        do {
            if (linkedHashMap.put((String)((Object)(set = analyzer.getUniqueString(resultSet, direction.column))), analyzer.getUniqueString(resultSet, direction.containerColumn)) != null) {
                throw new DataStoreContentException(analyzer.resources().getString((short)5, set));
            }
            if (resultSet.next()) continue;
            resultSet.close();
            break;
        } while (this.table.equals(resultSet.getString(direction.table)) && Objects.equals(this.schema, resultSet.getString(direction.schema)) && Objects.equals(this.catalog, resultSet.getString(direction.catalog)));
        this.columns = CollectionsExt.compact(linkedHashMap);
        switch (direction) {
            case IMPORT: {
                set = this.columns.values();
                break;
            }
            case EXPORT: {
                set = this.columns.keySet();
                break;
            }
            default: {
                throw new AssertionError((Object)direction);
            }
        }
        this.propertyName = CollectionsExt.singletonOrNull(set);
        if (this.propertyName == null) {
            this.propertyName = this.freeText;
            if (this.propertyName == null) {
                this.propertyName = this.table;
            }
        }
    }

    final void setPropertyName(String string, int n) {
        if (this.columns.size() > 1) {
            this.propertyName = this.freeText;
        }
        if (this.propertyName == null) {
            this.propertyName = n == 0 ? string : string + '-' + n;
        }
    }

    final String getPropertyName() {
        return this.propertyName;
    }

    final void setSearchTable(Analyzer analyzer, Table table, PrimaryKey primaryKey, Direction direction) throws DataStoreException {
        Collection<String> collection;
        boolean bl;
        boolean bl2 = bl = this.searchTable != null;
        if (bl || !this.equals(table.name)) {
            throw new InternalDataStoreException(bl ? analyzer.internalError() : super.toString());
        }
        this.searchTable = table;
        switch (direction) {
            case IMPORT: {
                collection = this.columns.keySet();
                break;
            }
            case EXPORT: {
                collection = this.columns.values();
                break;
            }
            default: {
                throw new AssertionError((Object)direction);
            }
        }
        List<String> list = primaryKey.getColumns();
        this.useFullKey = collection.containsAll(list);
        if (this.useFullKey && this.columns.size() >= 2) {
            HashMap<String, String> hashMap = new HashMap<String, String>(this.columns);
            this.columns.clear();
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = string = iterator.next();
                block4 : switch (direction) {
                    case IMPORT: {
                        string2 = (String)hashMap.remove(string);
                        break;
                    }
                    case EXPORT: {
                        string = null;
                        Iterator iterator2 = hashMap.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            Map.Entry entry = iterator2.next();
                            if (!string2.equals(entry.getValue())) continue;
                            string = (String)entry.getKey();
                            iterator2.remove();
                            break block4;
                        }
                        break;
                    }
                }
                if (string != null && string2 != null && this.columns.put(string, string2) == null) continue;
                throw new InternalDataStoreException(analyzer.internalError());
            }
            if (!hashMap.isEmpty()) {
                throw new DataStoreContentException(analyzer.resources().getString((short)7, this.freeText, CollectionsExt.first(hashMap.keySet())));
            }
        }
    }

    final Table getSearchTable() throws InternalDataStoreException {
        if (this.searchTable != null) {
            return this.searchTable;
        }
        throw new InternalDataStoreException(super.toString());
    }

    final boolean isSearchTableDeferred() {
        return !this.excluded && this.searchTable == null;
    }

    final Collection<String> getSearchColumns() {
        return this.columns.keySet();
    }

    final Collection<String> getOwnerColumns() {
        return this.columns.values();
    }

    final boolean useFullKey() {
        return this.useFullKey;
    }

    final boolean isInverseOf(Relation relation) {
        return this.columns.size() == relation.columns.size() && this.columns.keySet().containsAll(relation.columns.values()) && relation.columns.keySet().containsAll(this.columns.values());
    }

    final void startFollowing(List<Relation> list) throws InternalDataStoreException {
        int n = list.size();
        while (--n >= 0) {
            if (list.get(n) != this) continue;
            throw new InternalDataStoreException(Errors.format((short)18));
        }
        list.add(this);
    }

    final void endFollowing(List<Relation> list) throws InternalDataStoreException {
        int n = list.size() - 1;
        if (n < 0 || list.remove(n) != this) {
            throw new InternalDataStoreException();
        }
    }

    void appendTo(TreeTable.Node node, String string) {
        String string2 = super.toString();
        if (this.freeText != null) {
            string2 = this.freeText + " \u27f6 " + string2;
        }
        if (this.excluded) {
            string2 = string2 + " (excluded)";
        }
        TreeTable.Node node2 = Relation.newChild(node, string2);
        for (Map.Entry<String, String> entry : this.columns.entrySet()) {
            Relation.newChild(node2, entry.getValue() + string + entry.getKey());
        }
    }

    @Override
    public String toString() {
        return Relation.toString(this, node -> this.appendTo((TreeTable.Node)node, " \u2014 "));
    }

    static enum Direction {
        IMPORT("PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKCOLUMN_NAME"),
        EXPORT("FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "PKCOLUMN_NAME");

        final String catalog;
        final String schema;
        final String table;
        final String column;
        final String containerColumn;

        private Direction(String string2, String string3, String string4, String string5, String string6) {
            this.catalog = string2;
            this.schema = string3;
            this.table = string4;
            this.column = string5;
            this.containerColumn = string6;
        }
    }
}

