/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.feature.GeometryType;
import org.apache.sis.internal.metadata.sql.SQLBuilder;
import org.apache.sis.internal.referencing.DefinitionVerifier;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.sql.feature.Column;
import org.apache.sis.internal.sql.feature.Database;
import org.apache.sis.internal.sql.feature.Resources;
import org.apache.sis.internal.sql.feature.TableReference;
import org.apache.sis.internal.sql.feature.ValueGetter;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.WKTFormat;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.util.Localized;
import org.apache.sis.util.Utilities;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class InfoStatements
implements Localized,
AutoCloseable {
    static final String SPATIAL_REF_SYS = "SPATIAL_REF_SYS";
    static final String GEOMETRY_COLUMNS = "GEOMETRY_COLUMNS";
    private final Database<?> database;
    private final Connection connection;
    protected PreparedStatement geometryColumns;
    private PreparedStatement wktFromSrid;
    private PreparedStatement sridFromCRS;
    private WKTFormat wktReader;

    protected InfoStatements(Database<?> database, Connection connection) {
        this.database = database;
        this.connection = connection;
    }

    @Override
    public final Locale getLocale() {
        return this.database.listeners.getLocale();
    }

    public final ValueGetter<?> getComponentMapping(Array array) throws SQLException {
        return this.database.getMapping(new Column(array.getBaseType(), array.getBaseTypeName()));
    }

    private void appendFrom(SQLBuilder sQLBuilder, String string) {
        this.database.appendFunctionCall(sQLBuilder.append(" FROM "), string);
        sQLBuilder.append(" WHERE ");
    }

    private static SQLBuilder appendCondition(SQLBuilder sQLBuilder, char c, String string) {
        return sQLBuilder.append(c).append('_').append(string).append(" = ?");
    }

    protected final PreparedStatement prepareIntrospectionStatement(String string, char c, String string2, String string3) throws SQLException {
        SQLBuilder sQLBuilder = new SQLBuilder(this.database).append("SELECT ").append(c).append('_').append(string2).append(", SRID ");
        if (string3 != null) {
            sQLBuilder.append(", ").append(string3);
        }
        this.appendFrom(sQLBuilder, string);
        if (this.database.supportsCatalogs) {
            InfoStatements.appendCondition(sQLBuilder, c, "TABLE_CATALOG").append(" AND ");
        }
        if (this.database.supportsSchemas) {
            InfoStatements.appendCondition(sQLBuilder, c, "TABLE_SCHEMA").append(" AND ");
        }
        InfoStatements.appendCondition(sQLBuilder, c, "TABLE_NAME");
        return this.connection.prepareStatement(sQLBuilder.toString());
    }

    public void completeIntrospection(TableReference tableReference, Map<String, Column> map) throws Exception {
        if (this.geometryColumns == null) {
            this.geometryColumns = this.prepareIntrospectionStatement(GEOMETRY_COLUMNS, 'F', "GEOMETRY_COLUMN", "GEOMETRY_TYPE");
        }
        this.configureSpatialColumns(this.geometryColumns, tableReference, map, GeometryTypeEncoding.NUMERIC);
    }

    protected final void configureSpatialColumns(PreparedStatement preparedStatement, TableReference tableReference, Map<String, Column> map, GeometryTypeEncoding geometryTypeEncoding) throws Exception {
        int n = 0;
        if (this.database.supportsCatalogs) {
            preparedStatement.setString(++n, tableReference.catalog);
        }
        if (this.database.supportsSchemas) {
            preparedStatement.setString(++n, tableReference.schema);
        }
        preparedStatement.setString(++n, tableReference.table);
        try (ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                Column column = map.get(resultSet.getString(1));
                if (column == null) continue;
                CoordinateReferenceSystem coordinateReferenceSystem = this.fetchCRS(resultSet.getInt(2));
                GeometryType geometryType = null;
                if (geometryTypeEncoding != null && (geometryType = geometryTypeEncoding.parse(resultSet, 3)) == null) {
                    geometryType = GeometryType.GEOMETRY;
                }
                column.makeSpatial(this, geometryType, coordinateReferenceSystem);
            }
        }
    }

    public final CoordinateReferenceSystem fetchCRS(int n) throws Exception {
        if (n <= 0) {
            return null;
        }
        return this.database.cacheOfCRS.getOrCreate(n, () -> this.parseCRS(n));
    }

    private CoordinateReferenceSystem parseCRS(int n) throws Exception {
        SQLBuilder sQLBuilder;
        if (this.wktFromSrid == null) {
            sQLBuilder = new SQLBuilder(this.database);
            sQLBuilder.append("SELECT auth_name, auth_srid, srtext");
            this.appendFrom(sQLBuilder, SPATIAL_REF_SYS);
            sQLBuilder.append("srid=?");
            this.wktFromSrid = this.connection.prepareStatement(sQLBuilder.toString());
        }
        this.wktFromSrid.setInt(1, n);
        sQLBuilder = null;
        NoSuchAuthorityCodeException noSuchAuthorityCodeException = null;
        LogRecord logRecord = null;
        try (ResultSet resultSet = this.wktFromSrid.executeQuery();){
            while (resultSet.next()) {
                Warnings warnings;
                Object object;
                String string;
                CoordinateReferenceSystem coordinateReferenceSystem = null;
                String string2 = resultSet.getString(1);
                if (string2 != null && !string2.isEmpty()) {
                    int n2 = resultSet.getInt(2);
                    if (!resultSet.wasNull()) {
                        try {
                            string = CRS.getAuthorityFactory((String)string2);
                            coordinateReferenceSystem = string.createCoordinateReferenceSystem(Integer.toString(n2));
                        }
                        catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException2) {
                            noSuchAuthorityCodeException = noSuchAuthorityCodeException2;
                        }
                    }
                }
                CoordinateReferenceSystem coordinateReferenceSystem2 = null;
                string = resultSet.getString(3);
                if (string != null && !string.isEmpty()) {
                    try {
                        object = this.wktReader().parseObject(string);
                    }
                    catch (ParseException parseException) {
                        if (noSuchAuthorityCodeException != null) {
                            parseException.addSuppressed(noSuchAuthorityCodeException);
                        }
                        throw parseException;
                    }
                    if (object instanceof CoordinateReferenceSystem) {
                        coordinateReferenceSystem2 = (CoordinateReferenceSystem)object;
                    } else {
                        throw this.invalidSRID((short)11, ReferencingUtilities.getInterface((Object)object), n, noSuchAuthorityCodeException);
                    }
                }
                object = DefinitionVerifier.compare(coordinateReferenceSystem2, coordinateReferenceSystem, (Locale)this.getLocale());
                if (object.recommendation == null) continue;
                if (sQLBuilder == null) {
                    sQLBuilder = object.recommendation;
                } else if (!sQLBuilder.equals((Object)object.recommendation)) {
                    throw this.invalidSRID((short)9, SPATIAL_REF_SYS, n, noSuchAuthorityCodeException);
                }
                if ((logRecord = object.warning(false)) != null || coordinateReferenceSystem2 == null || (warnings = this.wktReader.getWarnings()) == null) continue;
                logRecord = new LogRecord(Level.WARNING, warnings.toString(this.getLocale()));
            }
        }
        if (sQLBuilder == null) {
            if (noSuchAuthorityCodeException != null) {
                throw noSuchAuthorityCodeException;
            }
            throw this.invalidSRID((short)10, SPATIAL_REF_SYS, n, null);
        }
        if (logRecord != null) {
            logRecord.setLoggerName("org.apache.sis.sql");
            logRecord.setSourceClassName(this.getClass().getName());
            logRecord.setSourceMethodName("fetchCRS");
            this.database.listeners.warning(logRecord);
        }
        return sQLBuilder;
    }

    private DataStoreContentException invalidSRID(short s, Object object, int n, NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
        DataStoreContentException dataStoreContentException = new DataStoreContentException(Resources.forLocale(this.getLocale()).getString(s, object, n));
        if (noSuchAuthorityCodeException != null) {
            dataStoreContentException.addSuppressed((Throwable)noSuchAuthorityCodeException);
        }
        return dataStoreContentException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int findSRID(CoordinateReferenceSystem coordinateReferenceSystem) throws Exception {
        Object object;
        if (coordinateReferenceSystem == null) {
            return 0;
        }
        Object object2 = this.database.cacheOfSRID;
        synchronized (object2) {
            object = this.database.cacheOfSRID.get(coordinateReferenceSystem);
            if (object != null) {
                return (Integer)object;
            }
        }
        object2 = new HashSet();
        object = null;
        CoordinateReferenceSystem coordinateReferenceSystem2 = coordinateReferenceSystem;
        Exception exception = null;
        block14: while (true) {
            IdentifiedObjectFinder identifiedObjectFinder = coordinateReferenceSystem2.getIdentifiers().iterator();
            block15: while (true) {
                Object object3;
                int n;
                String string;
                if (identifiedObjectFinder.hasNext()) {
                    String string2;
                    ReferenceIdentifier referenceIdentifier = (ReferenceIdentifier)identifiedObjectFinder.next();
                    string = referenceIdentifier.getCodeSpace();
                    if (string == null || !object2.add(new AbstractMap.SimpleImmutableEntry<String, String>(string, string2 = referenceIdentifier.getCode()))) continue;
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (exception == null) {
                            exception = numberFormatException;
                            continue;
                        }
                        exception.addSuppressed(numberFormatException);
                        continue;
                    }
                    if (this.sridFromCRS == null) {
                        object3 = new SQLBuilder(this.database);
                        object3.append("SELECT srtext, srid");
                        this.appendFrom((SQLBuilder)object3, SPATIAL_REF_SYS);
                        object3.append("auth_name=? AND auth_srid=?");
                        this.sridFromCRS = this.connection.prepareStatement(object3.toString());
                    }
                } else {
                    if (object == null) {
                        identifiedObjectFinder = IdentifiedObjects.newFinder((String)"EPSG");
                        identifiedObjectFinder.setIgnoringAxes(true);
                        object = identifiedObjectFinder.find((IdentifiedObject)coordinateReferenceSystem).iterator();
                    }
                    if (!object.hasNext()) {
                        throw new DataStoreReferencingException(Resources.format((short)15, IdentifiedObjects.getDisplayName((IdentifiedObject)coordinateReferenceSystem, null)), exception);
                    }
                    coordinateReferenceSystem2 = (IdentifiedObject)object.next();
                    continue block14;
                }
                this.sridFromCRS.setString(1, string);
                this.sridFromCRS.setInt(2, n);
                object3 = this.sridFromCRS.executeQuery();
                try {
                    while (true) {
                        if (!object3.next()) continue block15;
                        String string3 = object3.getString(1);
                        if (string3 == null || string3.isEmpty()) continue;
                        try {
                            Object object4 = this.wktReader().parseObject(string3);
                            if (!Utilities.equalsApproximately(object4, coordinateReferenceSystem)) continue;
                            int n2 = object3.getInt(2);
                            WeakHashMap<CoordinateReferenceSystem, Integer> weakHashMap = this.database.cacheOfSRID;
                            synchronized (weakHashMap) {
                                this.database.cacheOfSRID.put(coordinateReferenceSystem, n2);
                            }
                            int n3 = n2;
                            return n3;
                        }
                        catch (ParseException parseException) {
                            if (exception == null) {
                                exception = parseException;
                                continue;
                            }
                            exception.addSuppressed(parseException);
                        }
                    }
                }
                finally {
                    if (object3 == null) continue;
                    object3.close();
                    continue;
                }
                break;
            }
            break;
        }
    }

    private WKTFormat wktReader() {
        if (this.wktReader == null) {
            this.wktReader = new WKTFormat(null, null);
            this.wktReader.setConvention(Convention.WKT1_COMMON_UNITS);
        }
        return this.wktReader;
    }

    @Override
    public void close() throws SQLException {
        if (this.geometryColumns != null) {
            this.geometryColumns.close();
            this.geometryColumns = null;
        }
        if (this.wktFromSrid != null) {
            this.wktFromSrid.close();
            this.wktFromSrid = null;
        }
        if (this.sridFromCRS != null) {
            this.sridFromCRS.close();
            this.sridFromCRS = null;
        }
    }

    protected static enum GeometryTypeEncoding {
        NUMERIC,
        TEXTUAL{

            @Override
            GeometryType parse(ResultSet resultSet, int n) throws SQLException {
                return GeometryType.forName(resultSet.getString(n));
            }
        };


        GeometryType parse(ResultSet resultSet, int n) throws SQLException {
            int n2 = resultSet.getInt(n);
            return resultSet.wasNull() ? null : GeometryType.forBinaryType(n2);
        }
    }
}

