/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.util.OptionalInt;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.sql.feature.BinaryEncoding;
import org.apache.sis.internal.sql.feature.InfoStatements;
import org.apache.sis.internal.sql.feature.ValueGetter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class GeometryGetter<G, V extends G>
extends ValueGetter<V> {
    private final Geometries<G> geometryFactory;
    private final CoordinateReferenceSystem defaultCRS;
    private final BinaryEncoding encoding;

    GeometryGetter(Geometries<G> geometries, Class<V> clazz, CoordinateReferenceSystem coordinateReferenceSystem, BinaryEncoding binaryEncoding) {
        super(clazz);
        this.geometryFactory = geometries;
        this.defaultCRS = coordinateReferenceSystem;
        this.encoding = binaryEncoding;
    }

    @Override
    public V getValue(InfoStatements infoStatements, ResultSet resultSet, int n) throws Exception {
        OptionalInt optionalInt;
        byte[] byArray = this.encoding.getBytes(resultSet, n);
        if (byArray == null) {
            return null;
        }
        GeometryWrapper<G> geometryWrapper = this.geometryFactory.parseWKB(ByteBuffer.wrap(byArray));
        CoordinateReferenceSystem coordinateReferenceSystem = this.defaultCRS;
        if (infoStatements != null && (optionalInt = geometryWrapper.getSRID()).isPresent()) {
            coordinateReferenceSystem = infoStatements.fetchCRS(optionalInt.getAsInt());
        }
        if (coordinateReferenceSystem != null) {
            geometryWrapper.setCoordinateReferenceSystem(coordinateReferenceSystem);
        }
        return (V)this.valueType.cast(geometryWrapper.implementation());
    }
}

