/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.internal.geoapi.filter.SortBy;
import org.apache.sis.internal.geoapi.filter.SortOrder;
import org.apache.sis.internal.geoapi.filter.SortProperty;
import org.apache.sis.internal.metadata.sql.SQLBuilder;
import org.apache.sis.internal.sql.feature.FeatureAdapter;
import org.apache.sis.internal.sql.feature.InfoStatements;
import org.apache.sis.internal.sql.feature.Table;
import org.apache.sis.storage.InternalDataStoreException;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.WeakValueHashMap;

final class FeatureIterator
implements Spliterator<AbstractFeature>,
AutoCloseable {
    static final int CHARACTERISTICS = 256;
    private final FeatureAdapter adapter;
    private final PreparedStatement statement;
    private ResultSet result;
    private final long estimatedSize;
    private final InfoStatements spatialInformation;
    private final FeatureIterator[] dependencies;

    FeatureIterator(Table table, Connection connection, boolean bl, String string, SortBy<? super AbstractFeature> sortBy, long l, long l2) throws SQLException, InternalDataStoreException {
        this.adapter = table.adapter(connection);
        this.spatialInformation = table.database.isSpatial() ? table.database.createInfoStatements(connection) : null;
        String string2 = this.adapter.sql;
        if (bl || string != null || sortBy != null || l > 0L || l2 > 0L) {
            SQLBuilder sQLBuilder = new SQLBuilder(table.database).append(string2);
            if (bl) {
                sQLBuilder.insertDistinctAfterSelect();
            }
            if (string != null) {
                sQLBuilder.append(" WHERE ").append(string);
            }
            if (sortBy != null) {
                String string3 = " ORDER BY ";
                for (SortProperty<? super AbstractFeature> sortProperty : sortBy.getSortProperties()) {
                    sQLBuilder.append(string3).appendIdentifier(sortProperty.getValueReference().getXPath());
                    SortOrder sortOrder = sortProperty.getSortOrder();
                    if (sortOrder != null) {
                        sQLBuilder.append(' ').append(sortOrder.toSQL());
                    }
                    string3 = ", ";
                }
            }
            string2 = sQLBuilder.appendFetchPage(l, l2).toString();
        }
        this.result = connection.createStatement().executeQuery(string2);
        this.dependencies = new FeatureIterator[this.adapter.dependencies.length];
        this.statement = null;
        this.estimatedSize = string == null ? Math.min(table.countRows(connection.getMetaData(), bl, true), l + l2) - l : 0L;
    }

    private FeatureIterator(FeatureAdapter featureAdapter, Connection connection, InfoStatements infoStatements) throws SQLException {
        this.spatialInformation = infoStatements;
        this.adapter = featureAdapter;
        this.statement = connection.prepareStatement(featureAdapter.sql);
        this.dependencies = new FeatureIterator[featureAdapter.dependencies.length];
        this.estimatedSize = 0L;
    }

    private FeatureIterator dependency(int n) throws SQLException {
        FeatureIterator featureIterator = this.dependencies[n];
        if (featureIterator == null) {
            this.dependencies[n] = featureIterator = new FeatureIterator(this.adapter.dependencies[n], this.result.getStatement().getConnection(), this.spatialInformation);
        }
        return featureIterator;
    }

    @Override
    public int characteristics() {
        return 256;
    }

    @Override
    public long estimateSize() {
        return this.estimatedSize > 0L ? this.estimatedSize : Long.MAX_VALUE;
    }

    @Override
    public Spliterator<AbstractFeature> trySplit() {
        return null;
    }

    @Override
    public boolean tryAdvance(Consumer<? super AbstractFeature> consumer) {
        try {
            return this.fetch(consumer, false);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BackingStoreException(exception);
        }
    }

    @Override
    public void forEachRemaining(Consumer<? super AbstractFeature> consumer) {
        try {
            this.fetch(consumer, true);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BackingStoreException(exception);
        }
    }

    private boolean fetch(Consumer<? super AbstractFeature> consumer, boolean bl) throws Exception {
        while (this.result.next()) {
            AbstractFeature abstractFeature = this.adapter.createFeature(this.spatialInformation, this.result);
            for (int i = 0; i < this.dependencies.length; ++i) {
                FeatureIterator featureIterator;
                WeakValueHashMap<?, Object> weakValueHashMap = null;
                Object object = null;
                Object object2 = null;
                if (i < this.adapter.importCount) {
                    object = this.adapter.getCacheKey(this.result, i);
                    if (object == null) continue;
                    weakValueHashMap = this.adapter.dependencies[i].instances;
                    object2 = weakValueHashMap.get(object);
                }
                if (object2 == null) {
                    featureIterator = this.dependency(i);
                    this.adapter.setForeignerKeys(this.result, featureIterator.statement, i);
                    object2 = featureIterator.fetchReferenced(abstractFeature);
                }
                if (weakValueHashMap != null && (featureIterator = weakValueHashMap.putIfAbsent(object, object2)) != null) {
                    object2 = featureIterator;
                }
                abstractFeature.setPropertyValue(this.adapter.associationNames[i], object2);
            }
            consumer.accept(abstractFeature);
            if (bl) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object fetchReferenced(AbstractFeature abstractFeature) throws Exception {
        Iterator iterator;
        ArrayList arrayList = new ArrayList();
        try {
            iterator = this.statement.executeQuery();
            try {
                this.result = iterator;
                this.fetch(arrayList::add, true);
            }
            finally {
                if (iterator != null) {
                    iterator.close();
                }
            }
        }
        finally {
            this.result = null;
        }
        if (abstractFeature != null && this.adapter.deferredAssociation != null) {
            for (AbstractFeature abstractFeature2 : arrayList) {
                abstractFeature2.setPropertyValue(this.adapter.deferredAssociation, abstractFeature);
            }
        }
        switch (arrayList.size()) {
            case 0: {
                iterator = null;
                break;
            }
            case 1: {
                iterator = arrayList.get(0);
                break;
            }
            default: {
                iterator = arrayList;
            }
        }
        return iterator;
    }

    @Override
    public void close() throws SQLException {
        ResultSet resultSet;
        if (this.spatialInformation != null) {
            this.spatialInformation.close();
        }
        if (this.statement != null) {
            this.statement.close();
        }
        if ((resultSet = this.result) != null) {
            this.result = null;
            Statement statement = resultSet.getStatement();
            try (Connection connection = statement.getConnection();){
                resultSet.close();
                statement.close();
                for (FeatureIterator featureIterator : this.dependencies) {
                    if (featureIterator == null) continue;
                    featureIterator.close();
                }
            }
        }
    }
}

