/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.lang.reflect.Array;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.internal.metadata.sql.SQLBuilder;
import org.apache.sis.internal.sql.feature.Column;
import org.apache.sis.internal.sql.feature.InfoStatements;
import org.apache.sis.internal.sql.feature.Relation;
import org.apache.sis.internal.sql.feature.Resources;
import org.apache.sis.internal.sql.feature.Table;
import org.apache.sis.storage.InternalDataStoreException;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.WeakValueHashMap;

final class FeatureAdapter {
    private static final FeatureAdapter[] EMPTY = new FeatureAdapter[0];
    private final DefaultFeatureType featureType;
    private final Column[] attributes;
    final String[] associationNames;
    final String deferredAssociation;
    final FeatureAdapter[] dependencies;
    final int importCount;
    private final int[][] foreignerKeyIndices;
    final WeakValueHashMap<?, Object> instances;
    private final Class<?> keyComponentClass;
    final String sql;

    FeatureAdapter(Table table, DatabaseMetaData databaseMetaData) throws SQLException, InternalDataStoreException {
        this(table, databaseMetaData, new ArrayList<Relation>(), null);
    }

    private FeatureAdapter(Table table, DatabaseMetaData databaseMetaData, List<Relation> list, Relation relation) throws SQLException, InternalDataStoreException {
        this.featureType = table.featureType;
        this.attributes = table.attributes;
        this.keyComponentClass = table.primaryKey != null ? table.primaryKey.valueClass.getComponentType() : null;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        SQLBuilder sQLBuilder = new SQLBuilder(table.database).append("SELECT ");
        for (Column object22 : this.attributes) {
            FeatureAdapter.appendColumn(sQLBuilder, object22.label, hashMap);
        }
        int n = table.importedKeys.length + table.exportedKeys.length;
        if (n == 0) {
            this.importCount = 0;
            this.dependencies = EMPTY;
            this.associationNames = null;
            this.foreignerKeyIndices = null;
            this.deferredAssociation = null;
        } else {
            String string = null;
            FeatureAdapter[] featureAdapterArray = new FeatureAdapter[n];
            String[] stringArray = new String[n];
            Object object = new int[n][];
            n = 0;
            for (Relation relation2 : table.importedKeys) {
                if (relation2.excluded) continue;
                if (relation2 != relation) {
                    relation2.startFollowing(list);
                    stringArray[n] = relation2.propertyName;
                    object[n] = FeatureAdapter.getColumnIndices(sQLBuilder, relation2, hashMap);
                    featureAdapterArray[n] = new FeatureAdapter(relation2.getSearchTable(), databaseMetaData, list, relation);
                    relation2.endFollowing(list);
                    ++n;
                    continue;
                }
                string = relation2.propertyName;
            }
            this.importCount = n;
            for (Relation relation2 : table.exportedKeys) {
                if (relation2.excluded) continue;
                relation2.startFollowing(list);
                Table table2 = relation2.getSearchTable();
                Relation relation3 = table2.getInverseOf(relation2, table.name);
                stringArray[n] = relation2.propertyName;
                object[n] = FeatureAdapter.getColumnIndices(sQLBuilder, relation2, hashMap);
                featureAdapterArray[n] = new FeatureAdapter(table2, databaseMetaData, list, relation3);
                relation2.endFollowing(list);
                ++n;
            }
            if (n != 0) {
                this.dependencies = ArraysExt.resize(featureAdapterArray, n);
                this.associationNames = ArraysExt.resize(stringArray, n);
                this.foreignerKeyIndices = (int[][])ArraysExt.resize(object, n);
            } else {
                this.dependencies = EMPTY;
                this.associationNames = null;
                this.foreignerKeyIndices = null;
            }
            this.deferredAssociation = string;
        }
        table.appendFromClause(sQLBuilder);
        if (list.isEmpty()) {
            this.instances = null;
        } else {
            Relation relation4 = list.get(list.size() - 1);
            String string = " WHERE ";
            for (Object object : relation4.getSearchColumns()) {
                sQLBuilder.append(string).appendIdentifier((String)object).append("=?");
                string = " AND ";
            }
            this.instances = relation4.useFullKey() ? table.instanceForPrimaryKeys() : new WeakValueHashMap(Object.class);
        }
        this.sql = sQLBuilder.toString();
    }

    private static int appendColumn(SQLBuilder sQLBuilder, String string, Map<String, Integer> map) throws InternalDataStoreException {
        int n = map.size();
        if (n != 0) {
            sQLBuilder.append(", ");
        }
        sQLBuilder.appendIdentifier(string);
        if (map.put(string, ++n) == null) {
            return n;
        }
        throw new InternalDataStoreException(Resources.format((short)5, string));
    }

    private static int[] getColumnIndices(SQLBuilder sQLBuilder, Relation relation, Map<String, Integer> map) throws InternalDataStoreException {
        Collection<String> collection = relation.getOwnerColumns();
        int n = 0;
        int[] nArray = new int[collection.size()];
        for (String string : collection) {
            Integer n2 = map.get(string);
            nArray[n++] = n2 != null ? n2 : FeatureAdapter.appendColumn(sQLBuilder, string, map);
        }
        return nArray;
    }

    final AbstractFeature createFeature(InfoStatements infoStatements, ResultSet resultSet) throws Exception {
        AbstractFeature abstractFeature = this.featureType.newInstance();
        for (int i = 0; i < this.attributes.length; ++i) {
            Column column = this.attributes[i];
            Object obj = column.valueGetter.getValue(infoStatements, resultSet, i + 1);
            if (obj == null) continue;
            abstractFeature.setPropertyValue(column.propertyName, obj);
        }
        return abstractFeature;
    }

    final Object getCacheKey(ResultSet resultSet, int n) throws SQLException {
        int[] nArray = this.foreignerKeyIndices[n];
        int n2 = nArray.length;
        Object object = n2 > 1 ? Array.newInstance(this.dependencies[n].keyComponentClass, n2) : null;
        Object object2 = null;
        for (int i = 0; i < n2; ++i) {
            object2 = resultSet.getObject(nArray[i]);
            if (object != null) {
                Array.set(object, i, object2);
            }
            if (object2 != null) continue;
            return null;
        }
        return object != null ? object : object2;
    }

    final void setForeignerKeys(ResultSet resultSet, PreparedStatement preparedStatement, int n) throws SQLException {
        int[] nArray = this.foreignerKeyIndices[n];
        int n2 = 0;
        while (n2 < nArray.length) {
            Object object = resultSet.getObject(nArray[n2]);
            preparedStatement.setObject(++n2, object);
        }
    }
}

