/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.sis.internal.jdk9.HexFormat;

public enum BinaryEncoding {
    RAW,
    HEXADECIMAL{

        @Override
        public byte[] getBytes(ResultSet resultSet, int n) throws SQLException {
            String string = resultSet.getString(n);
            return string != null ? HexFormat.of().parseHex(string) : null;
        }

        @Override
        public InputStream decode(InputStream inputStream) {
            return new FromHex(inputStream);
        }
    };


    public byte[] getBytes(ResultSet resultSet, int n) throws SQLException {
        return resultSet.getBytes(n);
    }

    public InputStream decode(InputStream inputStream) {
        return inputStream;
    }

    private static final class FromHex
    extends InputStream {
        private final InputStream source;

        FromHex(InputStream inputStream) {
            this.source = inputStream;
        }

        @Override
        public int read() throws IOException {
            int n = this.source.read();
            if (n < 0) {
                return -1;
            }
            int n2 = this.source.read();
            if (n2 < 0) {
                throw new EOFException();
            }
            return HexFormat.fromHexDigit(n) << 4 | HexFormat.fromHexDigit(n2);
        }

        @Override
        public long skip(long l) throws IOException {
            if ((l & 0xC000000000000000L) == 0L) {
                l <<= 1;
            }
            if (((l = this.source.skip(l)) & 1L) != 0L && this.source.read() >= 0) {
                ++l;
            }
            return l >> 1;
        }

        @Override
        public int available() throws IOException {
            return this.source.available() >> 1;
        }

        @Override
        public boolean markSupported() {
            return this.source.markSupported();
        }

        @Override
        public void mark(int n) {
            n = (n & 0xC0000000) == 0 ? (n <<= 1) : Integer.MAX_VALUE;
            this.source.mark(n);
        }

        @Override
        public void reset() throws IOException {
            this.source.reset();
        }

        @Override
        public void close() throws IOException {
            this.source.close();
        }
    }
}

