/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.gazetteer;

import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.gazetteer.AbstractLocation;
import org.apache.sis.referencing.gazetteer.AbstractLocationType;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.coordinate.Position;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

class SimpleLocation
extends AbstractLocation
implements DirectPosition,
Envelope,
GeographicBoundingBox {
    protected double minX = Double.NaN;
    protected double minY = Double.NaN;
    protected double maxX = Double.NaN;
    protected double maxY = Double.NaN;

    SimpleLocation(AbstractLocationType abstractLocationType, CharSequence charSequence) {
        super(abstractLocationType, charSequence);
    }

    @Override
    public GeographicExtent getGeographicExtent() {
        return this;
    }

    @Override
    public final Envelope getEnvelope() {
        return this;
    }

    @Override
    public final Position getPosition() {
        return this;
    }

    public final DirectPosition getDirectPosition() {
        return this;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return CommonCRS.defaultGeographic();
    }

    public final int getDimension() {
        return 2;
    }

    public final double[] getCoordinate() {
        return new double[]{this.getOrdinate(0), this.getOrdinate(1)};
    }

    public final double getOrdinate(int n) {
        return this.getMedian(n);
    }

    public final double getMinimum(int n) {
        switch (n) {
            case 0: {
                return this.minX;
            }
            case 1: {
                return this.minY;
            }
        }
        throw new IndexOutOfBoundsException(SimpleLocation.indexOutOfBounds(n));
    }

    public final double getMaximum(int n) {
        switch (n) {
            case 0: {
                return this.maxX;
            }
            case 1: {
                return this.maxY;
            }
        }
        throw new IndexOutOfBoundsException(SimpleLocation.indexOutOfBounds(n));
    }

    public final double getMedian(int n) {
        switch (n) {
            case 0: {
                return (this.minX + this.maxX) / 2.0;
            }
            case 1: {
                return (this.minY + this.maxY) / 2.0;
            }
        }
        throw new IndexOutOfBoundsException(SimpleLocation.indexOutOfBounds(n));
    }

    public final double getSpan(int n) {
        switch (n) {
            case 0: {
                return this.maxX - this.minX;
            }
            case 1: {
                return this.maxY - this.minY;
            }
        }
        throw new IndexOutOfBoundsException(SimpleLocation.indexOutOfBounds(n));
    }

    private static String indexOutOfBounds(int n) {
        return Errors.format((short)71, n);
    }

    public final DirectPosition getLowerCorner() {
        return new DirectPosition2D(this.getCoordinateReferenceSystem(), this.minX, this.minY);
    }

    public final DirectPosition getUpperCorner() {
        return new DirectPosition2D(this.getCoordinateReferenceSystem(), this.maxX, this.maxY);
    }

    public final void setOrdinate(int n, double d) {
        throw new UnsupportedOperationException(Errors.format((short)153, DirectPosition.class));
    }

    public final Boolean getInclusion() {
        return Boolean.TRUE;
    }

    public double getWestBoundLongitude() {
        return this.minX;
    }

    public double getEastBoundLongitude() {
        return this.maxX;
    }

    public double getSouthBoundLatitude() {
        return this.minY;
    }

    public double getNorthBoundLatitude() {
        return this.maxY;
    }

    final void convert(MathTransform mathTransform, double[] dArray) throws TransformException {
        dArray[3] = dArray[7] = this.maxY;
        dArray[4] = dArray[6] = this.maxX;
        dArray[1] = dArray[5] = this.minY;
        dArray[0] = dArray[2] = this.minX;
        this.maxY = Double.NaN;
        this.minY = Double.NaN;
        this.maxX = Double.NaN;
        this.minX = Double.NaN;
        mathTransform.transform(dArray, 0, dArray, 0, 4);
        int n = 0;
        while (n < 8) {
            double d = dArray[n++];
            double d2 = dArray[n++];
            if (Double.isNaN(d) || Double.isNaN(d2)) {
                throw new TransformException(Errors.format((short)16));
            }
            if (!(d >= this.minX)) {
                this.minX = d;
            }
            if (!(d <= this.maxX)) {
                this.maxX = d;
            }
            if (!(d2 >= this.minY)) {
                this.minY = d2;
            }
            if (d2 <= this.maxY) continue;
            this.maxY = d2;
        }
    }

    static abstract class Projected
    extends SimpleLocation
    implements GeographicBoundingBox {
        protected double westBoundLongitude = Double.NaN;
        protected double eastBoundLongitude = Double.NaN;
        protected double southBoundLatitude = Double.NaN;
        protected double northBoundLatitude = Double.NaN;

        Projected(AbstractLocationType abstractLocationType, CharSequence charSequence) {
            super(abstractLocationType, charSequence);
        }

        @Override
        public final double getWestBoundLongitude() {
            return this.westBoundLongitude;
        }

        @Override
        public final double getEastBoundLongitude() {
            return this.eastBoundLongitude;
        }

        @Override
        public final double getSouthBoundLatitude() {
            return this.southBoundLatitude;
        }

        @Override
        public final double getNorthBoundLatitude() {
            return this.northBoundLatitude;
        }

        final void computeGeographicBoundingBox(MathTransform mathTransform) throws TransformException {
            double[] dArray = new double[]{this.minX, this.minY, this.minX, this.maxY, this.maxX, this.minY, this.maxX, this.maxY};
            mathTransform.transform(dArray, 0, dArray, 0, 4);
            int n = 0;
            while (n < dArray.length) {
                double d = dArray[n++];
                double d2 = dArray[n++];
                if (Double.isNaN(d) || Double.isNaN(d2)) {
                    throw new TransformException(Errors.format((short)16));
                }
                if (!(d >= this.southBoundLatitude)) {
                    this.southBoundLatitude = d;
                }
                if (!(d <= this.northBoundLatitude)) {
                    this.northBoundLatitude = d;
                }
                if (!(d2 >= this.westBoundLongitude)) {
                    this.westBoundLongitude = d2;
                }
                if (d2 <= this.eastBoundLongitude) continue;
                this.eastBoundLongitude = d2;
            }
        }

        final boolean clipGeographicBoundingBox(double d, double d2, double d3, double d4) {
            boolean bl = false;
            if (this.westBoundLongitude < d) {
                this.westBoundLongitude = d;
                bl = true;
            }
            if (this.eastBoundLongitude > d3) {
                this.eastBoundLongitude = d3;
                bl = true;
            }
            if (this.southBoundLatitude < d2) {
                this.southBoundLatitude = d2;
                bl = true;
            }
            if (this.northBoundLatitude > d4) {
                this.northBoundLatitude = d4;
                bl = true;
            }
            return bl;
        }

        final void clipProjectedEnvelope(MathTransform mathTransform, double d, double d2) throws TransformException {
            double d3;
            double d4;
            double[] dArray = new double[]{this.southBoundLatitude, this.westBoundLongitude, this.northBoundLatitude, this.westBoundLongitude, this.southBoundLatitude, this.eastBoundLongitude, this.northBoundLatitude, this.eastBoundLongitude};
            mathTransform.transform(dArray, 0, dArray, 0, 4);
            double d5 = d4 = dArray[0];
            double d6 = d3 = dArray[1];
            int n = 2;
            while (n < dArray.length) {
                double d7 = dArray[n++];
                double d8 = dArray[n++];
                if (d7 < d5) {
                    d5 = d7;
                }
                if (d7 > d4) {
                    d4 = d7;
                }
                if (d8 < d6) {
                    d6 = d8;
                }
                if (!(d8 > d3)) continue;
                d3 = d8;
            }
            if (d5 > this.minX + d) {
                this.minX = d5;
            }
            if (d4 < this.maxX - d) {
                this.maxX = d4;
            }
            if (d6 > this.minY + d2) {
                this.minY = d6;
            }
            if (d3 < this.maxY - d2) {
                this.maxY = d3;
            }
        }
    }
}

