/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.gazetteer;

import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.sis.internal.gazetteer.Resources;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.metadata.iso.citation.DefaultOrganisation;
import org.apache.sis.metadata.iso.extent.DefaultGeographicDescription;
import org.apache.sis.referencing.gazetteer.AbstractLocationType;
import org.apache.sis.referencing.gazetteer.ReferencingByIdentifiers;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CorruptedObjectException;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.util.InternationalString;

public class ModifiableLocationType
extends AbstractLocationType {
    private final InternationalString name;
    private InternationalString theme;
    private final Map<String, InternationalString> identifications;
    private InternationalString definition;
    private GeographicExtent territoryOfUse;
    private AbstractParty owner;
    private final Map<String, ModifiableLocationType> parents;
    private final Map<String, ModifiableLocationType> children;

    public ModifiableLocationType(CharSequence charSequence) {
        ArgumentChecks.ensureNonNull("name", charSequence);
        this.name = Types.toInternationalString(charSequence);
        this.identifications = new LinkedHashMap<String, InternationalString>();
        this.parents = new LinkedHashMap<String, ModifiableLocationType>();
        this.children = new LinkedHashMap<String, ModifiableLocationType>();
    }

    @Override
    public InternationalString getName() {
        return this.name;
    }

    private <E> E inherit(Function<ModifiableLocationType, E> function) {
        E e = null;
        for (ModifiableLocationType modifiableLocationType : this.parents.values()) {
            Object object = function.apply(modifiableLocationType);
            if (object == null) continue;
            if (e == null) {
                e = (E)object;
                continue;
            }
            if (object.equals(e)) continue;
            return null;
        }
        return e;
    }

    @Override
    public InternationalString getTheme() {
        return this.theme != null ? this.theme : this.inherit(ModifiableLocationType::getTheme);
    }

    public void setTheme(CharSequence charSequence) {
        this.theme = Types.toInternationalString(charSequence);
    }

    public Collection<InternationalString> getIdentifications() {
        return this.identifications.isEmpty() ? this.inherit(ModifiableLocationType::getIdentifications) : Collections.unmodifiableCollection(this.identifications.values());
    }

    public void addIdentification(CharSequence charSequence) {
        ArgumentChecks.ensureNonNull("value", charSequence);
        String string = charSequence.toString();
        if (this.identifications.putIfAbsent(string, Types.toInternationalString(charSequence)) != null) {
            throw new IllegalArgumentException(Errors.format((short)27, string));
        }
    }

    public void removeIdentification(CharSequence charSequence) {
        ArgumentChecks.ensureNonNull("value", charSequence);
        String string = charSequence.toString();
        if (this.identifications.remove(string) == null) {
            throw new IllegalArgumentException(Errors.format((short)28, string));
        }
    }

    @Override
    public InternationalString getDefinition() {
        return this.definition != null ? this.definition : this.inherit(ModifiableLocationType::getDefinition);
    }

    public void setDefinition(CharSequence charSequence) {
        this.definition = Types.toInternationalString(charSequence);
    }

    @Override
    public GeographicExtent getTerritoryOfUse() {
        return this.territoryOfUse != null ? this.territoryOfUse : this.inherit(ModifiableLocationType::getTerritoryOfUse);
    }

    public void setTerritoryOfUse(GeographicExtent geographicExtent) {
        this.territoryOfUse = geographicExtent;
    }

    public void setTerritoryOfUse(String string) {
        this.territoryOfUse = string != null ? new DefaultGeographicDescription(null, string) : null;
    }

    @Override
    public AbstractParty getOwner() {
        return this.owner != null ? this.owner : this.inherit(ModifiableLocationType::getOwner);
    }

    public void setOwner(AbstractParty abstractParty) {
        this.owner = abstractParty;
    }

    public void setOwner(CharSequence charSequence) {
        this.owner = charSequence != null ? new DefaultOrganisation(charSequence, null, null, null) : null;
    }

    public final Collection<ModifiableLocationType> getParents() {
        return Collections.unmodifiableCollection(this.parents.values());
    }

    public final Collection<ModifiableLocationType> getChildren() {
        return Collections.unmodifiableCollection(this.children.values());
    }

    public void addParent(ModifiableLocationType modifiableLocationType) {
        ArgumentChecks.ensureNonNull("parent", modifiableLocationType);
        String string = modifiableLocationType.name.toString();
        if (this.parents.putIfAbsent(string, modifiableLocationType) != null) {
            throw new IllegalStateException(Resources.format((short)9, string));
        }
        String string2 = this.name.toString();
        if (modifiableLocationType.children.putIfAbsent(string2, this) != null) {
            if (this.parents.remove(string) != modifiableLocationType) {
                throw new ConcurrentModificationException();
            }
            throw new IllegalArgumentException(Resources.format((short)8, string));
        }
        try {
            modifiableLocationType.checkForCycles();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            modifiableLocationType.children.remove(string2);
            this.parents.remove(string);
            throw illegalArgumentException;
        }
    }

    public void removeParent(ModifiableLocationType modifiableLocationType) {
        ArgumentChecks.ensureNonNull("parent", modifiableLocationType);
        String string = modifiableLocationType.name.toString();
        ModifiableLocationType modifiableLocationType2 = this.parents.remove(string);
        if (modifiableLocationType2 == null) {
            throw new IllegalArgumentException(Resources.format((short)10, string));
        }
        if (modifiableLocationType2.children.remove(this.name.toString()) != this || modifiableLocationType2 != modifiableLocationType) {
            throw new CorruptedObjectException();
        }
    }

    @Override
    public ReferencingByIdentifiers getReferenceSystem() {
        return null;
    }
}

