/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.gazetteer;

import java.io.IOException;
import java.math.RoundingMode;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.measure.Unit;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.io.TableAppender;
import org.apache.sis.io.TabularFormat;
import org.apache.sis.measure.Angle;
import org.apache.sis.measure.AngleFormat;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.gazetteer.AbstractLocation;
import org.apache.sis.referencing.gazetteer.AbstractLocationType;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.coordinate.Position;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

public class LocationFormat
extends TabularFormat<AbstractLocation> {
    private static final long serialVersionUID = -3440801316594167279L;
    static final LocationFormat INSTANCE = new LocationFormat(Locale.getDefault(), TimeZone.getDefault());
    private static final short[] BOUND_KEY = new short[]{223, 171, 71, 183, 171, 142};

    public LocationFormat(Locale locale, TimeZone timeZone) {
        super(locale, timeZone);
    }

    @Override
    public Class<AbstractLocation> getValueType() {
        return AbstractLocation.class;
    }

    private static CoordinateReferenceSystem normalize(CoordinateReferenceSystem coordinateReferenceSystem) {
        AbstractCRS abstractCRS;
        if (coordinateReferenceSystem != null && (abstractCRS = AbstractCRS.castOrCopy((CoordinateReferenceSystem)coordinateReferenceSystem)) != (abstractCRS = abstractCRS.forConvention(AxesConvention.DISPLAY_ORIENTED))) {
            return abstractCRS;
        }
        return coordinateReferenceSystem;
    }

    private static DirectPosition transform(DirectPosition directPosition, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws FactoryException, TransformException {
        if (coordinateReferenceSystem != coordinateReferenceSystem2) {
            directPosition = CRS.findOperation((CoordinateReferenceSystem)coordinateReferenceSystem, (CoordinateReferenceSystem)coordinateReferenceSystem2, null).getMathTransform().transform(directPosition, null);
        }
        return directPosition;
    }

    private static DirectPosition position(Position position) {
        return position != null ? position.getDirectPosition() : null;
    }

    private static String toString(InternationalString internationalString, Locale locale) {
        return internationalString != null ? internationalString.toString(locale) : null;
    }

    private String toString(Date date) {
        return date != null ? this.getFormat(Date.class).format(date) : null;
    }

    @Override
    public void format(AbstractLocation abstractLocation, Appendable appendable) throws IOException {
        Object[] objectArray;
        Object object;
        DefaultExtent defaultExtent;
        GeographicBoundingBox geographicBoundingBox;
        Object object2;
        ArgumentChecks.ensureNonNull("location", abstractLocation);
        Locale locale = this.getLocale(Locale.Category.DISPLAY);
        Vocabulary vocabulary = Vocabulary.getResources(locale);
        TableAppender tableAppender = new TableAppender(appendable, "\u2502 ", this.columnSeparator, " \u2502");
        tableAppender.setMultiLinesCells(true);
        tableAppender.appendHorizontalSeparator();
        AbstractLocationType abstractLocationType = abstractLocation.type();
        if (abstractLocationType != null) {
            this.append(tableAppender, vocabulary, (short)120, LocationFormat.toString(abstractLocationType.getName(), locale));
        }
        this.append(tableAppender, vocabulary, (short)94, LocationFormat.toString(abstractLocation.getGeographicIdentifier(), locale));
        Collection<? extends InternationalString> collection = abstractLocation.getAlternativeGeographicIdentifiers();
        if (collection != null && !collection.isEmpty()) {
            boolean bl = true;
            vocabulary.appendLabel((short)5, tableAppender);
            this.nextColumn(tableAppender);
            object2 = collection.iterator();
            while (object2.hasNext()) {
                geographicBoundingBox = (InternationalString)object2.next();
                if (!bl) {
                    bl = false;
                    tableAppender.append(this.lineSeparator);
                }
                tableAppender.append((CharSequence)geographicBoundingBox);
            }
            tableAppender.nextLine();
        }
        if ((object2 = Extents.getTimeRange(defaultExtent = new DefaultExtent(null, abstractLocation.getGeographicExtent(), null, abstractLocation.getTemporalExtent()))) != null) {
            this.append(tableAppender, vocabulary, (short)186, this.toString((Date)((Range)object2).getMinValue()));
            this.append(tableAppender, vocabulary, (short)75, this.toString((Date)((Range)object2).getMaxValue()));
        }
        geographicBoundingBox = Extents.getGeographicBoundingBox(defaultExtent);
        Envelope envelope = abstractLocation.getEnvelope();
        DirectPosition directPosition = LocationFormat.position(abstractLocation.getPosition());
        DirectPosition directPosition2 = null;
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        CoordinateReferenceSystem coordinateReferenceSystem2 = null;
        Throwable throwable = null;
        try {
            if (envelope != null && (coordinateReferenceSystem2 = LocationFormat.normalize(coordinateReferenceSystem = envelope.getCoordinateReferenceSystem())) != coordinateReferenceSystem) {
                envelope = Envelopes.transform((Envelope)envelope, (CoordinateReferenceSystem)coordinateReferenceSystem2);
            }
            if (directPosition != null) {
                object = directPosition.getCoordinateReferenceSystem();
                if (coordinateReferenceSystem2 == null && (coordinateReferenceSystem2 = LocationFormat.normalize(coordinateReferenceSystem = object)) != coordinateReferenceSystem) {
                    envelope = Envelopes.transform((Envelope)envelope, (CoordinateReferenceSystem)coordinateReferenceSystem2);
                }
                if (geographicBoundingBox != null && (objectArray = ReferencingUtilities.toNormalizedGeographicCRS((CoordinateReferenceSystem)object, (boolean)false, (boolean)false)) != null) {
                    directPosition2 = LocationFormat.transform(directPosition, (CoordinateReferenceSystem)object, (CoordinateReferenceSystem)objectArray);
                }
                directPosition = LocationFormat.transform(directPosition, (CoordinateReferenceSystem)object, coordinateReferenceSystem2);
            }
        }
        catch (TransformException | FactoryException throwable2) {
            envelope = null;
            directPosition = null;
            throwable = throwable2;
        }
        if (geographicBoundingBox != null || envelope != null) {
            object = coordinateReferenceSystem != null ? coordinateReferenceSystem.getCoordinateSystem() : null;
            objectArray = null;
            Object[] objectArray2 = null;
            Object[] objectArray3 = null;
            AngleFormat angleFormat = null;
            NumberFormat numberFormat = null;
            UnitFormat unitFormat = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            if (geographicBoundingBox != null || directPosition2 != null) {
                angleFormat = (AngleFormat)this.getFormat(Angle.class);
                objectArray = new String[BOUND_KEY.length];
                Arrays.fill(objectArray, "");
            }
            if (envelope != null || directPosition != null) {
                numberFormat = (NumberFormat)this.getFormat(Number.class);
                unitFormat = (UnitFormat)this.getFormat(Unit.class);
                objectArray2 = new String[BOUND_KEY.length];
                objectArray3 = new String[BOUND_KEY.length];
                Arrays.fill(objectArray2, "");
                Arrays.fill(objectArray3, "");
            }
            for (int i = 0; i < BOUND_KEY.length; ++i) {
                int n4;
                RoundingMode roundingMode = RoundingMode.FLOOR;
                double d = Double.NaN;
                double d2 = Double.NaN;
                int n5 = 0;
                switch (i) {
                    case 0: {
                        if (geographicBoundingBox != null) {
                            d = geographicBoundingBox.getWestBoundLongitude();
                        }
                        if (envelope == null) break;
                        d2 = envelope.getMinimum(0);
                        break;
                    }
                    case 2: {
                        if (geographicBoundingBox != null) {
                            d = geographicBoundingBox.getEastBoundLongitude();
                        }
                        if (envelope != null) {
                            d2 = envelope.getMaximum(0);
                        }
                        roundingMode = RoundingMode.CEILING;
                        break;
                    }
                    case 3: {
                        if (geographicBoundingBox != null) {
                            d = geographicBoundingBox.getSouthBoundLatitude();
                        }
                        if (envelope != null) {
                            d2 = envelope.getMinimum(1);
                        }
                        n5 = 1;
                        break;
                    }
                    case 5: {
                        if (geographicBoundingBox != null) {
                            d = geographicBoundingBox.getNorthBoundLatitude();
                        }
                        if (envelope != null) {
                            d2 = envelope.getMaximum(1);
                        }
                        roundingMode = RoundingMode.CEILING;
                        n5 = 1;
                        break;
                    }
                    case 4: {
                        n5 = 1;
                    }
                    case 1: {
                        if (directPosition2 != null) {
                            d = directPosition2.getOrdinate(n5);
                        }
                        if (directPosition != null) {
                            d2 = directPosition.getOrdinate(n5);
                        }
                        roundingMode = RoundingMode.HALF_EVEN;
                    }
                }
                if (!Double.isNaN(d2)) {
                    Unit unit;
                    bl |= d != d2;
                    if (object != null && (unit = object.getAxis(n5).getUnit()) != null && (n4 = ((String)(objectArray3[i] = unitFormat.format(unit))).length()) > n3) {
                        n3 = n4;
                    }
                    try {
                        numberFormat.setRoundingMode(roundingMode);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                    objectArray2[i] = numberFormat.format(d2);
                    int n6 = ((String)objectArray2[i]).length();
                    if (n6 > n2) {
                        n2 = n6;
                    }
                }
                if (Double.isNaN(d)) continue;
                angleFormat.setRoundingMode(roundingMode);
                Angle angle = n5 == 0 ? new Longitude(d) : new Latitude(d);
                objectArray[i] = angleFormat.format(angle);
                n4 = ((String)objectArray[i]).length();
                if (n4 <= n) continue;
                n = n4;
            }
            if (!bl) {
                objectArray2 = null;
                objectArray3 = null;
                n2 = 0;
                n3 = 0;
            } else if (n2 != 0) {
                if (n3 != 0) {
                    ++n3;
                }
                n += 4;
            }
            String string = objectArray2 != null && objectArray != null ? "    \u2014" : "";
            for (int i = 0; i < BOUND_KEY.length; ++i) {
                String string2;
                String string3 = objectArray2 != null ? objectArray2[i] : "";
                String string4 = objectArray3 != null ? objectArray3[i] : "";
                String string5 = string2 = objectArray != null ? objectArray[i] : "";
                if (string3.isEmpty() && string2.isEmpty()) continue;
                vocabulary.appendLabel(BOUND_KEY[i], tableAppender);
                this.nextColumn(tableAppender);
                tableAppender.append(CharSequences.spaces(n2 - string3.length())).append(string3);
                tableAppender.append(CharSequences.spaces(n3 - string4.length())).append(string4).append(string);
                tableAppender.append(CharSequences.spaces(n - string2.length())).append(string2);
                tableAppender.nextLine();
            }
        }
        if (coordinateReferenceSystem != null) {
            this.append(tableAppender, vocabulary, (short)36, IdentifiedObjects.getDisplayName((IdentifiedObject)coordinateReferenceSystem, (Locale)locale));
        }
        if ((object = abstractLocation.getAdministrator()) != null) {
            this.append(tableAppender, vocabulary, (short)3, LocationFormat.toString(((AbstractParty)object).getName(), locale));
        }
        tableAppender.appendHorizontalSeparator();
        tableAppender.flush();
        if (throwable != null) {
            vocabulary.appendLabel((short)222, appendable);
            appendable.append(throwable.toString()).append(this.lineSeparator);
        }
    }

    @Override
    protected Format createFormat(Class<?> clazz) {
        Format format = super.createFormat(clazz);
        if (format instanceof NumberFormat) {
            NumberFormat numberFormat = (NumberFormat)format;
            numberFormat.setMinimumFractionDigits(0);
            numberFormat.setMaximumFractionDigits(0);
        } else if (format instanceof AngleFormat) {
            ((AngleFormat)format).applyPattern("D\u00b0MM\u2032SS\u2033");
        }
        return format;
    }

    private void append(TableAppender tableAppender, Vocabulary vocabulary, short s, String string) throws IOException {
        if (string != null) {
            vocabulary.appendLabel(s, tableAppender);
            this.nextColumn(tableAppender);
            tableAppender.append(string).nextLine();
        }
    }

    private void nextColumn(TableAppender tableAppender) {
        tableAppender.append(this.beforeFill).nextColumn(this.fillCharacter);
    }

    @Override
    public AbstractLocation parse(CharSequence charSequence, ParsePosition parsePosition) throws ParseException {
        throw new ParseException(Errors.format((short)162, "parse"), parsePosition.getIndex());
    }

    @Override
    public LocationFormat clone() {
        return (LocationFormat)super.clone();
    }
}

