/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.gazetteer;

import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.gazetteer.AbstractLocation;
import org.apache.sis.referencing.gazetteer.GazetteerException;
import org.apache.sis.referencing.gazetteer.ModifiableLocationType;
import org.apache.sis.referencing.gazetteer.ReferencingByIdentifiers;
import org.apache.sis.referencing.gazetteer.SimpleLocation;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

@XmlTransient
public class GeohashReferenceSystem
extends ReferencingByIdentifiers {
    private static final long serialVersionUID = 9162259764027168776L;
    final Format format;
    final DefaultGeographicCRS normalizedCRS;
    final CoordinateOperation denormalize;

    public GeohashReferenceSystem(Format format, GeographicCRS geographicCRS) throws GazetteerException {
        super(GeohashReferenceSystem.properties("Geohash", null), GeohashReferenceSystem.types());
        ArgumentChecks.ensureNonNull("format", (Object)format);
        ArgumentChecks.ensureNonNull("crs", geographicCRS);
        ArgumentChecks.ensureDimensionMatches("crs", 2, (CoordinateReferenceSystem)geographicCRS);
        this.format = format;
        this.normalizedCRS = DefaultGeographicCRS.castOrCopy((GeographicCRS)geographicCRS).forConvention(AxesConvention.NORMALIZED);
        try {
            this.denormalize = CRS.findOperation((CoordinateReferenceSystem)this.normalizedCRS, (CoordinateReferenceSystem)geographicCRS, null);
        }
        catch (FactoryException factoryException) {
            throw new GazetteerException(factoryException.getLocalizedMessage(), factoryException);
        }
    }

    private static ModifiableLocationType[] types() {
        ModifiableLocationType modifiableLocationType = new ModifiableLocationType("Geohash");
        modifiableLocationType.addIdentification((CharSequence)Vocabulary.formatInternational((short)28));
        return new ModifiableLocationType[]{modifiableLocationType};
    }

    public Format getFormat() {
        return this.format;
    }

    public Coder createCoder() {
        return new Coder();
    }

    public static enum Format {
        BASE32(16, new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 98, 99, 100, 101, 102, 103, 104, 106, 107, 109, 110, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122});

        final int highestOneBit;
        final byte[] encoding;
        final byte[] decodingLowerCase;
        final byte[] decodingUpperCase;

        private Format(int n2, byte[] byArray) {
            this.highestOneBit = n2;
            this.encoding = byArray;
            byte[] byArray2 = new byte[26];
            for (int n3 = 10; n3 < byArray.length; n3 = (int)((byte)(n3 + 1))) {
                byArray2[byArray[n3] - 97] = n3;
            }
            this.decodingLowerCase = byArray2;
            this.decodingUpperCase = byArray2;
        }
    }

    public class Coder {
        private byte length = (byte)12;
        private transient char[] buffer;
        private transient CoordinateOperation lastOp;
        private final transient double[] coordinates;

        protected Coder() {
            this.coordinates = GeohashReferenceSystem.this.denormalize.getMathTransform().isIdentity() ? null : new double[8];
        }

        public int getHashLength() {
            return this.length;
        }

        public void setHashLength(int n) {
            ArgumentChecks.ensureBetween("length", 1, 255, n);
            this.length = (byte)n;
            this.buffer = null;
        }

        public String encode(double d, double d2) throws TransformException {
            d = Latitude.clamp(d);
            d2 = Longitude.normalize(d2);
            byte[] byArray = GeohashReferenceSystem.this.format.encoding;
            int n = GeohashReferenceSystem.this.format.highestOneBit;
            char[] cArray = this.buffer;
            if (cArray == null) {
                this.buffer = cArray = new char[Byte.toUnsignedInt(this.length)];
            }
            boolean bl = true;
            double d3 = -180.0;
            double d4 = -90.0;
            double d5 = 180.0;
            double d6 = 90.0;
            int n2 = 0;
            int n3 = n;
            int n4 = 0;
            while (n4 < cArray.length) {
                double d7;
                if (bl) {
                    d7 = (d3 + d5) / 2.0;
                    if (d2 > d7) {
                        n2 |= n3;
                        d3 = d7;
                    } else {
                        d5 = d7;
                    }
                } else {
                    d7 = (d4 + d6) / 2.0;
                    if (d > d7) {
                        n2 |= n3;
                        d4 = d7;
                    } else {
                        d6 = d7;
                    }
                }
                boolean bl2 = bl = !bl;
                if ((n3 >>>= 1) != 0) continue;
                cArray[n4++] = (char)byArray[n2];
                n3 = n;
                n2 = 0;
            }
            return new String(cArray);
        }

        public String encode(DirectPosition directPosition) throws TransformException {
            ArgumentChecks.ensureNonNull("position", directPosition);
            CoordinateReferenceSystem coordinateReferenceSystem = directPosition.getCoordinateReferenceSystem();
            if (coordinateReferenceSystem != null && !GeohashReferenceSystem.this.normalizedCRS.equals((Object)coordinateReferenceSystem, ComparisonMode.IGNORE_METADATA)) {
                if (this.lastOp == null || !Utilities.equalsIgnoreMetadata(this.lastOp.getSourceCRS(), coordinateReferenceSystem)) {
                    try {
                        this.lastOp = CRS.findOperation((CoordinateReferenceSystem)coordinateReferenceSystem, (CoordinateReferenceSystem)GeohashReferenceSystem.this.normalizedCRS, null);
                    }
                    catch (FactoryException factoryException) {
                        throw new GazetteerException(factoryException.getLocalizedMessage(), factoryException);
                    }
                }
                directPosition = this.lastOp.getMathTransform().transform(directPosition, null);
            }
            return this.encode(directPosition.getOrdinate(1), directPosition.getOrdinate(0));
        }

        public AbstractLocation decode(CharSequence charSequence) throws TransformException {
            ArgumentChecks.ensureNonEmpty("geohash", charSequence);
            return new Decoder(charSequence, this.coordinates);
        }
    }

    private final class Decoder
    extends SimpleLocation {
        Decoder(CharSequence charSequence, double[] dArray) throws TransformException {
            int n;
            super(GeohashReferenceSystem.this.rootType(), charSequence);
            int n2 = charSequence.length();
            int n3 = GeohashReferenceSystem.this.format.highestOneBit;
            byte[] byArray = GeohashReferenceSystem.this.format.decodingLowerCase;
            byte[] byArray2 = GeohashReferenceSystem.this.format.decodingUpperCase;
            boolean bl = true;
            this.minX = -180.0;
            this.maxX = 180.0;
            this.minY = -90.0;
            this.maxY = 90.0;
            for (int i = 0; i < n2; i += n) {
                int n4 = Character.codePointAt(charSequence, i);
                n = Character.charCount(n4);
                if (n4 >= 48 && n4 <= 57) {
                    n4 -= 48;
                } else if ((n4 = n4 >= 97 && n4 <= 122 ? byArray[n4 - 97] : (n4 >= 65 && n4 <= 90 ? byArray2[n4 - 65] : 0)) == 0) {
                    throw new GazetteerException(Errors.format((short)155, "GeoHash", charSequence, charSequence.subSequence(i, i + n)));
                }
                int n5 = n3;
                do {
                    double d;
                    if (bl) {
                        d = (this.minX + this.maxX) / 2.0;
                        if ((n4 & n5) != 0) {
                            this.minX = d;
                        } else {
                            this.maxX = d;
                        }
                    } else {
                        d = (this.minY + this.maxY) / 2.0;
                        if ((n4 & n5) != 0) {
                            this.minY = d;
                        } else {
                            this.maxY = d;
                        }
                    }
                    boolean bl2 = bl = !bl;
                } while ((n5 >>>= 1) != 0);
            }
            if (dArray != null) {
                this.convert(GeohashReferenceSystem.this.denormalize.getMathTransform(), dArray);
            }
        }

        @Override
        public CoordinateReferenceSystem getCoordinateReferenceSystem() {
            return GeohashReferenceSystem.this.denormalize.getTargetCRS();
        }
    }
}

