/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.sis.console.FormattedOutputCommand;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.MetadataCommand;
import org.apache.sis.console.Option;
import org.apache.sis.console.OutputFormat;
import org.apache.sis.internal.util.X364;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

final class IdentifierCommand
extends FormattedOutputCommand {
    private static EnumSet<Option> options() {
        EnumSet<Option> enumSet = MetadataCommand.options();
        enumSet.remove((Object)Option.TIMEZONE);
        enumSet.remove((Object)Option.FORMAT);
        return enumSet;
    }

    IdentifierCommand(int n, String ... stringArray) throws InvalidOptionException {
        super(n, stringArray, IdentifierCommand.options(), OutputFormat.TEXT);
    }

    @Override
    public int run() throws Exception {
        Object object = this.readMetadataOrCRS();
        if (this.hasUnexpectedFileCount) {
            return 3;
        }
        if (object != null) {
            ArrayList<Row> arrayList;
            if (object instanceof DefaultMetadata) {
                arrayList = new ArrayList();
                Identifier identifier = ((DefaultMetadata)object).getMetadataIdentifier();
                if (identifier instanceof DefaultIdentifier) {
                    Object object2 = ((DefaultIdentifier)identifier).getDescription();
                    if (object2 != null && !this.files.isEmpty()) {
                        object2 = (CharSequence)this.files.get(0);
                    }
                    arrayList.add(new Row(State.VALID, IdentifiedObjects.toString((Identifier)identifier), (CharSequence)object2));
                }
                for (ReferenceSystem referenceSystem : ((Metadata)object).getReferenceSystemInfo()) {
                    arrayList.add(IdentifierCommand.create(referenceSystem));
                }
            } else {
                arrayList = Collections.singletonList(IdentifierCommand.create((ReferenceSystem)object));
            }
            this.print(arrayList);
        }
        return 0;
    }

    static Row create(ReferenceSystem referenceSystem) throws FactoryException {
        Object object;
        Object object2;
        String string = IdentifiedObjects.lookupURN((IdentifiedObject)referenceSystem, null);
        if (string == null) {
            for (CoordinateReferenceSystem coordinateReferenceSystem : referenceSystem.getIdentifiers()) {
                object2 = IdentifiedObjects.toURN((Class)referenceSystem.getClass(), (Identifier)coordinateReferenceSystem);
                if (object2 != null) {
                    string = object2;
                    break;
                }
                if (string != null) continue;
                string = IdentifiedObjects.toString((Identifier)coordinateReferenceSystem);
            }
            if (string == null) {
                return null;
            }
        }
        try {
            CoordinateReferenceSystem coordinateReferenceSystem;
            coordinateReferenceSystem = CRS.forCode((String)string);
            object2 = ComparisonMode.equalityLevel((Object)coordinateReferenceSystem, (Object)referenceSystem);
            if (object2 == null) {
                object = State.MISMATCH;
            } else {
                switch (object2) {
                    case ALLOW_VARIANT: {
                        object = State.AXIS_ORDER;
                        break;
                    }
                    case APPROXIMATE: {
                        object = State.APPROXIMATE;
                        referenceSystem = coordinateReferenceSystem;
                        break;
                    }
                    default: {
                        object = State.VALID;
                        referenceSystem = coordinateReferenceSystem;
                    }
                }
            }
        }
        catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
            object = State.UNKNOWN;
        }
        return new Row((State)((Object)object), string, referenceSystem.getName().getCode());
    }

    private void print(Iterable<Row> iterable) throws IOException {
        int n = 0;
        for (Row object2 : iterable) {
            if (object2 == null) continue;
            n = Math.max(n, object2.identifier.length());
        }
        n += 4;
        EnumSet<State> enumSet = EnumSet.noneOf(State.class);
        for (Row row : iterable) {
            boolean bl;
            if (row == null) continue;
            enumSet.add(row.state);
            boolean bl2 = bl = this.colors && row.state.text.startsWith("!");
            if (bl) {
                this.out.print(X364.FOREGROUND_RED.sequence());
            }
            this.out.print(row.state.text);
            this.out.print(' ');
            this.out.print(row.identifier);
            if (bl) {
                this.out.print(X364.FOREGROUND_DEFAULT.sequence());
            }
            if (this.colors) {
                this.out.print(X364.FOREGROUND_GRAY.sequence());
            }
            this.out.print(CharSequences.spaces((int)(n - row.identifier.length())));
            this.out.print("| ");
            this.out.println(row.description);
            if (!this.colors) continue;
            this.out.print(X364.FOREGROUND_DEFAULT.sequence());
        }
        enumSet.remove((Object)State.VALID);
        if (!enumSet.isEmpty()) {
            this.out.println();
            Vocabulary.getResources((Locale)this.locale).appendLabel((short)113, (Appendable)this.out);
            this.out.println();
            ResourceBundle resourceBundle = ResourceBundle.getBundle("org.apache.sis.console.IdentifierState", this.locale);
            Iterator iterator = enumSet.iterator();
            while (iterator.hasNext()) {
                boolean bl;
                State state = (State)((Object)iterator.next());
                boolean bl3 = bl = this.colors && state.text.startsWith("!");
                if (bl) {
                    this.out.print(X364.FOREGROUND_RED.sequence());
                }
                this.out.print(state.text);
                if (bl) {
                    this.out.print(X364.FOREGROUND_DEFAULT.sequence());
                }
                this.out.print(' ');
                this.out.println(resourceBundle.getString(state.name()));
            }
        }
        this.out.flush();
    }

    private static class Row {
        final State state;
        final String identifier;
        final CharSequence description;

        Row(State state, String string, CharSequence charSequence) {
            this.state = state;
            this.identifier = string;
            this.description = charSequence;
        }
    }

    private static enum State {
        VALID("   "),
        APPROXIMATE("~  "),
        AXIS_ORDER("!  "),
        MISMATCH("!! "),
        UNKNOWN("?  ");

        final String text;

        private State(String string2) {
            this.text = string2;
        }
    }
}

