/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.io.Console;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Locale;
import java.util.logging.ConsoleHandler;
import java.util.logging.LogManager;
import org.apache.sis.console.AboutCommand;
import org.apache.sis.console.CRSCommand;
import org.apache.sis.console.CommandRunner;
import org.apache.sis.console.HelpCommand;
import org.apache.sis.console.IdentifierCommand;
import org.apache.sis.console.InvalidCommandException;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.MetadataCommand;
import org.apache.sis.console.MimeTypeCommand;
import org.apache.sis.console.Option;
import org.apache.sis.console.TransformCommand;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.logging.MonolineFormatter;
import org.apache.sis.util.resources.Errors;

public final class Command {
    public static final int INVALID_COMMAND_EXIT_CODE = 1;
    public static final int INVALID_OPTION_EXIT_CODE = 2;
    public static final int INVALID_ARGUMENT_EXIT_CODE = 3;
    public static final int UNKNOWN_STORAGE_EXIT_CODE = 4;
    public static final int IO_EXCEPTION_EXIT_CODE = 100;
    public static final int SQL_EXCEPTION_EXIT_CODE = 101;
    public static final int OTHER_ERROR_EXIT_CODE = 199;
    private final CommandRunner command;

    protected Command(String[] stringArray) throws InvalidCommandException, InvalidOptionException {
        int n = -1;
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.startsWith("--")) {
                String string3 = string2.substring("--".length());
                Option option = Option.forLabel(string3);
                if (!option.hasValue) continue;
                ++i;
                continue;
            }
            string = string2;
            n = i;
            break;
        }
        if (string == null) {
            this.command = new HelpCommand(-1, stringArray);
        } else {
            switch (string.toLowerCase(Locale.US)) {
                case "help": {
                    this.command = new HelpCommand(n, stringArray);
                    break;
                }
                case "about": {
                    this.command = new AboutCommand(n, stringArray);
                    break;
                }
                case "mime-type": {
                    this.command = new MimeTypeCommand(n, stringArray);
                    break;
                }
                case "metadata": {
                    this.command = new MetadataCommand(n, stringArray);
                    break;
                }
                case "crs": {
                    this.command = new CRSCommand(n, stringArray);
                    break;
                }
                case "identifier": {
                    this.command = new IdentifierCommand(n, stringArray);
                    break;
                }
                case "transform": {
                    this.command = new TransformCommand(n, stringArray);
                    break;
                }
                default: {
                    throw new InvalidCommandException(Errors.format((short)145, (Object)string), string);
                }
            }
        }
        CommandRunner.instance = this.command;
    }

    public int run() throws Exception {
        if (this.command.hasContradictoryOptions(Option.BRIEF, Option.VERBOSE)) {
            return 2;
        }
        if (!this.command.options.containsKey((Object)Option.HELP)) {
            try {
                return this.command.run();
            }
            catch (Exception exception) {
                this.command.error(null, exception);
                throw exception;
            }
        }
        this.command.help(this.command.commandName.toLowerCase(Locale.US));
        return 0;
    }

    public static int exitCodeFor(Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof InvalidCommandException) {
                return 1;
            }
            if (throwable instanceof InvalidOptionException) {
                return 2;
            }
            if (throwable instanceof IOException) {
                return 100;
            }
            if (throwable instanceof SQLException) {
                return 101;
            }
            throwable = throwable.getCause();
        }
        return 199;
    }

    private static void error(String[] stringArray, Exception exception) {
        boolean bl = ArraysExt.containsIgnoreCase((String[])stringArray, (String)"--debug");
        Console console = System.console();
        if (console != null) {
            PrintWriter printWriter = console.writer();
            if (bl) {
                exception.printStackTrace(printWriter);
            } else {
                printWriter.println(exception.getLocalizedMessage());
            }
            printWriter.flush();
        } else {
            PrintStream printStream = System.err;
            if (bl) {
                exception.printStackTrace(printStream);
            } else {
                printStream.println(exception.getLocalizedMessage());
            }
            printStream.flush();
        }
    }

    public static void main(String[] stringArray) {
        int n;
        Command command;
        LogManager logManager = LogManager.getLogManager();
        if (MonolineFormatter.class.getName().equals(logManager.getProperty(ConsoleHandler.class.getName() + ".formatter"))) {
            MonolineFormatter.install();
        }
        try {
            command = new Command(stringArray);
        }
        catch (InvalidCommandException invalidCommandException) {
            Command.error(stringArray, invalidCommandException);
            System.exit(1);
            return;
        }
        catch (InvalidOptionException invalidOptionException) {
            Command.error(stringArray, invalidOptionException);
            System.exit(2);
            return;
        }
        try {
            n = command.run();
        }
        catch (Exception exception) {
            n = Command.exitCodeFor(exception);
        }
        if (n != 0) {
            System.exit(n);
        }
    }
}

