/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui.control;

import java.util.Arrays;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import org.apache.sis.internal.gui.ColorName;
import org.apache.sis.internal.gui.GUIUtilities;
import org.apache.sis.util.resources.Vocabulary;

public final class ColorRamp {
    static final ColorRamp GRAYSCALE = new ColorRamp(-16777216, -1);
    static final ColorRamp BELL = new ColorRamp(-16776961, -16711681, -1, -256, -65536);
    public final int[] colors;
    private transient Color color;
    private transient Paint paint;
    private transient String name;

    public ColorRamp(Color color) {
        this.color = color;
        this.paint = this.color;
        this.colors = new int[]{GUIUtilities.toARGB(color)};
    }

    ColorRamp(int ... nArray) {
        this.colors = nArray;
    }

    public final boolean isTransparent() {
        if (this.colors != null) {
            for (int n : this.colors) {
                if ((n & 0xFF000000) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public final Color color() {
        if (this.color == null) {
            if (this.paint instanceof Color) {
                this.color = (Color)this.paint;
            } else if (this.colors != null && this.colors.length != 0) {
                this.color = GUIUtilities.fromARGB(this.colors[this.colors.length / 2]);
            }
        }
        return this.color;
    }

    final Paint paint() {
        if (this.paint == null) {
            switch (this.colors.length) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.color == null) {
                        this.color = GUIUtilities.fromARGB(this.colors[0]);
                    }
                    this.paint = this.color;
                    break;
                }
                default: {
                    Stop[] stopArray = new Stop[this.colors.length];
                    double d = 1.0 / (double)(stopArray.length - 1);
                    for (int i = 0; i < stopArray.length; ++i) {
                        stopArray[i] = new Stop(d * (double)i, GUIUtilities.fromARGB(this.colors[i]));
                    }
                    this.paint = new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, stopArray);
                    break;
                }
            }
        }
        return this.paint;
    }

    public String toString() {
        if (this.name == null) {
            int n;
            if (this.colors == null || (n = this.colors.length) == 0) {
                this.name = Vocabulary.format((short)249);
            } else if (this.equals(GRAYSCALE)) {
                this.name = Vocabulary.format((short)250);
            } else {
                this.name = ColorName.of(this.colors[0]);
                if (n > 1) {
                    StringBuilder stringBuilder = new StringBuilder(this.name);
                    if (n > 2) {
                        stringBuilder.append(" \u2013 ").append(ColorName.of(this.colors[n / 2]));
                    }
                    this.name = stringBuilder.append(" \u2013 ").append(ColorName.of(this.colors[n - 1])).toString();
                }
            }
        }
        return this.name;
    }

    public int hashCode() {
        return Arrays.hashCode(this.colors) ^ 0x51;
    }

    public boolean equals(Object object) {
        return object instanceof ColorRamp && Arrays.equals(this.colors, ((ColorRamp)object).colors);
    }

    public static enum Type {
        SOLID,
        GRADIENT;

    }
}

