/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.scene.Node;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStores;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.resources.Vocabulary;

public final class ResourceLoader
extends Task<Resource> {
    private static final Cache<Object, DataStore> CACHE = new Cache();
    private final Object source;
    private final Object key;

    public ResourceLoader(Object object) {
        this.source = object;
        try {
            if (object instanceof StorageConnector) {
                object = ((StorageConnector)object).getStorage();
            }
            if (object instanceof AutoCloseable) {
                object = null;
            } else {
                if (object instanceof File) {
                    object = ((File)object).getAbsoluteFile();
                    object = ((File)object).toPath();
                } else if (object instanceof URL) {
                    object = ((URL)object).toURI();
                }
                if (object instanceof URI) {
                    object = Paths.get((URI)object);
                }
                if (object instanceof Path) {
                    object = ((Path)object).toRealPath(new LinkOption[0]);
                }
            }
        }
        catch (IOException | IllegalArgumentException | URISyntaxException exception) {
        }
        catch (RuntimeException | DataStoreException throwable) {
            object = null;
        }
        this.key = object;
    }

    public DataStore fromCache() {
        return this.key != null ? CACHE.peek(this.key) : null;
    }

    protected DataStore call() throws Exception {
        return this.key != null ? CACHE.getOrCreate(this.key, this::load) : this.load();
    }

    private DataStore load() throws DataStoreException {
        return DataStores.open((Object)this.source);
    }

    final String getFileName() {
        if (this.source instanceof StorageConnector) {
            return ((StorageConnector)this.source).getStorageName();
        }
        String string = IOUtilities.filename((Object)this.source);
        if (string == null) {
            string = Vocabulary.format((short)207);
        }
        return string;
    }

    public static boolean removeAndClose(DataStore dataStore, Node node) {
        boolean bl = false;
        for (Map.Entry<Object, DataStore> entry : CACHE.entrySet()) {
            if (entry.getValue() != dataStore) continue;
            bl |= CACHE.remove(entry.getKey(), dataStore);
        }
        BackgroundThreads.execute(() -> {
            try {
                dataStore.close();
            }
            catch (Throwable throwable) {
                Platform.runLater(() -> ExceptionReporter.canNotCloseFile(node, dataStore.getDisplayName(), throwable));
            }
        });
        return bl;
    }

    static void closeAll() throws Exception {
        Closer closer = new Closer();
        do {
            ((Stream)Stream.of(CACHE.keySet().toArray()).parallel()).forEach(closer);
        } while (!CACHE.isEmpty());
        closer.rethrow();
    }

    private static final class Closer
    implements Consumer<Object> {
        private Exception error;

        private Closer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(Object object) {
            DataStore dataStore = CACHE.remove(object);
            if (object != null) {
                try {
                    dataStore.close();
                }
                catch (Exception exception) {
                    Closer closer = this;
                    synchronized (closer) {
                        if (this.error == null) {
                            this.error = exception;
                        } else {
                            this.error.addSuppressed(exception);
                        }
                    }
                }
            }
        }

        synchronized void rethrow() throws Exception {
            if (this.error != null) {
                throw this.error;
            }
        }
    }
}

