/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.Platform;
import javafx.stage.Window;
import org.apache.sis.gui.DataViewer;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.ResourceLoader;
import org.apache.sis.internal.system.Threads;
import org.apache.sis.util.logging.Logging;

public final class BackgroundThreads
extends AtomicInteger
implements ThreadFactory {
    public static final boolean PRELOAD = true;
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(new BackgroundThreads());

    private BackgroundThreads() {
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(Threads.SIS, runnable, "Application worker #" + this.incrementAndGet());
        thread.setPriority(4);
        return thread;
    }

    public static void execute(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            EXECUTOR.execute(runnable);
        } else {
            runnable.run();
            CountDownLatch countDownLatch = new CountDownLatch(1);
            Platform.runLater(countDownLatch::countDown);
            try {
                countDownLatch.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                BackgroundThreads.interrupted("execute", interruptedException);
            }
        }
    }

    public static <V> V runAndWait(Callable<V> callable) {
        FutureTask<V> futureTask = new FutureTask<V>(callable);
        Platform.runLater(futureTask);
        try {
            return futureTask.get();
        }
        catch (ExecutionException executionException) {
            ExceptionReporter.show((Window)DataViewer.getCurrentStage(), null, null, executionException.getCause());
        }
        catch (InterruptedException interruptedException) {
            BackgroundThreads.interrupted("runAndWait", interruptedException);
        }
        return null;
    }

    public static void stop() throws Exception {
        EXECUTOR.shutdown();
        try {
            EXECUTOR.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            BackgroundThreads.interrupted("stop", interruptedException);
        }
        ResourceLoader.closeAll();
    }

    private static void interrupted(String string, InterruptedException interruptedException) {
        Logging.unexpectedException(Logging.getLogger("org.apache.sis.gui"), BackgroundThreads.class, string, interruptedException);
    }
}

