/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.referencing;

import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.util.logging.Logging;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class Utils {
    private Utils() {
    }

    static CRSAuthorityFactory getDefaultFactory() throws FactoryException {
        return CRS.getAuthorityFactory((String)"EPSG");
    }

    static ImmutableEnvelope toGeographic(Class<?> clazz, String string, Envelope envelope) {
        if (envelope != null) {
            try {
                DefaultGeographicBoundingBox defaultGeographicBoundingBox = new DefaultGeographicBoundingBox();
                defaultGeographicBoundingBox.setBounds(envelope);
                return new ImmutableEnvelope((GeographicBoundingBox)defaultGeographicBoundingBox);
            }
            catch (TransformException transformException) {
                Logging.recoverableException(Logging.getLogger("org.apache.sis.gui"), clazz, string, transformException);
            }
        }
        return null;
    }

    static boolean intersects(ImmutableEnvelope immutableEnvelope, Extent extent) {
        GeographicBoundingBox geographicBoundingBox;
        if (immutableEnvelope != null && (geographicBoundingBox = Extents.getGeographicBoundingBox((Extent)extent)) != null) {
            return immutableEnvelope.intersects((Envelope)new ImmutableEnvelope(geographicBoundingBox));
        }
        return true;
    }

    static boolean isIgnoreable(ReferenceSystem referenceSystem) {
        return referenceSystem instanceof SingleCRS && CommonCRS.Engineering.DISPLAY.datum().equals(((SingleCRS)referenceSystem).getDatum());
    }
}

