/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.referencing;

import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Locale;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.ToggleGroup;
import org.apache.sis.gui.referencing.RecentReferenceSystems;
import org.apache.sis.internal.gui.GUIUtilities;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class MenuSync
extends SimpleObjectProperty<ReferenceSystem>
implements EventHandler<ActionEvent> {
    private static final String REFERENCE_SYSTEM_KEY = "ReferenceSystem";
    private static final String CHOOSER = "CHOOSER";
    private final ObservableList<MenuItem> menus;
    private final ToggleGroup group;
    private final RecentReferenceSystems.Listener action;

    MenuSync(ObservableList<ReferenceSystem> observableList, Menu menu, RecentReferenceSystems.Listener listener) {
        super((Object)menu, "value");
        this.menus = menu.getItems();
        this.group = new ToggleGroup();
        this.action = listener;
        Object[] objectArray = new MenuItem[observableList.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.createItem((ReferenceSystem)observableList.get(i));
        }
        this.menus.setAll(objectArray);
        this.initialize(observableList);
    }

    private void initialize(ObservableList<? extends ReferenceSystem> observableList) {
        for (ReferenceSystem referenceSystem : observableList) {
            if (!(referenceSystem instanceof CoordinateReferenceSystem) || ReferencingUtilities.getDimension((CoordinateReferenceSystem)((CoordinateReferenceSystem)referenceSystem)) != 2) continue;
            this.set(referenceSystem);
            break;
        }
    }

    private MenuItem createItem(ReferenceSystem referenceSystem) {
        Locale locale = this.action.owner().locale;
        if (referenceSystem != RecentReferenceSystems.OTHER) {
            RadioMenuItem radioMenuItem = new RadioMenuItem(IdentifiedObjects.getDisplayName((IdentifiedObject)referenceSystem, (Locale)locale));
            radioMenuItem.getProperties().put((Object)REFERENCE_SYSTEM_KEY, (Object)referenceSystem);
            radioMenuItem.setToggleGroup(this.group);
            radioMenuItem.setOnAction((EventHandler)this);
            return radioMenuItem;
        }
        MenuItem menuItem = new MenuItem(Vocabulary.getResources(locale).getString((short)157) + "\u2026");
        menuItem.getProperties().put((Object)REFERENCE_SYSTEM_KEY, (Object)CHOOSER);
        menuItem.setOnAction((EventHandler)this);
        return menuItem;
    }

    private static void dispose(MenuItem menuItem) {
        menuItem.setOnAction(null);
        if (menuItem instanceof RadioMenuItem) {
            ((RadioMenuItem)menuItem).setToggleGroup(null);
        }
    }

    final void notifyChanges(ObservableList<? extends ReferenceSystem> observableList) {
        Iterator iterator;
        IdentityHashMap<Object, MenuItem> identityHashMap = new IdentityHashMap<Object, MenuItem>();
        MenuItem[] menuItemArray = this.menus.iterator();
        while (menuItemArray.hasNext()) {
            MenuItem menuItem = (MenuItem)menuItemArray.next();
            if (identityHashMap.putIfAbsent(menuItem.getProperties().get((Object)REFERENCE_SYSTEM_KEY), menuItem) == null) continue;
            menuItemArray.remove();
            MenuSync.dispose(menuItem);
        }
        menuItemArray = new MenuItem[observableList.size()];
        for (int i = 0; i < menuItemArray.length; ++i) {
            iterator = observableList.get(i);
            if (iterator == RecentReferenceSystems.OTHER) {
                iterator = CHOOSER;
            }
            menuItemArray[i] = (MenuItem)identityHashMap.remove(iterator);
        }
        ReferenceSystem referenceSystem = (ReferenceSystem)this.get();
        iterator = identityHashMap.values().iterator();
        for (int i = 0; i < menuItemArray.length; ++i) {
            MenuItem menuItem;
            if (menuItemArray[i] != null) continue;
            ReferenceSystem referenceSystem2 = (ReferenceSystem)observableList.get(i);
            if (referenceSystem2 != RecentReferenceSystems.OTHER && iterator.hasNext()) {
                menuItem = (MenuItem)iterator.next();
                iterator.remove();
                if (menuItem instanceof RadioMenuItem) {
                    menuItem.setText(IdentifiedObjects.getDisplayName((IdentifiedObject)referenceSystem2, (Locale)this.action.owner().locale));
                    menuItem.getProperties().put((Object)REFERENCE_SYSTEM_KEY, (Object)referenceSystem2);
                } else {
                    menuItem = this.createItem(referenceSystem2);
                }
            } else {
                menuItem = this.createItem(referenceSystem2);
            }
            if (referenceSystem != null && referenceSystem2 == referenceSystem) {
                ((RadioMenuItem)menuItem).setSelected(true);
                referenceSystem = null;
            }
            menuItemArray[i] = menuItem;
        }
        while (iterator.hasNext()) {
            MenuSync.dispose((MenuItem)iterator.next());
        }
        GUIUtilities.copyAsDiff(Arrays.asList(menuItemArray), this.menus);
        if (this.get() == null) {
            this.initialize(observableList);
        }
    }

    public void handle(ActionEvent actionEvent) {
        Object object = ((MenuItem)actionEvent.getSource()).getProperties().get((Object)REFERENCE_SYSTEM_KEY);
        if (object == CHOOSER) {
            this.action.changed((ObservableValue<? extends ReferenceSystem>)this, (ReferenceSystem)this.get(), RecentReferenceSystems.OTHER);
        } else {
            this.set((ReferenceSystem)object);
        }
    }

    public void set(ReferenceSystem referenceSystem) {
        ReferenceSystem referenceSystem2 = (ReferenceSystem)this.get();
        if (referenceSystem2 != referenceSystem) {
            ComparisonMode comparisonMode = (ComparisonMode)((Object)this.action.owner().duplicationCriterion.get());
            for (MenuItem menuItem : this.menus) {
                Object object;
                if (!(menuItem instanceof RadioMenuItem) || !Utilities.deepEquals(object = menuItem.getProperties().get((Object)REFERENCE_SYSTEM_KEY), referenceSystem, comparisonMode)) continue;
                referenceSystem = (ReferenceSystem)object;
                super.set((Object)referenceSystem);
                ((RadioMenuItem)menuItem).setSelected(true);
                this.action.changed((ObservableValue<? extends ReferenceSystem>)this, referenceSystem2, referenceSystem);
                return;
            }
            super.set((Object)referenceSystem);
            this.group.selectToggle(null);
            this.action.owner().addSelected(referenceSystem);
        }
    }
}

