/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.metadata;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringJoiner;
import javafx.application.Platform;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TitledPane;
import javafx.scene.image.Image;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.apache.sis.gui.Widget;
import org.apache.sis.gui.metadata.IdentificationInfo;
import org.apache.sis.gui.metadata.MetadataTree;
import org.apache.sis.gui.metadata.RepresentationInfo;
import org.apache.sis.gui.metadata.Section;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Metadata;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

@DefaultProperty(value="metadata")
public class MetadataSummary
extends Widget {
    private final ScrollPane content;
    final Vocabulary vocabulary = Vocabulary.getResources((Locale)null);
    private NumberFormat numberFormat;
    private DateFormat dateFormat;
    private static Image worldMap;
    private static boolean worldMapLoaded;
    private Getter getter;
    public final ObjectProperty<Metadata> metadataProperty;
    private ExceptionReporter error;
    private final TitledPane[] information = new TitledPane[]{new TitledPane(this.vocabulary.getString((short)173), (Node)new IdentificationInfo(this)), new TitledPane(this.vocabulary.getString((short)184), (Node)new RepresentationInfo(this))};
    final ArrayList<MetadataTree> nativeMetadataViews;

    public MetadataSummary() {
        this.content = new ScrollPane((Node)new VBox());
        this.content.setFitToWidth(true);
        this.nativeMetadataViews = new ArrayList();
        this.metadataProperty = new SimpleObjectProperty((Object)this, "metadata");
        this.metadataProperty.addListener(MetadataSummary::applyChange);
    }

    private IdentificationInfo getIdentificationInfo() {
        return (IdentificationInfo)this.information[0].getContent();
    }

    private ObservableList<Node> getChildren() {
        return ((VBox)this.content.getContent()).getChildren();
    }

    @Override
    public final Region getView() {
        return this.content;
    }

    final NumberFormat getNumberFormat() {
        if (this.numberFormat == null) {
            this.numberFormat = NumberFormat.getInstance();
        }
        return this.numberFormat;
    }

    final DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = DateFormat.getDateTimeInstance(1, 2);
        }
        return this.dateFormat;
    }

    public void setMetadata(Resource resource) {
        assert (Platform.isFxApplicationThread());
        if (this.getter != null) {
            this.getter.cancel();
            this.getter = null;
        }
        if (resource == null) {
            this.setMetadata((Metadata)null);
        } else {
            this.getter = new Getter(resource);
            BackgroundThreads.execute((Runnable)((Object)this.getter));
        }
    }

    public final void setMetadata(Metadata metadata) {
        assert (Platform.isFxApplicationThread());
        this.metadataProperty.set((Object)metadata);
    }

    public final Metadata getMetadata() {
        return (Metadata)this.metadataProperty.get();
    }

    public final void setError(Throwable throwable) {
        ArgumentChecks.ensureNonNull("exception", throwable);
        this.setMetadata((Metadata)null);
        if (this.error == null) {
            this.error = new ExceptionReporter(throwable);
        } else {
            this.error.setException(throwable);
        }
        ObservableList<Node> observableList = this.getChildren();
        observableList.setAll((Object[])new Node[]{this.error.getView()});
    }

    private static void applyChange(ObservableValue<? extends Metadata> observableValue, Metadata metadata, Metadata metadata2) {
        MetadataSummary metadataSummary = (MetadataSummary)((SimpleObjectProperty)observableValue).getBean();
        Getter getter = metadataSummary.getter;
        metadataSummary.getter = null;
        metadataSummary.error = null;
        if (metadata2 != metadata) {
            TreeTable treeTable = getter != null && getter.isDone() ? getter.nativeMetadata : null;
            for (MetadataTree metadataTree : metadataSummary.nativeMetadataViews) {
                metadataTree.setContent(treeTable);
            }
            Iterator<MetadataTree> iterator = metadataSummary.getChildren();
            if (!iterator.isEmpty() && !(iterator.get(0) instanceof Section)) {
                iterator.clear();
            }
            int n = 0;
            for (TitledPane titledPane : metadataSummary.information) {
                boolean bl;
                Section section = (Section)titledPane.getContent();
                section.setInformation(metadata2);
                boolean bl2 = section.isEmpty();
                boolean bl3 = bl = n < iterator.size() && iterator.get(n) == titledPane;
                if (bl2 == bl) {
                    if (bl2) {
                        iterator.remove(n);
                    } else {
                        iterator.add(n, titledPane);
                    }
                }
                if (bl2) continue;
                ++n;
            }
        }
    }

    static Image getWorldMap() {
        assert (Platform.isFxApplicationThread());
        if (!worldMapLoaded) {
            worldMapLoaded = true;
            worldMap = Styles.loadIcon(MetadataSummary.class, "getWorldMap", "WorldMap360x180.png");
        }
        return worldMap;
    }

    final String string(Collection<? extends CodeList<?>> collection) {
        StringJoiner stringJoiner = new StringJoiner(", ");
        for (CodeList<?> codeList : collection) {
            String string = this.string(Types.getCodeTitle(codeList));
            if (string == null) continue;
            stringJoiner.add(string);
        }
        return stringJoiner.length() != 0 ? stringJoiner.toString() : null;
    }

    final String string(InternationalString internationalString) {
        return internationalString != null ? Strings.trimOrNull(internationalString.toString(this.vocabulary.getLocale())) : null;
    }

    private final class Getter
    extends Task<Metadata> {
        private final Resource resource;
        TreeTable nativeMetadata;

        Getter(Resource resource) {
            this.resource = resource;
        }

        protected Metadata call() throws DataStoreException {
            if (this.resource instanceof DataStore && !MetadataSummary.this.nativeMetadataViews.isEmpty()) {
                this.nativeMetadata = ((DataStore)this.resource).getNativeMetadata().orElse(null);
            }
            return this.resource.getMetadata();
        }

        protected void succeeded() {
            if (MetadataSummary.this.getter == this) {
                try {
                    MetadataSummary.this.setMetadata((Metadata)this.getValue());
                    if (this.resource instanceof Aggregate) {
                        MetadataSummary.this.getIdentificationInfo().completeMissingGeographicBounds((Aggregate)this.resource);
                    }
                }
                finally {
                    MetadataSummary.this.getter = null;
                }
            }
        }

        protected void failed() {
            if (MetadataSummary.this.getter == this) {
                MetadataSummary.this.getter = null;
                MetadataSummary.this.setError(this.getException());
            }
        }
    }
}

