/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.metadata;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringJoiner;
import javafx.concurrent.Task;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import org.apache.sis.gui.metadata.MetadataSummary;
import org.apache.sis.gui.metadata.Section;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.util.CharSequences;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicDescription;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.Identification;

final class IdentificationInfo
extends Section<Identification> {
    private static final double MAP_WIDTH = 360.0;
    private static final double MAP_HEIGHT = 180.0;
    private static final double MIN_RECT_SIZE = 6.0;
    private final Label title = new Label();
    private Canvas extentOnMap;
    private boolean isWorld;
    private boolean mapWasVisible;
    private Task<?> aggregateWalker;

    IdentificationInfo(MetadataSummary metadataSummary) {
        super(metadataSummary);
        this.title.setFont(Font.font(null, (FontWeight)FontWeight.BOLD, (double)15.0));
        this.add((Node)this.title, 0, 0, 2, 1);
        this.extentOnMap = new Canvas();
        this.add((Node)this.extentOnMap, 0, 0, 2, 1);
        IdentificationInfo.setHalignment((Node)this.extentOnMap, (HPos)HPos.CENTER);
        this.finished();
    }

    private void clearWorldMap() {
        if (!this.isWorldMapEmpty()) {
            int n = this.linesStartIndex() - 1;
            assert (this.getChildren().get(n) == this.extentOnMap);
            this.extentOnMap = new Canvas();
            this.getChildren().set(n, (Object)this.extentOnMap);
            IdentificationInfo.setColumnSpan((Node)this.extentOnMap, (Integer)2);
            IdentificationInfo.setHalignment((Node)this.extentOnMap, (HPos)HPos.CENTER);
        }
    }

    private boolean isWorldMapEmpty() {
        return this.extentOnMap.getWidth() == 0.0 && this.extentOnMap.getHeight() == 0.0;
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isWorldMapEmpty();
    }

    final void completeMissingGeographicBounds(final Aggregate aggregate) {
        if (!this.isWorld && this.isWorldMapEmpty() && !super.isEmpty() && this.numPages() == 1) {
            if (this.mapWasVisible) {
                this.drawMapBackground();
            }
            this.aggregateWalker = new Task<Set<GeographicBoundingBox>>(){

                protected Set<GeographicBoundingBox> call() throws DataStoreException {
                    LinkedHashSet<GeographicBoundingBox> linkedHashSet = new LinkedHashSet<GeographicBoundingBox>();
                    for (Resource resource : aggregate.components()) {
                        Metadata metadata = resource.getMetadata();
                        if (this.isCancelled()) break;
                        if (metadata == null) continue;
                        for (Identification identification : CollectionsExt.nonNull(metadata.getIdentificationInfo())) {
                            if (!(identification instanceof DataIdentification)) continue;
                            for (Extent extent : ((DataIdentification)identification).getExtents()) {
                                GeographicBoundingBox geographicBoundingBox = Extents.getGeographicBoundingBox((Extent)extent);
                                if (geographicBoundingBox == null) continue;
                                linkedHashSet.add(geographicBoundingBox);
                            }
                        }
                    }
                    return linkedHashSet;
                }

                protected void succeeded() {
                    IdentificationInfo.this.aggregateWalker = null;
                    IdentificationInfo.this.drawOnMap((Set)this.getValue());
                }

                protected void failed() {
                    IdentificationInfo.this.aggregateWalker = null;
                    IdentificationInfo.this.owner.setError(this.getException());
                }
            };
            BackgroundThreads.execute((Runnable)this.aggregateWalker);
        }
    }

    @Override
    void setInformation(Metadata metadata) {
        Collection collection;
        if (this.aggregateWalker != null) {
            this.aggregateWalker.cancel();
            this.aggregateWalker = null;
        }
        if (metadata == null) {
            this.clearWorldMap();
            collection = null;
        } else {
            collection = metadata.getIdentificationInfo();
        }
        this.setInformation(CollectionsExt.nonNull(collection), Identification[]::new);
    }

    @Override
    void buildContent(Identification identification) {
        Object object;
        Object object2;
        this.mapWasVisible = !this.isWorldMapEmpty();
        this.isWorld = false;
        this.clearWorldMap();
        Object object3 = null;
        Citation citation = identification.getCitation();
        if (citation != null && (object3 = this.owner.string(citation.getTitle())) == null) {
            object3 = Citations.getIdentifier((Citation)citation);
        }
        if (object3 == null) {
            object3 = this.owner.vocabulary.getString((short)210);
        } else if (CharSequences.isUnicodeIdentifier(object3)) {
            object3 = CharSequences.camelCaseToSentence((CharSequence)object3).toString();
        }
        this.title.setText((String)object3);
        if (citation != null) {
            StringJoiner stringJoiner = new StringJoiner(", ");
            object2 = citation.getIdentifiers().iterator();
            while (object2.hasNext()) {
                object = (Identifier)object2.next();
                stringJoiner.add(IdentifiedObjects.toString((Identifier)object));
            }
            if (stringJoiner.length() != 0) {
                this.addLine((short)100, stringJoiner.toString());
            }
        }
        int n = 1;
        object3 = this.owner.string(identification.getAbstract());
        if (object3 == null) {
            n = 164;
            object3 = this.owner.string(identification.getPurpose());
            if (object3 == null) {
                object2 = CollectionsExt.nonNull(identification.getCredits()).iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    object3 = object;
                    if (object3 == null) continue;
                    n = 42;
                    break;
                }
            }
        }
        this.addLine((short)n, (String)object3);
        Object object4 = object2 = identification instanceof DataIdentification ? (DataIdentification)identification : null;
        if (object2 != null) {
            this.addLine((short)198, this.owner.string(CollectionsExt.nonNull(object2.getTopicCategories())));
        }
        if (citation != null) {
            object = null;
            n = 52;
            for (CitationDate citationDate : CollectionsExt.nonNull(citation.getDates())) {
                Date date = citationDate.getDate();
                if (date == null) continue;
                DateType dateType = citationDate.getDateType();
                if (DateType.PUBLICATION.equals((Object)dateType) || DateType.valueOf((String)"RELEASED").equals((Object)dateType)) {
                    n = 163;
                    object = date;
                    break;
                }
                boolean bl = DateType.CREATION.equals((Object)dateType);
                if (object != null && !bl) continue;
                n = bl ? 41 : 52;
                object = date;
            }
            if (object != null) {
                this.addLine((short)n, this.owner.getDateFormat().format((Date)object));
            }
        }
        if (object2 != null) {
            this.addLine((short)204, this.owner.string(CollectionsExt.nonNull(object2.getSpatialRepresentationTypes())));
        }
        for (Object object5 : CollectionsExt.nonNull(identification.getResourceFormats())) {
            object3 = this.owner.string(object5.getSpecification());
            if (object3 == null) continue;
            this.addLine((short)85, (String)object3);
            break;
        }
        object3 = null;
        object = null;
        if (object2 != null) {
            for (CitationDate citationDate : CollectionsExt.nonNull(object2.getExtents())) {
                if (citationDate == null) continue;
                if (object3 == null) {
                    object3 = this.owner.string(citationDate.getDescription());
                }
                for (DateType dateType : CollectionsExt.nonNull(citationDate.getGeographicElements())) {
                    if (object == null && dateType instanceof GeographicDescription) {
                        object = ((GeographicDescription)dateType).getGeographicIdentifier();
                    }
                    if (this.isWorld || !(dateType instanceof GeographicBoundingBox)) continue;
                    this.isWorld = this.drawOnMap((GeographicBoundingBox)dateType);
                }
            }
        }
        if (object3 == null) {
            object3 = IdentifiedObjects.toString((Identifier)object);
        }
        if (this.isWorld) {
            this.clearWorldMap();
            if (object3 == null) {
                object3 = this.owner.vocabulary.getString((short)225);
            }
        }
        this.addLine((short)81, (String)object3);
        IdentificationInfo.setRowIndex((Node)this.extentOnMap, (Integer)this.nextRowIndex());
    }

    private void drawOnMap(Set<GeographicBoundingBox> set) {
        if (set.isEmpty()) {
            this.clearWorldMap();
            return;
        }
        for (GeographicBoundingBox geographicBoundingBox : set) {
            this.isWorld = this.drawOnMap(geographicBoundingBox);
            if (!this.isWorld) continue;
            this.clearWorldMap();
            return;
        }
    }

    private boolean drawOnMap(GeographicBoundingBox geographicBoundingBox) {
        double d;
        double d2 = Latitude.clamp(geographicBoundingBox.getNorthBoundLatitude());
        double d3 = Latitude.clamp(geographicBoundingBox.getSouthBoundLatitude());
        double d4 = geographicBoundingBox.getEastBoundLongitude();
        if (Math.abs(d4 - (d = geographicBoundingBox.getWestBoundLongitude())) >= 359.9999998200144) {
            if (d2 >= 89.9999999100072 && d3 <= -89.9999999100072) {
                return true;
            }
            d = -180.0;
            d4 = 180.0;
        } else {
            if (d != 180.0) {
                d = Longitude.normalize(d);
            }
            if (d4 != 180.0) {
                d4 = Longitude.normalize(d4);
            }
            if (d4 < d) {
                d4 += 360.0;
            }
        }
        if (d2 >= d3 && Double.isFinite(d4) && Double.isFinite(d)) {
            double d5;
            boolean bl;
            double d6 = 180.0 + d;
            double d7 = 90.0 - d2;
            double d8 = d4 - d;
            double d9 = d2 - d3;
            if (d8 < 6.0) {
                d6 -= (6.0 - d8) / 2.0;
                d8 = 6.0;
            }
            if (d9 < 6.0) {
                d7 -= (6.0 - d9) / 2.0;
                d9 = 6.0;
            }
            boolean bl2 = bl = (d8 -= (d5 = Math.min(d8, 360.0 - d6))) > 0.0;
            if (this.isWorldMapEmpty()) {
                this.drawMapBackground();
            }
            GraphicsContext graphicsContext = this.extentOnMap.getGraphicsContext2D();
            graphicsContext.setStroke((Paint)Color.DARKBLUE);
            graphicsContext.setGlobalAlpha(0.1);
            graphicsContext.fillRect(d6, d7, d5, d9);
            if (bl) {
                graphicsContext.fillRect(0.0, d7, d8, d9);
            }
            graphicsContext.setGlobalAlpha(1.0);
            if (!bl) {
                graphicsContext.strokeRect(d6, d7, d5, d9);
            } else {
                double d10 = d6 + d5;
                double d11 = d7 + d9;
                graphicsContext.strokePolyline(new double[]{d10, d6, d6, d10}, new double[]{d7, d7, d11, d11}, 4);
                graphicsContext.strokePolyline(new double[]{0.0, d8, d8, 0.0}, new double[]{d7, d7, d11, d11}, 4);
            }
        }
        return false;
    }

    private boolean drawMapBackground() {
        Image image = MetadataSummary.getWorldMap();
        if (image == null) {
            return false;
        }
        this.extentOnMap.setWidth(image.getWidth());
        this.extentOnMap.setHeight(image.getHeight());
        this.extentOnMap.getGraphicsContext2D().drawImage(image, 0.0, 0.0);
        return true;
    }
}

