/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.map;

import java.util.function.Predicate;
import javafx.concurrent.Task;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.gui.coverage.CoverageCanvas;
import org.apache.sis.gui.map.MapCanvas;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.logging.Logging;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

abstract class OperationFinder
extends Task<MathTransform> {
    private final GridGeometry dataGeometry;
    private final Envelope areaOfInterest;
    private final CoordinateReferenceSystem sourceCRS;
    private final CoordinateReferenceSystem targetCRS;
    private boolean sourceIsGrid;
    private boolean targetIsGrid;
    private CoordinateOperation operation;

    protected OperationFinder(MapCanvas mapCanvas, Envelope envelope, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        this.dataGeometry = OperationFinder.dataGeometry(mapCanvas);
        this.sourceCRS = coordinateReferenceSystem;
        this.targetCRS = coordinateReferenceSystem2;
        this.areaOfInterest = envelope;
    }

    private static GridGeometry dataGeometry(MapCanvas mapCanvas) {
        GridCoverage gridCoverage;
        if (mapCanvas instanceof CoverageCanvas && (gridCoverage = ((CoverageCanvas)mapCanvas).getCoverage()) != null) {
            return gridCoverage.getGridGeometry();
        }
        return null;
    }

    protected MathTransform call() throws Exception {
        DefaultGeographicBoundingBox defaultGeographicBoundingBox = null;
        if (this.areaOfInterest != null) {
            try {
                defaultGeographicBoundingBox = new DefaultGeographicBoundingBox();
                defaultGeographicBoundingBox.setBounds(this.areaOfInterest);
            }
            catch (TransformException transformException) {
                defaultGeographicBoundingBox = null;
                Logging.recoverableException(Logging.getLogger("org.apache.sis.gui"), this.getCallerClass(), this.getCallerMethod(), transformException);
            }
        }
        MathTransform mathTransform = null;
        MathTransform mathTransform2 = null;
        CoordinateReferenceSystem coordinateReferenceSystem = this.sourceCRS;
        CoordinateReferenceSystem coordinateReferenceSystem2 = this.targetCRS;
        if (this.dataGeometry != null && this.dataGeometry.isDefined(9)) {
            this.sourceIsGrid = OperationFinder.isGridCRS(coordinateReferenceSystem);
            if (this.sourceIsGrid) {
                mathTransform = this.dataGeometry.getGridToCRS(PixelInCell.CELL_CENTER);
                coordinateReferenceSystem = this.dataGeometry.getCoordinateReferenceSystem();
            }
            if (this.targetIsGrid = OperationFinder.isGridCRS(coordinateReferenceSystem2)) {
                mathTransform2 = this.dataGeometry.getGridToCRS(PixelInCell.CELL_CENTER).inverse();
                coordinateReferenceSystem2 = this.dataGeometry.getCoordinateReferenceSystem();
            }
        }
        this.operation = CRS.findOperation((CoordinateReferenceSystem)coordinateReferenceSystem, (CoordinateReferenceSystem)coordinateReferenceSystem2, (GeographicBoundingBox)defaultGeographicBoundingBox);
        MathTransform mathTransform3 = this.operation.getMathTransform();
        if (mathTransform != null) {
            mathTransform3 = MathTransforms.concatenate(mathTransform, (MathTransform)mathTransform3);
        }
        if (mathTransform2 != null) {
            mathTransform3 = MathTransforms.concatenate((MathTransform)mathTransform3, mathTransform2);
        }
        return mathTransform3;
    }

    static CoordinateReferenceSystem toGeospatial(CoordinateReferenceSystem coordinateReferenceSystem, MapCanvas mapCanvas) {
        GridGeometry gridGeometry;
        if (OperationFinder.isGridCRS(coordinateReferenceSystem) && (gridGeometry = OperationFinder.dataGeometry(mapCanvas)) != null && gridGeometry.isDefined(1)) {
            coordinateReferenceSystem = gridGeometry.getCoordinateReferenceSystem();
        }
        return coordinateReferenceSystem;
    }

    private static boolean isGridCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        return coordinateReferenceSystem instanceof SingleCRS && CommonCRS.Engineering.GRID.datum().equals(((SingleCRS)coordinateReferenceSystem).getDatum());
    }

    public final CoordinateOperation getOperation() {
        return this.operation;
    }

    public final CoordinateReferenceSystem getTargetCRS() {
        CoordinateReferenceSystem coordinateReferenceSystem;
        if (!this.targetIsGrid && (coordinateReferenceSystem = this.operation.getTargetCRS()) != null) {
            return coordinateReferenceSystem;
        }
        return this.targetCRS;
    }

    final Predicate<MapCanvas> fullOperationSearchRequired() {
        return this.sourceIsGrid | this.targetIsGrid ? new UpdateCheck(this.dataGeometry) : null;
    }

    protected abstract Class<?> getCallerClass();

    protected abstract String getCallerMethod();

    private static final class UpdateCheck
    implements Predicate<MapCanvas> {
        private final GridGeometry dataGeometry;

        UpdateCheck(GridGeometry gridGeometry) {
            this.dataGeometry = gridGeometry;
        }

        @Override
        public boolean test(MapCanvas mapCanvas) {
            return !this.dataGeometry.equals((Object)OperationFinder.dataGeometry(mapCanvas));
        }
    }
}

