/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.map;

import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.GestureEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.transform.Affine;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Transform;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.gui.referencing.PositionableProjection;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.GUIUtilities;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.system.DelayedExecutor;
import org.apache.sis.internal.system.DelayedRunnable;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.portrayal.PlanarCanvas;
import org.apache.sis.portrayal.RenderException;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public abstract class MapCanvas
extends PlanarCanvas {
    private static final double SCROLL_EVENT_SIZE = 40.0;
    private static final double ZOOM_FACTOR = 0.1;
    private static final double CONTROL_KEY_FACTOR = 10.0;
    private static final long REPAINT_DELAY = 100L;
    private static final long WAIT_CURSOR_DELAY = 900000000L;
    protected final Pane floatingPane;
    protected final StackPane fixedPane;
    private Envelope objectiveBounds;
    private int contentChangeCount;
    private int renderedContentStamp;
    private long renderingStartTime;
    private Task<?> renderingInProgress;
    private boolean sizeChanged;
    private boolean invalidObjectiveToDisplay;
    private final Affine transform = new Affine();
    private final Affine changeInProgress = new Affine();
    private double xPanStart;
    private double yPanStart;
    private boolean isDragging;
    private boolean isMouseChangeScheduled;
    private final ReadOnlyBooleanWrapper isRendering;
    private final ReadOnlyObjectWrapper<Throwable> error;
    private ContextMenu menuShown;

    public MapCanvas(Locale locale) {
        super(locale);
        Pane pane = new Pane(){

            protected void layoutChildren() {
                super.layoutChildren();
                if (MapCanvas.this.contentsChanged()) {
                    MapCanvas.this.repaint();
                }
            }
        };
        pane.getTransforms().add((Object)this.transform);
        pane.setOnZoom(zoomEvent -> this.applyZoomOrRotate((GestureEvent)zoomEvent, zoomEvent.getZoomFactor(), 0.0));
        pane.setOnRotate(rotateEvent -> this.applyZoomOrRotate((GestureEvent)rotateEvent, 1.0, rotateEvent.getAngle()));
        pane.setOnScroll(this::onScroll);
        pane.setOnMousePressed(this::onDrag);
        pane.setOnMouseDragged(this::onDrag);
        pane.setOnMouseReleased(this::onDrag);
        pane.setFocusTraversable(true);
        pane.addEventHandler(KeyEvent.KEY_PRESSED, this::onKeyTyped);
        pane.layoutBoundsProperty().addListener(observable -> this.onSizeChanged());
        pane.setCursor(Cursor.CROSSHAIR);
        this.floatingPane = pane;
        this.fixedPane = new StackPane(new Node[]{pane});
        GUIUtilities.setClipToBounds((Pane)this.fixedPane);
        this.isRendering = new ReadOnlyBooleanWrapper((Object)this, "isRendering");
        this.error = new ReadOnlyObjectWrapper((Object)this, "error");
    }

    private void onSizeChanged() {
        this.sizeChanged = true;
        this.requestRepaint();
    }

    private void onDrag(MouseEvent mouseEvent) {
        double d = mouseEvent.getX();
        double d2 = mouseEvent.getY();
        EventType eventType = mouseEvent.getEventType();
        if (eventType == MouseEvent.MOUSE_PRESSED) {
            switch (mouseEvent.getButton()) {
                case PRIMARY: {
                    this.hideContextMenu();
                    this.floatingPane.setCursor(Cursor.CLOSED_HAND);
                    this.floatingPane.requestFocus();
                    this.isDragging = true;
                    this.xPanStart = d;
                    this.yPanStart = d2;
                    mouseEvent.consume();
                }
            }
        } else if (this.isDragging) {
            if (eventType != MouseEvent.MOUSE_DRAGGED) {
                if (this.floatingPane.getCursor() == Cursor.CLOSED_HAND) {
                    this.floatingPane.setCursor(Cursor.CROSSHAIR);
                }
                this.isDragging = false;
            }
            this.applyTranslation(d - this.xPanStart, d2 - this.yPanStart, eventType == MouseEvent.MOUSE_RELEASED);
            mouseEvent.consume();
        }
    }

    private void restoreCursorAfterPaint() {
        this.floatingPane.setCursor(this.isDragging ? Cursor.CLOSED_HAND : Cursor.CROSSHAIR);
    }

    private void applyTranslation(double d, double d2, boolean bl) {
        if (d != 0.0 || d2 != 0.0) {
            this.transform.appendTranslation(d, d2);
            if (!bl) {
                this.requestRepaint();
                return;
            }
        }
        if (bl && !this.transform.isIdentity()) {
            this.repaint();
        }
    }

    private void onScroll(ScrollEvent scrollEvent) {
        if (scrollEvent.getTouchCount() != 0) {
            return;
        }
        double d = scrollEvent.getDeltaY();
        double d2 = Math.abs(d) / 40.0 * 0.1;
        if (scrollEvent.isControlDown()) {
            d2 /= 10.0;
        }
        d2 += 1.0;
        if (d < 0.0) {
            d2 = 1.0 / d2;
        }
        this.applyZoomOrRotate((GestureEvent)scrollEvent, d2, 0.0);
    }

    private void applyZoomOrRotate(GestureEvent gestureEvent, double d, double d2) {
        if (d != 1.0 || d2 != 0.0) {
            double d3;
            double d4;
            if (gestureEvent != null) {
                d4 = gestureEvent.getX();
                d3 = gestureEvent.getY();
            } else {
                Bounds bounds = this.floatingPane.getLayoutBounds();
                d4 = bounds.getCenterX();
                d3 = bounds.getCenterY();
                try {
                    Point2D point2D = this.transform.inverseTransform(d4, d3);
                    d4 = point2D.getX();
                    d3 = point2D.getY();
                }
                catch (NonInvertibleTransformException nonInvertibleTransformException) {
                    MapCanvas.unexpectedException("onKeyTyped", nonInvertibleTransformException);
                }
            }
            if (d != 1.0) {
                this.transform.appendScale(d, d, d4, d3);
            }
            if (d2 != 0.0) {
                this.transform.appendRotation(d2, d4, d3);
            }
            this.requestRepaint();
        }
        if (gestureEvent != null) {
            gestureEvent.consume();
        }
    }

    private void onKeyTyped(KeyEvent keyEvent) {
        double d;
        double d2;
        double d3;
        double d4;
        block17: {
            block16: {
                d4 = 0.0;
                d3 = 0.0;
                d2 = 1.0;
                d = 0.0;
                if (!keyEvent.isAltDown()) break block16;
                switch (keyEvent.getCode()) {
                    case RIGHT: 
                    case KP_RIGHT: {
                        d = 7.5;
                        break block17;
                    }
                    case LEFT: 
                    case KP_LEFT: {
                        d = -7.5;
                        break block17;
                    }
                    default: {
                        return;
                    }
                }
            }
            switch (keyEvent.getCode()) {
                case RIGHT: 
                case KP_RIGHT: {
                    d4 = -40.0;
                    break;
                }
                case LEFT: 
                case KP_LEFT: {
                    d4 = 40.0;
                    break;
                }
                case DOWN: 
                case KP_DOWN: {
                    d3 = -40.0;
                    break;
                }
                case UP: 
                case KP_UP: {
                    d3 = 40.0;
                    break;
                }
                case PAGE_UP: {
                    d2 = 0.9090909090909091;
                    break;
                }
                case PAGE_DOWN: {
                    d2 = 1.1;
                    break;
                }
                case HOME: {
                    this.reset();
                    break;
                }
                default: {
                    return;
                }
            }
        }
        if (keyEvent.isControlDown()) {
            d4 /= 10.0;
            d3 /= 10.0;
            d /= 10.0;
            d2 = (d2 - 1.0) / 10.0 + 1.0;
        }
        try {
            Point2D point2D = this.transform.inverseDeltaTransform(d4, d3);
            d4 = point2D.getX();
            d3 = point2D.getY();
        }
        catch (NonInvertibleTransformException nonInvertibleTransformException) {
            MapCanvas.unexpectedException("onKeyTyped", nonInvertibleTransformException);
        }
        this.applyZoomOrRotate(null, d2, d);
        this.applyTranslation(d4, d3, false);
        keyEvent.consume();
    }

    public void reset() {
        this.invalidObjectiveToDisplay = true;
        this.requestRepaint();
    }

    private void hideContextMenu() {
        if (this.menuShown != null) {
            this.menuShown.hide();
            this.menuShown = null;
        }
    }

    private void setObjectiveCRS(CoordinateReferenceSystem coordinateReferenceSystem, DirectPosition directPosition, ObservableValue<? extends ReferenceSystem> observableValue) {
        CoordinateReferenceSystem coordinateReferenceSystem2 = this.getObjectiveCRS();
        if (coordinateReferenceSystem != coordinateReferenceSystem2) {
            try {
                Envelope2D envelope2D;
                if (directPosition == null && (envelope2D = this.getDisplayBounds()) != null) {
                    directPosition = AbstractEnvelope.castOrCopy((Envelope)envelope2D).getMedian();
                }
                this.setObjectiveCRS(coordinateReferenceSystem, directPosition);
                this.requestRepaint();
            }
            catch (Exception exception) {
                if (observableValue instanceof WritableValue) {
                    ((WritableValue)observableValue).setValue((Object)coordinateReferenceSystem2);
                }
                this.errorOccurred(exception);
                Locale locale = this.getLocale();
                Resources resources = Resources.forLocale(locale);
                ExceptionReporter.show((Node)this.fixedPane, null, resources.getString((short)9, IdentifiedObjects.getDisplayName((IdentifiedObject)coordinateReferenceSystem, (Locale)locale)), (Throwable)exception);
            }
        }
    }

    protected void setObjectiveBounds(Envelope envelope) {
        ArgumentChecks.ensureDimensionMatches("bounds", 2, envelope);
        this.objectiveBounds = ImmutableEnvelope.castOrCopy((Envelope)envelope);
        this.invalidObjectiveToDisplay = true;
    }

    private static AxisDirection[] toDisplayDirections(AxisDirection[] axisDirectionArray) {
        Object[] objectArray = Arrays.copyOf(axisDirectionArray, 2);
        if (AxisDirections.absolute((AxisDirection)objectArray[0]) == AxisDirection.NORTH && AxisDirections.absolute((AxisDirection)objectArray[1]) == AxisDirection.EAST) {
            ArraysExt.swap(objectArray, 0, 1);
        }
        if (AxisDirections.absolute((AxisDirection)objectArray[0]) == AxisDirection.WEST) {
            objectArray[0] = AxisDirection.EAST;
        }
        if (AxisDirections.absolute((AxisDirection)objectArray[1]) == AxisDirection.NORTH) {
            objectArray[1] = AxisDirection.SOUTH;
        }
        return objectArray;
    }

    protected abstract Renderer createRenderer();

    final boolean contentsChanged() {
        return this.contentChangeCount != this.renderedContentStamp;
    }

    public final void requestRepaint() {
        ++this.contentChangeCount;
        if (this.renderingInProgress == null && !this.isRendering.get()) {
            Delayed delayed = new Delayed();
            BackgroundThreads.execute((Runnable)((Object)delayed));
            this.renderingInProgress = delayed;
        }
    }

    final void repaint() {
        GridExtent gridExtent;
        Object object;
        assert (Platform.isFxApplicationThread());
        if (this.renderingInProgress != null) {
            if (this.renderingInProgress instanceof Delayed) {
                this.renderingInProgress.cancel(true);
                this.renderingInProgress = null;
            } else {
                ++this.contentChangeCount;
                return;
            }
        }
        this.isRendering.set(true);
        this.renderingStartTime = System.nanoTime();
        try {
            if (this.sizeChanged) {
                this.sizeChanged = false;
                object = this.floatingPane;
                gridExtent = new Envelope2D(null, object.getLayoutX(), object.getLayoutY(), object.getWidth(), object.getHeight());
                if (gridExtent.isEmpty()) {
                    return;
                }
                this.setDisplayBounds((Envelope)gridExtent);
            }
            if (this.invalidObjectiveToDisplay) {
                LinearTransform linearTransform;
                EngineeringCRS engineeringCRS;
                object = this.getDisplayBounds();
                if (object == null) {
                    return;
                }
                this.invalidObjectiveToDisplay = false;
                gridExtent = new GridExtent(null, new long[]{Math.round(object.getMinX()), Math.round(object.getMinY())}, new long[]{Math.round(object.getMaxX()), Math.round(object.getMaxY())}, false);
                if (this.objectiveBounds != null) {
                    MatrixSIS matrixSIS;
                    engineeringCRS = this.objectiveBounds.getCoordinateReferenceSystem();
                    if (engineeringCRS != null) {
                        AxisDirection[] axisDirectionArray = CoordinateSystems.getAxisDirections((CoordinateSystem)engineeringCRS.getCoordinateSystem());
                        matrixSIS = Matrices.createTransform((Envelope)this.objectiveBounds, (AxisDirection[])axisDirectionArray, (Envelope)object, (AxisDirection[])MapCanvas.toDisplayDirections(axisDirectionArray));
                    } else {
                        matrixSIS = Matrices.createTransform((Envelope)this.objectiveBounds, (Envelope)object);
                    }
                    Matrices.forceUniformScale((Matrix)matrixSIS, (double)0.0, (double[])new double[]{object.getCenterX(), object.getCenterY()});
                    linearTransform = MathTransforms.linear((Matrix)matrixSIS);
                    if (engineeringCRS == null) {
                        engineeringCRS = gridExtent.toEnvelope((MathTransform)linearTransform.inverse()).getCoordinateReferenceSystem();
                    }
                } else {
                    engineeringCRS = this.getDisplayCRS();
                    linearTransform = MathTransforms.identity((int)2);
                }
                this.setGridGeometry(new GridGeometry(gridExtent, PixelInCell.CELL_CORNER, (MathTransform)linearTransform.inverse(), (CoordinateReferenceSystem)engineeringCRS));
                this.transform.setToIdentity();
            }
        }
        catch (RenderException | TransformException throwable) {
            this.restoreCursorAfterPaint();
            this.isRendering.set(false);
            this.errorOccurred(throwable);
            return;
        }
        this.changeInProgress.setToTransform((Transform)this.transform);
        if (!this.transform.isIdentity()) {
            this.transformDisplayCoordinates(new AffineTransform(this.transform.getMxx(), this.transform.getMyx(), this.transform.getMxy(), this.transform.getMyy(), this.transform.getTx(), this.transform.getTy()));
        }
        this.renderedContentStamp = this.contentChangeCount;
        object = this.createRenderer();
        if (object != null && ((Renderer)object).initialize(this.floatingPane)) {
            gridExtent = this.createWorker((Renderer)object);
            assert (this.renderingInProgress == null);
            BackgroundThreads.execute(gridExtent);
            this.renderingInProgress = gridExtent;
            if (!this.isMouseChangeScheduled) {
                DelayedExecutor.schedule(new CursorChange());
                this.isMouseChangeScheduled = true;
            }
        } else {
            this.clearError();
            this.isRendering.set(false);
            this.restoreCursorAfterPaint();
        }
    }

    Task<?> createWorker(final Renderer renderer) {
        return new Task<Void>(){

            protected Void call() throws Exception {
                renderer.render();
                return null;
            }

            protected void succeeded() {
                boolean bl = renderer.commit(MapCanvas.this);
                MapCanvas.this.renderingCompleted(this);
                if (!bl || MapCanvas.this.contentsChanged()) {
                    MapCanvas.this.repaint();
                }
            }

            protected void failed() {
                MapCanvas.this.renderingCompleted(this);
            }

            protected void cancelled() {
                MapCanvas.this.renderingCompleted(this);
            }
        };
    }

    final void renderingCompleted(Task<?> task) {
        assert (Platform.isFxApplicationThread());
        if (!this.contentsChanged() || task.getState() != Worker.State.SUCCEEDED) {
            this.restoreCursorAfterPaint();
        }
        this.renderingInProgress = null;
        Point2D point2D = this.changeInProgress.transform(this.xPanStart, this.yPanStart);
        this.xPanStart = point2D.getX();
        this.yPanStart = point2D.getY();
        try {
            this.changeInProgress.invert();
            this.transform.prepend((Transform)this.changeInProgress);
        }
        catch (NonInvertibleTransformException nonInvertibleTransformException) {
            MapCanvas.unexpectedException("repaint", nonInvertibleTransformException);
        }
        this.isRendering.set(false);
        Throwable throwable = task.getException();
        if (throwable != null) {
            this.errorOccurred(throwable);
        }
    }

    private void paintAfterDelay() {
        this.renderingInProgress = null;
        this.repaint();
    }

    private void setWaitCursor(long l) {
        this.isMouseChangeScheduled = false;
        if (this.renderingInProgress != null) {
            if (l == this.renderingStartTime) {
                this.floatingPane.setCursor(Cursor.WAIT);
            }
            DelayedExecutor.schedule(new CursorChange());
            this.isMouseChangeScheduled = true;
        }
    }

    public final ReadOnlyBooleanProperty renderingProperty() {
        return this.isRendering.getReadOnlyProperty();
    }

    public final ReadOnlyObjectProperty<Throwable> errorProperty() {
        return this.error.getReadOnlyProperty();
    }

    protected final void clearError() {
        this.error.set(null);
    }

    protected void errorOccurred(Throwable throwable) {
        Throwable throwable2 = (Throwable)this.error.get();
        if (throwable2 != null) {
            throwable2.addSuppressed(throwable);
        } else {
            this.error.set((Object)Objects.requireNonNull(throwable));
        }
    }

    private static void unexpectedException(String string, NonInvertibleTransformException nonInvertibleTransformException) {
        Logging.unexpectedException(Logging.getLogger("org.apache.sis.gui"), MapCanvas.class, string, nonInvertibleTransformException);
    }

    protected void clear() {
        assert (Platform.isFxApplicationThread());
        this.transform.setToIdentity();
        this.changeInProgress.setToIdentity();
        this.invalidObjectiveToDisplay = true;
        this.objectiveBounds = null;
        this.clearError();
        this.isRendering.set(false);
        this.requestRepaint();
    }

    private final class Delayed
    extends Task<Void> {
        private Delayed() {
        }

        protected Void call() {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }

        protected void succeeded() {
            MapCanvas.this.paintAfterDelay();
        }

        protected void failed() {
            MapCanvas.this.paintAfterDelay();
        }
    }

    protected static abstract class Renderer {
        private int width;
        private int height;

        protected Renderer() {
        }

        private boolean initialize(Pane pane) {
            this.width = Numerics.clamp(Math.round(pane.getWidth()));
            this.height = Numerics.clamp(Math.round(pane.getHeight()));
            return this.width > 0 && this.height > 0;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        protected abstract void render() throws Exception;

        protected abstract boolean commit(MapCanvas var1);
    }

    private final class CursorChange
    extends DelayedRunnable {
        private final long startTime;

        CursorChange() {
            super(MapCanvas.this.renderingStartTime + 900000000L);
            this.startTime = MapCanvas.this.renderingStartTime;
        }

        @Override
        public void run() {
            Platform.runLater(() -> MapCanvas.this.setWaitCursor(this.startTime));
        }
    }

    final class MenuHandler
    extends DirectPosition2D
    implements EventHandler<MouseEvent>,
    ChangeListener<ReferenceSystem>,
    PropertyChangeListener {
        private final ContextMenu menu;
        ObjectProperty<ReferenceSystem> selectedCrsProperty;
        ToggleGroup positionables;
        private boolean isPositionableProjection;

        MenuHandler(ContextMenu contextMenu) {
            super((CoordinateReferenceSystem)MapCanvas.this.getDisplayCRS());
            this.menu = contextMenu;
            MapCanvas.this.fixedPane.setOnMousePressed((EventHandler)this);
            MapCanvas.this.fixedPane.setOnMouseReleased((EventHandler)this);
        }

        public void handle(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                MapCanvas.this.hideContextMenu();
                this.x = mouseEvent.getX();
                this.y = mouseEvent.getY();
                this.menu.show((Node)((Pane)mouseEvent.getSource()), mouseEvent.getScreenX(), mouseEvent.getScreenY());
                MapCanvas.this.menuShown = this.menu;
                mouseEvent.consume();
            }
        }

        public void changed(ObservableValue<? extends ReferenceSystem> observableValue, ReferenceSystem referenceSystem, ReferenceSystem referenceSystem2) {
            if (referenceSystem2 instanceof CoordinateReferenceSystem) {
                MapCanvas.this.setObjectiveCRS((CoordinateReferenceSystem)referenceSystem2, (DirectPosition)this, observableValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void createProjectedCRS(PositionableProjection positionableProjection) {
            try {
                DirectPosition2D directPosition2D = new DirectPosition2D();
                directPosition2D = (DirectPosition2D)MapCanvas.this.objectiveToDisplay.inverseTransform((java.awt.geom.Point2D)((Object)this), (java.awt.geom.Point2D)directPosition2D);
                directPosition2D.setCoordinateReferenceSystem(MapCanvas.this.getObjectiveCRS());
                ProjectedCRS projectedCRS = positionableProjection.createProjectedCRS((DirectPosition)directPosition2D);
                try {
                    this.isPositionableProjection = true;
                    MapCanvas.this.setObjectiveCRS((CoordinateReferenceSystem)projectedCRS, (DirectPosition)this, null);
                }
                finally {
                    this.isPositionableProjection = false;
                }
            }
            catch (Exception exception) {
                MapCanvas.this.errorOccurred(exception);
                Resources resources = Resources.forLocale(MapCanvas.this.getLocale());
                ExceptionReporter.show((Node)MapCanvas.this.fixedPane, null, resources.getString((short)9, (Object)positionableProjection), (Throwable)exception);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("objectiveCRS".equals(propertyChangeEvent.getPropertyName())) {
                Object object = propertyChangeEvent.getNewValue();
                if (object instanceof CoordinateReferenceSystem) {
                    this.selectedCrsProperty.set((Object)((CoordinateReferenceSystem)object));
                }
                if (!this.isPositionableProjection) {
                    this.positionables.selectToggle(null);
                }
            }
        }
    }
}

