/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.apache.sis.gui.dataset.CopyAction;
import org.apache.sis.gui.dataset.LoadEvent;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.LogHandler;
import org.apache.sis.internal.gui.ResourceLoader;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.identification.Identification;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class ResourceTree
extends TreeView<Resource> {
    final Locale locale = Locale.getDefault();
    public final ObjectProperty<EventHandler<LoadEvent>> onResourceLoaded;

    public ResourceTree() {
        this.setCellFactory(treeView -> new Cell());
        this.setOnDragOver(ResourceTree::onDragOver);
        this.setOnDragDropped(this::onDragDropped);
        this.onResourceLoaded = new SimpleObjectProperty((Object)this, "onResourceLoaded");
    }

    public Resource getResource() {
        TreeItem treeItem = this.getRoot();
        return treeItem == null ? null : (Resource)treeItem.getValue();
    }

    public void setResource(Resource resource) {
        this.setRoot(resource == null ? null : new Item(resource));
        this.setShowRoot(!(resource instanceof Root));
    }

    public boolean addResource(Resource resource) {
        Resource resource2;
        assert (Platform.isFxApplicationThread());
        if (resource == null) {
            return false;
        }
        TreeItem treeItem = this.getRoot();
        if (treeItem != null && (resource2 = (Resource)treeItem.getValue()) != null) {
            Root root;
            if (resource2 == resource) {
                return false;
            }
            if (resource2 instanceof Root) {
                root = (Root)resource2;
            } else {
                TreeItem treeItem2 = new TreeItem();
                root = new Root((TreeItem<Resource>)treeItem2, resource2);
                treeItem2.setValue((Object)root);
                this.setRoot(treeItem2);
                this.setShowRoot(false);
            }
            return root.add(resource);
        }
        this.setRoot(new Item(resource));
        this.setShowRoot(true);
        return true;
    }

    public void loadResource(Object object) {
        if (object != null) {
            if (object instanceof Resource) {
                this.addResource((Resource)object);
            } else {
                ResourceLoader resourceLoader = new ResourceLoader(object);
                DataStore dataStore = resourceLoader.fromCache();
                if (dataStore != null) {
                    this.addResource((Resource)dataStore);
                } else {
                    resourceLoader.setOnSucceeded(workerStateEvent -> {
                        this.addResource((Resource)workerStateEvent.getSource().getValue());
                        this.notifyLoaded(object);
                    });
                    resourceLoader.setOnFailed(workerStateEvent -> ExceptionReporter.show((Node)this, workerStateEvent));
                    BackgroundThreads.execute((Runnable)((Object)resourceLoader));
                }
            }
        }
    }

    private void notifyLoaded(Object object) {
        EventHandler eventHandler = (EventHandler)this.onResourceLoaded.getValue();
        if (eventHandler != null) {
            Path path;
            try {
                path = IOUtilities.toPathOrNull((Object)object);
            }
            catch (IllegalArgumentException | FileSystemNotFoundException runtimeException) {
                Logging.recoverableException(Logging.getLogger("org.apache.sis.gui"), ResourceTree.class, "loadResource", runtimeException);
                return;
            }
            if (path != null) {
                eventHandler.handle((Event)new LoadEvent(this, path));
            }
        }
    }

    private void onDragDropped(DragEvent dragEvent) {
        Dragboard dragboard = dragEvent.getDragboard();
        List list = dragboard.getFiles();
        boolean bl = false;
        if (list != null) {
            for (File file : list) {
                this.loadResource(file);
            }
            bl = true;
        } else {
            String string = dragboard.getUrl();
            if (string != null) {
                try {
                    this.loadResource(new URL(string));
                    bl = true;
                }
                catch (MalformedURLException malformedURLException) {
                    int n = string.lastIndexOf(47, string.length() - 2) + 1;
                    int n2 = string.indexOf(63, n);
                    if (n2 <= 0) {
                        n2 = string.length();
                    }
                    ExceptionReporter.canNotReadFile((Node)this, string.substring(n, n2), malformedURLException);
                }
            }
        }
        dragEvent.setDropCompleted(bl);
        dragEvent.consume();
    }

    private static void onDragOver(DragEvent dragEvent) {
        Dragboard dragboard = dragEvent.getDragboard();
        if (dragboard.hasFiles() || dragboard.hasUrl()) {
            dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
        }
        dragEvent.consume();
    }

    public void removeAndClose(Resource resource) {
        if (this.findOrRemove(resource, true) && resource instanceof DataStore) {
            ResourceLoader.removeAndClose((DataStore)resource, (Node)this);
        }
    }

    private boolean findOrRemove(Resource resource, boolean bl) {
        assert (Platform.isFxApplicationThread());
        if (resource != null) {
            Resource resource2;
            TreeItem treeItem;
            if (bl) {
                treeItem = this.getSelectionModel().getSelectedItems();
                int n = treeItem.size();
                while (--n >= 0) {
                    if (((TreeItem)treeItem.get(n)).getValue() != resource) continue;
                    this.getSelectionModel().clearSelection(n);
                }
            }
            if ((treeItem = this.getRoot()) != null && (resource2 = (Resource)treeItem.getValue()) != null) {
                if (resource2 == resource) {
                    if (bl) {
                        this.setRoot(null);
                    }
                    return true;
                }
                if (resource2 instanceof Root) {
                    if (bl) {
                        return ((Root)resource2).remove(resource);
                    }
                    return ((Root)resource2).contains(resource);
                }
            }
        }
        return false;
    }

    final Resources localized() {
        return Resources.forLocale(this.locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final String getTitle(Resource resource, boolean bl) {
        Object object;
        Throwable throwable;
        block16: {
            throwable = null;
            if (resource != null) {
                try {
                    object = LogHandler.loadingStart(resource);
                    try {
                        String string;
                        Object object2;
                        Object object3;
                        Object object4;
                        Object object5;
                        if (resource instanceof DataStore && (object5 = Strings.trimOrNull(((DataStore)resource).getDisplayName())) != null) {
                            String string2 = object5;
                            return string2;
                        }
                        object5 = null;
                        Metadata metadata = resource.getMetadata();
                        if (metadata != null && (object5 = metadata.getIdentificationInfo()) != null) {
                            object4 = object5.iterator();
                            while (object4.hasNext()) {
                                object3 = (Identification)object4.next();
                                object2 = object3.getCitation();
                                if (object2 == null || (string = this.string(object2.getTitle())) == null) continue;
                                String string3 = string;
                                return string3;
                            }
                        }
                        if (((Optional)(object4 = resource.getIdentifier())).isPresent() && (object3 = this.string(((GenericName)((Optional)object4).get()).toInternationalString())) != null) {
                            object2 = object3;
                            return object2;
                        }
                        if (object5 != null) {
                            object3 = object5.iterator();
                            while (object3.hasNext()) {
                                object2 = (Identification)object3.next();
                                string = Citations.getIdentifier((Citation)object2.getCitation());
                                if (string == null) continue;
                                String string4 = string;
                                return string4;
                            }
                        }
                    }
                    finally {
                        LogHandler.loadingStop((Long)object);
                    }
                }
                catch (RuntimeException | DataStoreException throwable2) {
                    if (!bl) break block16;
                    throwable = throwable2;
                }
            }
        }
        object = Vocabulary.getResources(this.locale).getString((short)208);
        if (throwable == null) return object;
        return (String)object + " \u2014 " + this.string(throwable);
    }

    private String string(InternationalString internationalString) {
        return internationalString != null ? Strings.trimOrNull(internationalString.toString(this.locale)) : null;
    }

    private String string(Throwable throwable) {
        String string = Strings.trimOrNull(Exceptions.getLocalizedMessage(throwable, this.locale));
        if (string == null) {
            string = Classes.getShortClassName(throwable);
        }
        return string;
    }

    static void unexpectedException(String string, Exception exception) {
        Logging.unexpectedException(Logging.getLogger("org.apache.sis.gui"), ResourceTree.class, string, exception);
    }

    private static final class Item
    extends TreeItem<Resource> {
        private final boolean isLeaf;
        private boolean isChildrenKnown;

        Item(Resource resource) {
            super((Object)resource);
            this.isLeaf = !(resource instanceof Aggregate);
            LogHandler.installListener(resource);
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public ObservableList<TreeItem<Resource>> getChildren() {
            ObservableList observableList = super.getChildren();
            if (!this.isChildrenKnown) {
                this.isChildrenKnown = true;
                Resource resource = (Resource)this.getValue();
                if (resource instanceof Aggregate) {
                    BackgroundThreads.execute((Runnable)((Object)new GetChildren((Aggregate)resource)));
                    observableList.add((Object)new Item(PseudoResource.LOADING));
                }
            }
            return observableList;
        }

        private void setResources(List<TreeItem<Resource>> list) {
            super.getChildren().setAll(list);
        }

        private final class GetChildren
        extends Task<List<TreeItem<Resource>>> {
            private final Aggregate resource;

            GetChildren(Aggregate aggregate) {
                this.resource = aggregate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<TreeItem<Resource>> call() throws DataStoreException {
                ArrayList<TreeItem<Resource>> arrayList = new ArrayList<TreeItem<Resource>>();
                Long l = LogHandler.loadingStart((Resource)this.resource);
                try {
                    for (Resource resource : this.resource.components()) {
                        arrayList.add(new Item(resource));
                    }
                }
                finally {
                    LogHandler.loadingStop(l);
                }
                return arrayList;
            }

            protected void succeeded() {
                Item.this.setResources((List)this.getValue());
            }

            protected void failed() {
                Item.this.setResources(Collections.singletonList(new Item(new Unloadable(this.getException()))));
            }
        }
    }

    private static final class Root
    extends PseudoResource
    implements Aggregate {
        private final List<TreeItem<Resource>> components;

        Root(TreeItem<Resource> treeItem, Resource resource) {
            this.components = treeItem.getChildren();
            this.add(resource);
        }

        boolean contains(Resource resource) {
            int n = this.components.size();
            while (--n >= 0) {
                if (this.components.get(n).getValue() != resource) continue;
                return true;
            }
            return false;
        }

        boolean add(Resource resource) {
            int n = this.components.size();
            while (--n >= 0) {
                if (this.components.get(n).getValue() != resource) continue;
                return false;
            }
            return this.components.add(new Item(resource));
        }

        boolean remove(Resource resource) {
            return this.components.removeIf(treeItem -> treeItem.getValue() == resource);
        }

        public Collection<Resource> components() {
            return new AbstractList<Resource>(){

                @Override
                public int size() {
                    return components.size();
                }

                @Override
                public Resource get(int n) {
                    return (Resource)components.get(n).getValue();
                }
            };
        }
    }

    private static final class Cell
    extends TreeCell<Resource> {
        private static final int COPY_PATH = 0;
        private static final int CLOSE = 1;

        Cell() {
        }

        protected void updateItem(Resource resource, boolean bl) {
            Throwable throwable;
            ResourceTree resourceTree = this.getItem() != resource ? (ResourceTree)this.getTreeView() : null;
            super.updateItem((Object)resource, bl);
            Color color = Styles.NORMAL_TEXT;
            String string = null;
            Button button = null;
            if (!bl) {
                if (resource == PseudoResource.LOADING) {
                    color = Styles.LOADING_TEXT;
                    if (resourceTree != null) {
                        string = resourceTree.localized().getString((short)24);
                    }
                } else if (resource instanceof Unloadable) {
                    color = Styles.ERROR_TEXT;
                    if (resourceTree != null) {
                        throwable = ((Unloadable)resource).failure;
                        string = resourceTree.string(throwable);
                        button = new Button("\u2139\ufe0f");
                        button.setOnAction(actionEvent -> {
                            Resources resources = resourceTree.localized();
                            ExceptionReporter.show((Node)resourceTree, resources.getString((short)17), resources.getString((short)7), throwable);
                        });
                    }
                } else if (resourceTree != null) {
                    string = resourceTree.getTitle(resource, true);
                }
            }
            this.setTextFill((Paint)(this.isSelected() ? Styles.SELECTED_TEXT : color));
            if (resourceTree != null) {
                this.setText(string);
                this.setGraphic((Node)button);
                throwable = null;
                if (resourceTree.findOrRemove(resource, false)) {
                    Object object;
                    throwable = this.getContextMenu();
                    if (throwable == null) {
                        throwable = new ContextMenu();
                        object = resourceTree.localized();
                        Object[] objectArray = new MenuItem[]{((Resources)object).menu((short)51, new CopyAction(this)), ((Resources)object).menu((short)10, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> ((ResourceTree)this.getTreeView()).removeAndClose((Resource)this.getItem())))};
                        throwable.getItems().setAll(objectArray);
                    }
                    try {
                        object = URIDataStore.location((Resource)resource);
                    }
                    catch (DataStoreException dataStoreException) {
                        object = null;
                        ResourceTree.unexpectedException("updateItem", (Exception)((Object)dataStoreException));
                    }
                    ((MenuItem)throwable.getItems().get(0)).setDisable(!IOUtilities.isKindOfPath((Object)object));
                }
                this.setContextMenu((ContextMenu)throwable);
            }
        }
    }

    private static class PseudoResource
    implements Resource {
        static final PseudoResource LOADING = new PseudoResource();

        PseudoResource() {
        }

        public Optional<GenericName> getIdentifier() {
            return Optional.empty();
        }

        public Metadata getMetadata() {
            return null;
        }

        public <T extends StoreEvent> void addListener(Class<T> clazz, StoreListener<? super T> storeListener) {
        }

        public <T extends StoreEvent> void removeListener(Class<T> clazz, StoreListener<? super T> storeListener) {
        }
    }

    private static final class Unloadable
    extends PseudoResource {
        final Throwable failure;

        Unloadable(Throwable throwable) {
            this.failure = throwable;
        }
    }
}

