/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.util.StringConverter;
import org.apache.sis.gui.Widget;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.ImmutableObjectProperty;
import org.apache.sis.internal.gui.LogHandler;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.storage.Resource;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.logging.PerformanceLevel;
import org.apache.sis.util.resources.Vocabulary;

public class LogViewer
extends Widget {
    private static final int SPACE = 6;
    private static final Insets MARGIN = new Insets(6.0, 0.0, 0.0, 0.0);
    private static final Insets BAR_INSETS = new Insets(6.0);
    private static final Map<Level, String> LEVEL_NAMES = new HashMap<Level, String>(12);
    private final TableView<LogRecord> table;
    private final SplitPane view;
    private final Label level;
    private final Label time;
    private final Label logger;
    private final Label classe;
    private final Label method;
    private final TextArea message;
    public final ObjectProperty<Resource> source = new SimpleObjectProperty((Object)this, "source");
    public final BooleanProperty systemLogs = new SimpleBooleanProperty((Object)this, "systemLogs");
    private final IsEmpty isEmpty = new IsEmpty(this);
    private boolean isAdjusting;
    private final SimpleFormatter formatter = new SimpleFormatter();
    private final DateFormat shortDates;
    private final DateFormat longDates;
    private final ToggleButton messageButton;
    private final ToggleButton traceButton;
    private Predicate<LogRecord> filter;

    public LogViewer() {
        this(Vocabulary.getResources((Locale)null));
    }

    LogViewer(Vocabulary vocabulary) {
        this.shortDates = DateFormat.getDateTimeInstance(3, 3, vocabulary.getLocale());
        this.longDates = DateFormat.getDateTimeInstance(1, 1, vocabulary.getLocale());
        this.table = new TableView(FXCollections.emptyObservableList());
        this.table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.table.setTableMenuButtonVisible(true);
        this.table.getColumns().setAll((Object[])new TableColumn[]{this.column(vocabulary, (short)114), this.column(vocabulary, (short)243), this.column(vocabulary, (short)241), this.column(vocabulary, (short)240), this.column(vocabulary, (short)242), this.column(vocabulary, (short)239)});
        Font font = Font.font(null, (FontWeight)FontWeight.SEMI_BOLD, (double)-1.0);
        Label[] labelArray = new Label[5];
        this.level = new Label();
        labelArray[0] = LogViewer.label(font, vocabulary, (short)114, this.level);
        this.time = new Label();
        labelArray[1] = LogViewer.label(font, vocabulary, (short)243, this.time);
        this.logger = new Label();
        labelArray[2] = LogViewer.label(font, vocabulary, (short)241, this.logger);
        this.classe = new Label();
        labelArray[3] = LogViewer.label(font, vocabulary, (short)240, this.classe);
        this.method = new Label();
        labelArray[4] = LogViewer.label(font, vocabulary, (short)242, this.method);
        GridPane gridPane = Styles.createControlGrid(0, labelArray);
        this.messageButton = new ToggleButton(vocabulary.getString((short)239));
        this.traceButton = new ToggleButton(vocabulary.getString((short)245));
        this.messageButton.setSelected(true);
        this.messageButton.setMaxWidth(Double.MAX_VALUE);
        this.traceButton.setMaxWidth(Double.MAX_VALUE);
        ToggleGroup toggleGroup = new ToggleGroup();
        toggleGroup.getToggles().setAll((Object[])new Toggle[]{this.messageButton, this.traceButton});
        VBox vBox = new VBox(6.0, new Node[]{this.messageButton, this.traceButton});
        this.message = new TextArea();
        this.message.setEditable(false);
        GridPane.setConstraints((Node)vBox, (int)0, (int)5);
        GridPane.setConstraints((Node)this.message, (int)1, (int)5);
        GridPane.setMargin((Node)vBox, (Insets)MARGIN);
        GridPane.setMargin((Node)this.message, (Insets)MARGIN);
        gridPane.getChildren().addAll((Object[])new Node[]{vBox, this.message});
        gridPane.setVgap(0.0);
        vBox = new Label(vocabulary.getLabel((short)114));
        ChoiceBox choiceBox = new ChoiceBox();
        vBox.setLabelFor((Node)choiceBox);
        HBox hBox = new HBox(6.0, new Node[]{vBox, choiceBox});
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.setPadding(BAR_INSETS);
        font = new VBox(new Node[]{hBox, this.table});
        VBox.setVgrow(this.table, (Priority)Priority.ALWAYS);
        choiceBox.getItems().setAll((Object[])new Level[]{Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, PerformanceLevel.SLOW, Level.FINE, Level.FINER, Level.ALL});
        choiceBox.setConverter((StringConverter)Converter.INSTANCE);
        choiceBox.getSelectionModel().select((Object)Level.ALL);
        choiceBox.getSelectionModel().selectedItemProperty().addListener((observableValue, level, level2) -> this.setFilter((Level)level2));
        this.view = new SplitPane(new Node[]{font, new TitledPane(vocabulary.getString((short)62), (Node)gridPane)});
        this.view.setOrientation(Orientation.VERTICAL);
        SplitPane.setResizableWithParent((Node)gridPane, (Boolean)false);
        this.source.addListener((observableValue, resource, resource2) -> {
            if (!this.isAdjusting) {
                try {
                    this.isAdjusting = true;
                    this.systemLogs.set(false);
                    this.setItems(LogHandler.getRecords(resource2));
                }
                finally {
                    this.isAdjusting = false;
                }
            }
        });
        this.systemLogs.addListener((observableValue, bl, bl2) -> {
            if (!this.isAdjusting) {
                try {
                    this.isAdjusting = true;
                    this.source.set(null);
                    this.setItems((ObservableList<LogRecord>)(bl2 != false ? LogHandler.getSystemRecords() : null));
                }
                finally {
                    this.isAdjusting = false;
                }
            }
        });
        vBox = this.table.getSelectionModel().selectedItemProperty();
        toggleGroup.selectedToggleProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$new$3((ReadOnlyObjectProperty)vBox, arg_0, arg_1, arg_2));
        vBox.addListener((observableValue, logRecord, logRecord2) -> this.selected((LogRecord)logRecord2));
    }

    private TableColumn<LogRecord, String> column(Vocabulary vocabulary, short s) {
        TableColumn tableColumn = new TableColumn(vocabulary.getString(s));
        tableColumn.setCellValueFactory(cellDataFeatures -> this.toString((TableColumn.CellDataFeatures<LogRecord, String>)cellDataFeatures, s));
        tableColumn.setVisible(s == 239);
        return tableColumn;
    }

    private static Label label(Font font, Vocabulary vocabulary, short s, Label label) {
        Label label2 = new Label(vocabulary.getLabel(s));
        label2.setLabelFor((Node)label);
        label2.setFont(font);
        return label2;
    }

    private void setItems(ObservableList<LogRecord> observableList) {
        if (observableList == null) {
            this.table.setItems(FXCollections.emptyObservableList());
        } else {
            boolean bl = observableList.isEmpty();
            this.table.setItems((ObservableList)new FilteredList(observableList, this.filter));
            this.isEmpty.set(bl);
            if (bl) {
                observableList.addListener((ListChangeListener)this.isEmpty);
            }
        }
    }

    public final ReadOnlyBooleanProperty isEmptyProperty() {
        return this.isEmpty.getReadOnlyProperty();
    }

    private static String toString(Level level2) {
        if (level2 == null) {
            return null;
        }
        return LEVEL_NAMES.computeIfAbsent(level2, level -> {
            int n;
            if (Level.INFO.equals(level)) {
                n = 247;
            } else if (Level.CONFIG.equals(level)) {
                n = 246;
            } else {
                return CharSequences.upperCaseToSentence(level.getLocalizedName()).toString();
            }
            return Vocabulary.format((short)n);
        });
    }

    private ObservableValue<String> toString(TableColumn.CellDataFeatures<LogRecord, String> cellDataFeatures, short s) {
        LogRecord logRecord;
        if (cellDataFeatures != null && (logRecord = (LogRecord)cellDataFeatures.getValue()) != null) {
            String string;
            switch (s) {
                case 114: {
                    string = logRecord.getLevel().getLocalizedName();
                    break;
                }
                case 243: {
                    string = this.shortDates.format(new Date(logRecord.getMillis()));
                    break;
                }
                case 241: {
                    string = logRecord.getLoggerName();
                    break;
                }
                case 240: {
                    string = logRecord.getSourceClassName();
                    if (string == null) break;
                    string = string.substring(string.lastIndexOf(46) + 1);
                    break;
                }
                case 242: {
                    string = logRecord.getSourceMethodName();
                    break;
                }
                case 239: {
                    string = this.formatter.formatMessage(logRecord);
                    break;
                }
                default: {
                    throw new AssertionError(s);
                }
            }
            if (string != null) {
                return new ImmutableObjectProperty<String>(string);
            }
        }
        return null;
    }

    private void selected(LogRecord logRecord) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (logRecord != null) {
            string = LogViewer.toString(logRecord.getLevel());
            string2 = this.longDates.format(new Date(logRecord.getMillis()));
            string3 = logRecord.getLoggerName();
            string4 = logRecord.getSourceClassName();
            string5 = logRecord.getSourceMethodName();
            boolean bl = logRecord.getThrown() == null;
            this.traceButton.setDisable(bl);
            if (bl) {
                this.messageButton.setSelected(true);
            }
        }
        this.level.setText(string);
        this.time.setText(string2);
        this.logger.setText(string3);
        this.classe.setText(string4);
        this.method.setText(string5);
        this.setMessageOrTrace(logRecord);
    }

    private void setMessageOrTrace(LogRecord logRecord) {
        String string = null;
        if (logRecord != null) {
            if (this.messageButton.isSelected()) {
                this.message.setWrapText(true);
                string = this.formatter.formatMessage(logRecord);
            } else if (this.traceButton.isSelected()) {
                this.message.setWrapText(false);
                Throwable throwable = logRecord.getThrown();
                if (throwable != null) {
                    string = ExceptionReporter.getStackTrace(throwable);
                }
            }
        }
        this.message.setText(string);
    }

    private void setFilter(Level level) {
        if (level != null) {
            this.filter = Level.ALL.equals(level) ? null : logRecord -> logRecord != null && logRecord.getLevel().intValue() >= level.intValue();
            ObservableList observableList = this.table.getItems();
            if (observableList instanceof FilteredList) {
                ((FilteredList)observableList).setPredicate(this.filter);
            }
        }
    }

    @Override
    public Region getView() {
        return this.view;
    }

    private /* synthetic */ void lambda$new$3(ReadOnlyObjectProperty readOnlyObjectProperty, ObservableValue observableValue, Toggle toggle, Toggle toggle2) {
        this.setMessageOrTrace((LogRecord)readOnlyObjectProperty.get());
    }

    private static final class IsEmpty
    extends ReadOnlyBooleanWrapper
    implements ListChangeListener<LogRecord> {
        IsEmpty(LogViewer logViewer) {
            super((Object)logViewer, "isEmpty", true);
        }

        public void onChanged(ListChangeListener.Change<? extends LogRecord> change) {
            ObservableList observableList = change.getList();
            if (!observableList.isEmpty()) {
                observableList.removeListener((ListChangeListener)this);
            }
            this.set(false);
        }
    }

    private static final class Converter
    extends StringConverter<Level> {
        static final Converter INSTANCE = new Converter();

        private Converter() {
        }

        public String toString(Level level) {
            return LogViewer.toString(level);
        }

        public Level fromString(String string) {
            for (Map.Entry<Level, String> entry : LEVEL_NAMES.entrySet()) {
                if (!entry.getValue().equals(string)) continue;
                return entry.getKey();
            }
            return null;
        }
    }
}

