/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.TransformationList;
import javafx.event.EventHandler;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;
import javafx.util.Callback;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.gui.dataset.ExpandedFeature;
import org.apache.sis.gui.dataset.FeatureList;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.internal.util.UnmodifiableArrayList;

final class ExpandableList
extends TransformationList<AbstractFeature, AbstractFeature>
implements Callback<TableColumn<AbstractFeature, AbstractFeature>, TableCell<AbstractFeature, AbstractFeature>>,
EventHandler<MouseEvent> {
    private static final Background EXPANSION_HEADER = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Styles.EXPANDED_ROW, null, null)});
    private static final String EXPANDABLE = "\ud83d\uddc7";
    private static final String EXPANDED = "\ud83d\uddca";
    private final Map<String, Integer> nameToIndex = new LinkedHashMap<String, Integer>();
    private int indexOfExpanded = Integer.MAX_VALUE;
    private ExpandedFeature[] expansion;

    ExpandableList(FeatureList featureList) {
        super((ObservableList)featureList);
    }

    final void setMultivaluedColumns(List<String> list) {
        assert (this.expansion == null) : this.indexOfExpanded;
        this.nameToIndex.clear();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this.nameToIndex.putIfAbsent(list.get(i), i);
        }
    }

    private List<AbstractFeature> shrink() {
        UnmodifiableArrayList<AbstractFeature> unmodifiableArrayList = this.expansion == null ? null : UnmodifiableArrayList.wrap(this.expansion, 1, this.expansion.length);
        this.expansion = null;
        this.indexOfExpanded = Integer.MAX_VALUE;
        return unmodifiableArrayList;
    }

    public void clear() {
        int n = this.indexOfExpanded;
        List<AbstractFeature> list = this.shrink();
        if (list != null) {
            this.beginChange();
            this.nextUpdate(n);
            this.nextRemove(n + 1, list);
            this.endChange();
        }
        this.getSource().clear();
    }

    public void handle(MouseEvent mouseEvent) {
        IconCell iconCell = (IconCell)((Object)mouseEvent.getSource());
        int n = this.getSourceIndex(iconCell.getIndex());
        int n2 = this.indexOfExpanded;
        List<AbstractFeature> list = this.shrink();
        if (n != this.indexOfExpanded) {
            this.expansion = ExpandedFeature.create((AbstractFeature)iconCell.getItem(), this.nameToIndex);
            if (this.expansion != null) {
                this.indexOfExpanded = n;
                int n3 = Integer.MAX_VALUE - this.getSource().size();
                if (this.expansion.length > n3) {
                    if (n3 > 1) {
                        this.expansion = Arrays.copyOf(this.expansion, n3);
                    } else {
                        this.expansion = null;
                        this.indexOfExpanded = Integer.MAX_VALUE;
                    }
                }
            }
        }
        this.beginChange();
        if (list != null) {
            this.nextUpdate(n2);
            this.nextRemove(n2 + 1, list);
        }
        if (this.expansion != null) {
            this.nextAdd(this.indexOfExpanded + 1, Math.addExact(this.indexOfExpanded, this.expansion.length));
        }
        this.endChange();
    }

    private boolean isExpandable(AbstractFeature abstractFeature) {
        if (abstractFeature != null) {
            for (String string : this.nameToIndex.keySet()) {
                int n;
                Object object = abstractFeature.getPropertyValue(string);
                if (!(object instanceof Collection) || (n = ((Collection)object).size()) < 2) continue;
                return true;
            }
        }
        return false;
    }

    public int size() {
        int n = this.getSource().size();
        if (n != 0 && this.expansion != null) {
            n += this.expansion.length - 1;
        }
        return n;
    }

    public AbstractFeature get(int n) {
        int n2 = n - this.indexOfExpanded;
        if (n2 >= 0) {
            int n3 = this.expansion.length;
            if (n2 < n3) {
                return this.expansion[n2];
            }
            n -= n3;
        }
        return (AbstractFeature)this.getSource().get(n);
    }

    public int getSourceIndex(int n) {
        if (n > this.indexOfExpanded) {
            n = Math.max(this.indexOfExpanded, n - (this.expansion.length - 1));
        }
        return n;
    }

    public int getViewIndex(int n) {
        if (n > this.indexOfExpanded) {
            n += this.expansion.length - 1;
        }
        return n;
    }

    protected void sourceChanged(final ListChangeListener.Change<? extends AbstractFeature> change) {
        this.fireChange((ListChangeListener.Change)new ListChangeListener.Change<AbstractFeature>((ObservableList)this){

            public void reset() {
                change.reset();
            }

            public boolean next() {
                return change.next();
            }

            public boolean wasAdded() {
                return change.wasAdded();
            }

            public boolean wasRemoved() {
                return change.wasRemoved();
            }

            public boolean wasReplaced() {
                return change.wasReplaced();
            }

            public boolean wasUpdated() {
                return change.wasUpdated();
            }

            public boolean wasPermutated() {
                return change.wasPermutated();
            }

            protected int[] getPermutation() {
                return null;
            }

            public int getPermutation(int n) {
                return ExpandableList.this.getViewIndex(change.getPermutation(ExpandableList.this.getSourceIndex(n)));
            }

            public int getFrom() {
                return ExpandableList.this.getViewIndex(change.getFrom());
            }

            public int getTo() {
                return this.wasAdded() || !this.wasRemoved() ? ExpandableList.this.getViewIndex(change.getTo()) : this.getFrom();
            }

            public int getRemovedSize() {
                int n = change.getRemovedSize();
                if (ExpandableList.this.overlapExpanded(change.getFrom(), n)) {
                    n += ExpandableList.this.expansion.length - 1;
                }
                return n;
            }

            public List<AbstractFeature> getRemoved() {
                return ExpandableList.this.expandRemoved(change.getFrom(), change.getRemoved());
            }
        });
    }

    private boolean overlapExpanded(int n, int n2) {
        return n <= this.indexOfExpanded && n > this.indexOfExpanded - n2;
    }

    private List<? extends AbstractFeature> expandRemoved(int n, List<? extends AbstractFeature> list) {
        if (!this.overlapExpanded(n, list.size())) {
            return list;
        }
        int n2 = this.indexOfExpanded;
        int n3 = this.expansion.length;
        AbstractFeature[] abstractFeatureArray = list.toArray(new AbstractFeature[list.size() + (n3 - 1)]);
        System.arraycopy(abstractFeatureArray, n2 + 1, abstractFeatureArray, n2 + n3, abstractFeatureArray.length - (n2 + 1));
        System.arraycopy(this.expansion, 0, abstractFeatureArray, n2, n3);
        return Arrays.asList(abstractFeatureArray);
    }

    public TableCell<AbstractFeature, AbstractFeature> call(TableColumn<AbstractFeature, AbstractFeature> tableColumn) {
        return new IconCell();
    }

    private final class IconCell
    extends TableCell<AbstractFeature, AbstractFeature> {
        private boolean isListening;

        IconCell() {
            this.setTextAlignment(TextAlignment.CENTER);
        }

        protected void updateItem(AbstractFeature abstractFeature, boolean bl) {
            super.updateItem((Object)abstractFeature, bl);
            Background background = null;
            String string = null;
            if (abstractFeature instanceof ExpandedFeature) {
                if (((ExpandedFeature)abstractFeature).index == 0) {
                    string = ExpandableList.EXPANDED;
                } else {
                    background = EXPANSION_HEADER;
                }
            } else if (ExpandableList.this.isExpandable(abstractFeature)) {
                string = ExpandableList.EXPANDABLE;
            }
            this.setBackground(background);
            this.setText(string);
            this.isListening = string != null;
            if (this.isListening != this.isListening) {
                if (this.isListening) {
                    this.addEventFilter(MouseEvent.MOUSE_CLICKED, ExpandableList.this);
                } else {
                    this.removeEventFilter(MouseEvent.MOUSE_CLICKED, ExpandableList.this);
                }
            }
        }
    }
}

