/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Future;
import javax.measure.Quantity;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.PixelTranslation;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.geometry.Shapes2D;
import org.apache.sis.gui.coverage.CoverageCanvas;
import org.apache.sis.gui.coverage.IsolineRenderer;
import org.apache.sis.gui.coverage.Stretching;
import org.apache.sis.image.ErrorHandler;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.internal.coverage.j2d.ColorModelType;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.processing.image.Isolines;
import org.apache.sis.internal.referencing.WraparoundApplicator;
import org.apache.sis.io.TableAppender;
import org.apache.sis.math.Statistics;
import org.apache.sis.measure.Quantities;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class RenderingData
implements Cloneable {
    private static final boolean CREATE_INDEX_COLOR_MODEL = true;
    private RenderedImage data;
    private GridGeometry dataGeometry;
    private List<SampleDimension> dataRanges;
    private CoordinateOperation changeOfCRS;
    private MathTransform cornerToObjective;
    private MathTransform objectiveToCenter;
    private AffineTransform displayToObjective;
    Stretching selectedDerivative = Stretching.NONE;
    private Statistics[] statistics;
    final ImageProcessor processor = new ImageProcessor();

    RenderingData(ErrorHandler errorHandler) {
        this.processor.setErrorHandler(errorHandler);
        this.processor.setImageResizingPolicy(ImageProcessor.Resizing.EXPAND);
    }

    final boolean isEmpty() {
        return this.data == null;
    }

    final boolean validateCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (this.changeOfCRS != null && !Utilities.equalsIgnoreMetadata(coordinateReferenceSystem, this.changeOfCRS.getTargetCRS())) {
            this.clearCRS();
            return false;
        }
        return true;
    }

    private void clearCRS() {
        this.changeOfCRS = null;
        this.cornerToObjective = null;
        this.objectiveToCenter = null;
    }

    final void setImage(RenderedImage renderedImage, GridGeometry gridGeometry, List<SampleDimension> list) {
        this.clearCRS();
        this.displayToObjective = null;
        this.statistics = null;
        this.data = renderedImage;
        this.dataGeometry = gridGeometry;
        this.dataRanges = list;
    }

    private DirectPosition getSourceMedian() {
        if (this.dataGeometry.isDefined(2)) {
            return AbstractEnvelope.castOrCopy((Envelope)this.dataGeometry.getEnvelope()).getMedian();
        }
        return null;
    }

    final RenderedImage recolor() {
        RenderedImage renderedImage = this.data;
        if (this.selectedDerivative != Stretching.NONE) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
            if (this.statistics == null) {
                this.statistics = this.processor.valueOfStatistics(renderedImage, null);
            }
            hashMap.put("statistics", this.statistics);
            if (this.selectedDerivative == Stretching.AUTOMATIC) {
                hashMap.put("multStdDev", 3);
            }
            hashMap.put("sampleDimensions", this.dataRanges);
            renderedImage = this.processor.stretchColorRamp(renderedImage, hashMap);
        }
        return renderedImage;
    }

    final RenderedImage resampleAndConvert(RenderedImage renderedImage, CoordinateReferenceSystem coordinateReferenceSystem, LinearTransform linearTransform, DirectPosition directPosition) throws TransformException {
        MathTransform mathTransform;
        Object object;
        MathTransform mathTransform2;
        MathTransform mathTransform3;
        DefaultGeographicBoundingBox defaultGeographicBoundingBox;
        if (this.changeOfCRS == null && coordinateReferenceSystem != null && this.dataGeometry.isDefined(1)) {
            defaultGeographicBoundingBox = null;
            if (this.dataGeometry.isDefined(2)) {
                try {
                    defaultGeographicBoundingBox = new DefaultGeographicBoundingBox();
                    defaultGeographicBoundingBox.setBounds(this.dataGeometry.getEnvelope());
                }
                catch (TransformException transformException) {
                    RenderingData.recoverableException((Exception)((Object)transformException));
                }
            }
            try {
                this.changeOfCRS = CRS.findOperation((CoordinateReferenceSystem)this.dataGeometry.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)coordinateReferenceSystem, (GeographicBoundingBox)defaultGeographicBoundingBox);
                double d = CRS.getLinearAccuracy((CoordinateOperation)this.changeOfCRS);
                this.processor.setPositionalAccuracyHints(new Quantity[]{d > 0.0 ? Quantities.create(d, Units.METRE) : null});
            }
            catch (FactoryException factoryException) {
                RenderingData.recoverableException((Exception)((Object)factoryException));
            }
        }
        defaultGeographicBoundingBox = null;
        if (this.cornerToObjective == null || this.objectiveToCenter == null) {
            this.cornerToObjective = this.dataGeometry.getGridToCRS(PixelInCell.CELL_CORNER);
            this.objectiveToCenter = this.dataGeometry.getGridToCRS(PixelInCell.CELL_CENTER).inverse();
            if (this.changeOfCRS != null) {
                DirectPosition directPosition2 = this.getSourceMedian();
                mathTransform3 = this.changeOfCRS.getMathTransform();
                object = mathTransform2 = mathTransform3.inverse();
                try {
                    mathTransform3 = RenderingData.applyWraparound(mathTransform3, directPosition2, directPosition, this.changeOfCRS.getTargetCRS());
                    mathTransform2 = RenderingData.applyWraparound(mathTransform2, directPosition, directPosition2, this.changeOfCRS.getSourceCRS());
                }
                catch (TransformException transformException) {
                    RenderingData.recoverableException((Exception)((Object)transformException));
                }
                if (mathTransform2 != object) {
                    defaultGeographicBoundingBox = MathTransforms.concatenate((MathTransform)object, (MathTransform)this.objectiveToCenter);
                }
                this.cornerToObjective = MathTransforms.concatenate((MathTransform)this.cornerToObjective, (MathTransform)mathTransform3);
                this.objectiveToCenter = MathTransforms.concatenate((MathTransform)mathTransform2, (MathTransform)this.objectiveToCenter);
            }
        }
        LinearTransform linearTransform2 = linearTransform.inverse();
        this.displayToObjective = AffineTransforms2D.castOrCopy((MathTransform)linearTransform2);
        mathTransform3 = MathTransforms.concatenate((MathTransform)this.cornerToObjective, (MathTransform)linearTransform);
        mathTransform2 = MathTransforms.concatenate((MathTransform)linearTransform2, (MathTransform)this.objectiveToCenter);
        object = (Rectangle)Shapes2D.transform((MathTransform2D)MathTransforms.bidimensional((MathTransform)mathTransform3), (Rectangle2D)ImageUtilities.getBounds((RenderedImage)renderedImage), (Rectangle2D)new Rectangle());
        if (defaultGeographicBoundingBox != null && !RenderingData.isWraparoundNeeded((Rectangle)object, mathTransform2, mathTransform = MathTransforms.concatenate((MathTransform)linearTransform2, (MathTransform)defaultGeographicBoundingBox))) {
            this.objectiveToCenter = defaultGeographicBoundingBox;
            mathTransform2 = mathTransform;
        }
        mathTransform = ColorModelType.find((ColorModel)renderedImage.getColorModel());
        if (mathTransform.isSlow || this.processor.getCategoryColors() != null && mathTransform.useColorRamp) {
            return this.processor.visualize(renderedImage, (Rectangle)object, mathTransform2, this.dataRanges);
        }
        return this.processor.resample(renderedImage, (Rectangle)object, mathTransform2);
    }

    private static MathTransform applyWraparound(MathTransform mathTransform, DirectPosition directPosition, DirectPosition directPosition2, CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException {
        if (directPosition2 == null) {
            return mathTransform;
        }
        return new WraparoundApplicator(directPosition, directPosition2, coordinateReferenceSystem.getCoordinateSystem()).forDomainOfUse(mathTransform);
    }

    private static boolean isWraparoundNeeded(Rectangle rectangle, MathTransform mathTransform, MathTransform mathTransform2) throws TransformException {
        double d;
        int n;
        int n2 = mathTransform2.getSourceDimensions();
        int n3 = mathTransform2.getTargetDimensions();
        double[] dArray = new double[n2 * 9];
        double[] dArray2 = new double[n3 * 9];
        for (n = 0; n < 9; ++n) {
            double d2;
            switch (n % 3) {
                case 0: {
                    d = rectangle.getMinX();
                    break;
                }
                case 1: {
                    d = rectangle.getMaxX();
                    break;
                }
                default: {
                    d = rectangle.getCenterX();
                }
            }
            switch (n / 3) {
                case 0: {
                    d2 = rectangle.getMinY();
                    break;
                }
                case 1: {
                    d2 = rectangle.getMaxY();
                    break;
                }
                default: {
                    d2 = rectangle.getCenterY();
                }
            }
            int n4 = n * n2;
            dArray[n4] = d;
            dArray[n4 + 1] = d2;
        }
        mathTransform2.transform(dArray, 0, dArray2, 0, 9);
        mathTransform.transform(dArray, 0, dArray, 0, 9);
        for (n = 0; n < dArray2.length; ++n) {
            d = dArray[n];
            if (Math.abs(dArray2[n] - d) < 1.0 || !Double.isFinite(d)) continue;
            return true;
        }
        return false;
    }

    final RenderedImage prefetch(RenderedImage renderedImage, AffineTransform affineTransform, Envelope2D envelope2D) {
        Rectangle rectangle;
        try {
            rectangle = (Rectangle)AffineTransforms2D.transform((AffineTransform)affineTransform.createInverse(), (Rectangle2D)envelope2D, (Rectangle2D)new Rectangle());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            RenderingData.recoverableException(noninvertibleTransformException);
            return renderedImage;
        }
        return this.processor.prefetch(renderedImage, rectangle);
    }

    final AffineTransform getTransform(LinearTransform linearTransform) {
        if (this.displayToObjective == null) {
            return new AffineTransform();
        }
        AffineTransform affineTransform = AffineTransforms2D.castOrCopy((MathTransform)linearTransform);
        if (affineTransform == linearTransform) {
            affineTransform = new AffineTransform(affineTransform);
        }
        affineTransform.concatenate(this.displayToObjective);
        ImageUtilities.roundIfAlmostInteger((AffineTransform)affineTransform);
        return affineTransform;
    }

    final float getDataPixelSize(DirectPosition directPosition) {
        if (this.objectiveToCenter != null) {
            try {
                Matrix matrix = this.objectiveToCenter.derivative(directPosition);
                double d = 0.0;
                int n = matrix.getNumRow();
                while (--n >= 0) {
                    int n2 = matrix.getNumCol();
                    while (--n2 >= 0) {
                        double d2 = matrix.getElement(n, n2);
                        d += d2 * d2;
                    }
                }
                float f = (float)(1.0 / Math.sqrt(d));
                if (f > 0.0f && f != Float.POSITIVE_INFINITY) {
                    return f;
                }
            }
            catch (TransformException transformException) {
                RenderingData.recoverableException((Exception)((Object)transformException));
            }
        }
        return 0.0f;
    }

    final Rectangle objectiveToData(Rectangle2D rectangle2D) throws TransformException {
        if (this.objectiveToCenter == null) {
            return null;
        }
        return (Rectangle)Shapes2D.transform((MathTransform2D)MathTransforms.bidimensional((MathTransform)this.objectiveToCenter), (Rectangle2D)rectangle2D, (Rectangle2D)new Rectangle());
    }

    final boolean hasChanged(RenderingData renderingData) {
        return renderingData.dataGeometry != this.dataGeometry || renderingData.objectiveToCenter != this.objectiveToCenter;
    }

    private static void recoverableException(Exception exception) {
        Logging.recoverableException(Logging.getLogger("org.apache.sis.gui"), CoverageCanvas.class, "render", exception);
    }

    final Future<Isolines[]> generate(IsolineRenderer.Snapshot[] snapshotArray) throws TransformException {
        if (snapshotArray == null) {
            return null;
        }
        MathTransform mathTransform = PixelTranslation.translate((MathTransform)this.cornerToObjective, (PixelInCell)PixelInCell.CELL_CORNER, (PixelInCell)PixelInCell.CELL_CENTER);
        return IsolineRenderer.generate(snapshotArray, this.data, mathTransform);
    }

    public RenderingData clone() {
        try {
            return (RenderingData)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public String toString() {
        String string = System.lineSeparator();
        StringBuilder stringBuilder = new StringBuilder(6000);
        TableAppender tableAppender = new TableAppender(stringBuilder);
        tableAppender.setMultiLinesCells(true);
        try {
            tableAppender.nextLine('\u2550');
            tableAppender.append("Geometry of source coverage:").append(string).append(String.valueOf(this.dataGeometry)).appendHorizontalSeparator();
            tableAppender.append("Pixel corners to objective CRS:").append(string).append(String.valueOf(this.cornerToObjective)).appendHorizontalSeparator();
            tableAppender.append("Median in data CRS:").append(string).append(String.valueOf(this.getSourceMedian())).nextLine();
            tableAppender.nextLine('\u2550');
            tableAppender.flush();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return stringBuilder.toString();
    }
}

