/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.function.Predicate;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.Background;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import org.apache.sis.gui.Widget;
import org.apache.sis.image.PlanarImage;
import org.apache.sis.image.ResampledImage;
import org.apache.sis.internal.gui.ImmutableObjectProperty;
import org.apache.sis.internal.gui.PropertyView;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.internal.util.PropertyFormat;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Vocabulary;

public class ImagePropertyExplorer
extends Widget {
    public final ObjectProperty<RenderedImage> image;
    private Rectangle visibleImageBounds;
    private final Map<RenderedImage, Boolean> imageUseBoundsCS;
    public final BooleanProperty updateOnChange;
    private boolean listening;
    private final TreeItem<RenderedImage> sourcesRoot;
    private final ReadOnlyObjectProperty<TreeItem<RenderedImage>> selectedImage;
    private final ObservableList<LayoutRow> layoutRows;
    private final ObjectProperty<Predicate<? super LayoutRow>> layoutFilter;
    private final ObservableList<PropertyRow> propertyRows;
    private final ReadOnlyObjectProperty<PropertyRow> selectedProperty;
    private final Tab detailsTab;
    private final PropertyView propertyDetails;
    private final TabPane view;

    public ImagePropertyExplorer() {
        this(null, null);
    }

    ImagePropertyExplorer(Locale locale, ObjectProperty<Background> objectProperty) {
        Vocabulary vocabulary = Vocabulary.getResources(locale);
        Resources resources = Resources.forLocale(locale);
        this.image = new ImageProperty();
        this.imageUseBoundsCS = new IdentityHashMap<RenderedImage, Boolean>(4);
        this.updateOnChange = new SimpleBooleanProperty((Object)this, "updateOnChange", true);
        this.listening = true;
        this.sourcesRoot = new TreeItem();
        TreeView treeView = new TreeView(this.sourcesRoot);
        this.selectedImage = treeView.getSelectionModel().selectedItemProperty();
        treeView.setCellFactory(SourceCell::new);
        this.selectedImage.addListener((observableValue, treeItem, treeItem2) -> {
            RenderedImage renderedImage = null;
            if (treeItem2 != null) {
                renderedImage = (RenderedImage)treeItem2.getValue();
            }
            this.imageSelected(renderedImage != null ? renderedImage : (RenderedImage)this.image.get());
        });
        this.layoutRows = FXCollections.observableArrayList((Object[])LayoutRow.values(vocabulary, resources));
        FilteredList filteredList = new FilteredList(this.layoutRows);
        TableView tableView = new TableView((ObservableList)filteredList);
        this.layoutFilter = filteredList.predicateProperty();
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        tableView.setSelectionModel(null);
        TableColumn tableColumn2 = new TableColumn(resources.getString((short)40));
        TableColumn tableColumn3 = new TableColumn(resources.getString((short)35, "X"));
        TableColumn tableColumn4 = new TableColumn(resources.getString((short)35, "Y"));
        Callback callback = tableColumn -> new LayoutCell(numberFormat);
        tableColumn3.setCellFactory(callback);
        tableColumn4.setCellFactory(callback);
        tableColumn3.setCellValueFactory(cellDataFeatures -> ((LayoutRow)((Object)((Object)cellDataFeatures.getValue()))).xp);
        tableColumn4.setCellValueFactory(cellDataFeatures -> ((LayoutRow)((Object)((Object)cellDataFeatures.getValue()))).yp);
        tableColumn2.setCellValueFactory(cellDataFeatures -> (ObservableValue)cellDataFeatures.getValue());
        tableView.getColumns().setAll((Object[])new TableColumn[]{tableColumn2, tableColumn3, tableColumn4});
        tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        tableView.getColumns().forEach(tableColumn -> {
            tableColumn.setReorderable(false);
            tableColumn.setSortable(false);
        });
        TableView tableView2 = new TableView();
        this.propertyRows = tableView2.getItems();
        this.selectedProperty = tableView2.getSelectionModel().selectedItemProperty();
        filteredList = new TableColumn(vocabulary.getString((short)238));
        tableColumn2 = new TableColumn(vocabulary.getString((short)213));
        filteredList.setCellValueFactory(cellDataFeatures -> (ObservableValue)cellDataFeatures.getValue());
        tableColumn2.setCellValueFactory(cellDataFeatures -> ((PropertyRow)((Object)((Object)cellDataFeatures.getValue()))).value);
        tableColumn2.setCellFactory(tableColumn -> new PropertyCell(locale));
        tableView2.getColumns().setAll((Object[])new TableColumn[]{filteredList, tableColumn2});
        tableView2.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        tableView2.getColumns().forEach(tableColumn -> tableColumn.setReorderable(false));
        this.detailsTab = new Tab(vocabulary.getString((short)62));
        this.selectedProperty.addListener((observableValue, propertyRow, propertyRow2) -> this.clearPropertyValues(false));
        this.propertyDetails = new PropertyView(locale, (ObjectProperty<Node>)this.detailsTab.contentProperty(), objectProperty);
        this.detailsTab.selectedProperty().addListener((observableValue, bl, bl2) -> {
            if (bl2.booleanValue()) {
                this.updatePropertyDetails(this.getVisibleImageBounds(this.getSelectedImage()));
            }
        });
        this.view = new TabPane(new Tab[]{new Tab(vocabulary.getString((short)182), (Node)treeView), new Tab(vocabulary.getString((short)235), (Node)tableView), new Tab(vocabulary.getString((short)237), (Node)tableView2), this.detailsTab});
        this.view.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.updateOnChange.addListener((observableValue, bl, bl2) -> {
            if (bl2.booleanValue()) {
                this.startListening();
            }
        });
    }

    private void startListening() {
        this.listening = true;
        if (this.sourcesRoot.getValue() == null) {
            this.setTreeRoot((RenderedImage)this.image.get());
            this.refreshTables();
        }
    }

    final void setImage(RenderedImage renderedImage, Rectangle rectangle) {
        this.visibleImageBounds = rectangle;
        ((ImageProperty)this.image).assign(renderedImage);
        if (this.listening) {
            boolean bl = this.updateOnChange.get();
            this.setTreeRoot(bl ? renderedImage : null);
            if (bl) {
                this.refreshTables();
            } else {
                this.clearPropertyValues(true);
                this.listening = false;
            }
        }
    }

    private RenderedImage getSelectedImage() {
        RenderedImage renderedImage;
        TreeItem treeItem = (TreeItem)this.selectedImage.get();
        if (treeItem != null && (renderedImage = (RenderedImage)treeItem.getValue()) != null) {
            return renderedImage;
        }
        return (RenderedImage)this.image.get();
    }

    private void refreshTables() {
        this.imageSelected(this.getSelectedImage());
    }

    private void imageSelected(RenderedImage renderedImage) {
        Rectangle rectangle = this.getVisibleImageBounds(renderedImage);
        int n = this.layoutRows.size();
        for (int i = 0; i < n; ++i) {
            ((LayoutRow)((Object)this.layoutRows.get(i))).update(renderedImage, rectangle, i);
        }
        this.layoutFilter.set(rectangle != null ? null : LayoutRow.EXCLUDE_VISIBILITY);
        this.updatePropertyList(renderedImage);
        if (this.detailsTab.isSelected()) {
            this.updatePropertyDetails(rectangle);
        }
    }

    final Rectangle getVisibleImageBounds(RenderedImage renderedImage) {
        return Boolean.TRUE.equals(this.imageUseBoundsCS.get(renderedImage)) ? this.visibleImageBounds : null;
    }

    private void setTreeRoot(RenderedImage renderedImage) {
        this.imageUseBoundsCS.clear();
        ImagePropertyExplorer.setTreeNode(this.sourcesRoot, renderedImage, this.imageUseBoundsCS, this.visibleImageBounds != null);
        this.imageUseBoundsCS.values().removeIf(bl -> bl == false);
    }

    private static void setTreeNode(TreeItem<RenderedImage> treeItem, RenderedImage renderedImage, Map<RenderedImage, Boolean> map, Boolean bl) {
        treeItem.setValue((Object)renderedImage);
        if (map.putIfAbsent(renderedImage, bl) == null) {
            Vector<RenderedImage> vector;
            ObservableList observableList = treeItem.getChildren();
            if (renderedImage != null && (vector = renderedImage.getSources()) != null) {
                int n;
                if (renderedImage instanceof ResampledImage) {
                    bl = Boolean.FALSE;
                }
                int n2 = vector.size();
                int n3 = observableList.size();
                int n4 = Math.min(n2, n3);
                for (n = 0; n < n4; ++n) {
                    ImagePropertyExplorer.setTreeNode((TreeItem<RenderedImage>)((TreeItem)observableList.get(n)), (RenderedImage)vector.get(n), map, bl);
                }
                while (n < n2) {
                    TreeItem treeItem2 = new TreeItem();
                    ImagePropertyExplorer.setTreeNode((TreeItem<RenderedImage>)treeItem2, (RenderedImage)vector.get(n), map, bl);
                    observableList.add((Object)treeItem2);
                    ++n;
                }
                if (n < n3) {
                    observableList.remove(n, n3);
                }
                return;
            }
            observableList.clear();
        }
    }

    private static String getClassName(Class<?> clazz) {
        while (clazz.getEnclosingClass() != null) {
            clazz = clazz.getSuperclass();
        }
        return clazz.getSimpleName();
    }

    private void updatePropertyList(RenderedImage renderedImage) {
        String[] stringArray;
        if (renderedImage != null && (stringArray = renderedImage.getPropertyNames()) != null) {
            int n = 0;
            block0: for (String string : stringArray) {
                if (string == null) continue;
                for (int i = n; i < this.propertyRows.size(); ++i) {
                    if (!((PropertyRow)((Object)this.propertyRows.get(i))).update(renderedImage, string)) continue;
                    this.propertyRows.remove(n, i);
                    n = i + 1;
                    continue block0;
                }
                this.propertyRows.add(n++, (Object)new PropertyRow(renderedImage, string));
            }
            this.propertyRows.remove(n, this.propertyRows.size());
            return;
        }
        this.propertyRows.clear();
    }

    private void updatePropertyDetails(Rectangle rectangle) {
        PropertyRow propertyRow = (PropertyRow)((Object)this.selectedProperty.get());
        this.propertyDetails.set(propertyRow != null ? propertyRow.value.get() : null, rectangle);
    }

    private void clearPropertyValues(boolean bl) {
        if (this.propertyDetails != null) {
            this.propertyDetails.clear();
            this.detailsTab.setContent(null);
        }
        if (bl) {
            this.propertyRows.clear();
        }
    }

    @Override
    public Region getView() {
        return this.view;
    }

    private final class ImageProperty
    extends ObjectPropertyBase<RenderedImage> {
        private ImageProperty() {
        }

        public Object getBean() {
            return ImagePropertyExplorer.this;
        }

        public String getName() {
            return "image";
        }

        public void set(RenderedImage renderedImage) {
            ImagePropertyExplorer.this.setImage(renderedImage, null);
        }

        void assign(RenderedImage renderedImage) {
            super.set((Object)renderedImage);
        }
    }

    private static final class LayoutRow
    extends ImmutableObjectProperty<String> {
        static final int IMAGE_SIZE = 0;
        static final int DISPLAYED_SIZE = 1;
        static final int TILE_SIZE = 2;
        static final int NUM_TILES = 3;
        static final int MIN_PIXEL = 4;
        static final int MIN_VISIBLE = 5;
        static final int MIN_TILE = 6;
        final IntegerProperty xp;
        final IntegerProperty yp;
        private final boolean core;
        static Predicate<LayoutRow> EXCLUDE_VISIBILITY = layoutRow -> layoutRow.core;

        static LayoutRow[] values(Vocabulary vocabulary, Resources resources) {
            LayoutRow[] layoutRowArray = new LayoutRow[]{new LayoutRow(true, vocabulary.getString((short)234)), new LayoutRow(false, resources.getString((short)41)), new LayoutRow(true, vocabulary.getString((short)194)), new LayoutRow(true, vocabulary.getString((short)236)), new LayoutRow(true, resources.getString((short)36)), new LayoutRow(false, resources.getString((short)38)), new LayoutRow(true, resources.getString((short)37))};
            return layoutRowArray;
        }

        private LayoutRow(boolean bl, String string) {
            super(string);
            this.core = bl;
            this.xp = new SimpleIntegerProperty();
            this.yp = new SimpleIntegerProperty();
        }

        final void update(RenderedImage renderedImage, Rectangle rectangle, int n) {
            int n2 = 0;
            int n3 = 0;
            if (renderedImage != null) {
                switch (n) {
                    case 0: {
                        n2 = renderedImage.getWidth();
                        n3 = renderedImage.getHeight();
                        break;
                    }
                    case 2: {
                        n2 = renderedImage.getTileWidth();
                        n3 = renderedImage.getTileHeight();
                        break;
                    }
                    case 3: {
                        n2 = renderedImage.getNumXTiles();
                        n3 = renderedImage.getNumYTiles();
                        break;
                    }
                    case 6: {
                        n2 = renderedImage.getMinTileX();
                        n3 = renderedImage.getMinTileY();
                        break;
                    }
                    case 4: {
                        n2 = renderedImage.getMinX();
                        n3 = renderedImage.getMinY();
                        break;
                    }
                    case 5: {
                        if (rectangle == null) break;
                        n2 = rectangle.x;
                        n3 = rectangle.y;
                        break;
                    }
                    case 1: {
                        if (rectangle == null) break;
                        n2 = rectangle.width;
                        n3 = rectangle.height;
                    }
                }
            }
            this.xp.set(n2);
            this.yp.set(n3);
        }
    }

    private static final class PropertyRow
    extends ImmutableObjectProperty<String> {
        final ObjectProperty<Object> value;

        PropertyRow(RenderedImage renderedImage, String string) {
            super(string);
            this.value = new SimpleObjectProperty(PropertyRow.getProperty(renderedImage, string));
        }

        final boolean update(RenderedImage renderedImage, String string) {
            if (string.equals(super.get())) {
                this.value.set(PropertyRow.getProperty(renderedImage, string));
                return true;
            }
            return false;
        }

        private static Object getProperty(RenderedImage renderedImage, String string) {
            try {
                return renderedImage.getProperty(string);
            }
            catch (RuntimeException runtimeException) {
                return runtimeException;
            }
        }

        @Override
        public String get() {
            String string = (String)super.get();
            return CharSequences.camelCaseToSentence(string.substring(string.lastIndexOf(46) + 1)).toString();
        }
    }

    private static final class PropertyCell
    extends TableCell<PropertyRow, Object> {
        private final ValueFormat format;
        private final StringBuilder buffer = new StringBuilder();

        PropertyCell(Locale locale) {
            this.format = new ValueFormat(locale, this.buffer);
        }

        protected void updateItem(Object object, boolean bl) {
            super.updateItem(object, bl);
            String string = null;
            if (!bl) {
                try {
                    this.buffer.setLength(0);
                    this.format.appendValue(object);
                    this.format.flush();
                    string = this.buffer.toString();
                }
                catch (IOException iOException) {
                    string = iOException.toString();
                }
            }
            this.setText(string);
        }

        private static final class ValueFormat
        extends PropertyFormat {
            private final Locale locale;

            ValueFormat(Locale locale, StringBuilder stringBuilder) {
                super(stringBuilder);
                this.locale = locale;
            }

            @Override
            public Locale getLocale() {
                return this.locale;
            }

            @Override
            protected String toString(Object object) {
                if (object instanceof Number || object instanceof Date) {
                    return object.toString();
                }
                return ImagePropertyExplorer.getClassName(object.getClass()) + "[\u2026]";
            }
        }
    }

    private static final class LayoutCell
    extends TableCell<LayoutRow, Number> {
        private final NumberFormat integerFormat;

        LayoutCell(NumberFormat numberFormat) {
            this.integerFormat = numberFormat;
            this.setAlignment(Pos.CENTER_RIGHT);
        }

        protected void updateItem(Number number, boolean bl) {
            super.updateItem((Object)number, bl);
            this.setText(number != null ? this.integerFormat.format(number) : null);
        }
    }

    private static final class SourceCell
    extends TreeCell<RenderedImage> {
        SourceCell(TreeView<RenderedImage> treeView) {
        }

        protected void updateItem(RenderedImage renderedImage, boolean bl) {
            super.updateItem((Object)renderedImage, bl);
            String string = null;
            Color color = Styles.NORMAL_TEXT;
            if (renderedImage != null) {
                String string2;
                string = ImagePropertyExplorer.getClassName(renderedImage.getClass());
                if (renderedImage instanceof PlanarImage && (string2 = ((PlanarImage)renderedImage).verify()) != null) {
                    string = Resources.format((short)39, string, string2);
                    color = Styles.ERROR_TEXT;
                }
            }
            this.setText(string);
            this.setTextFill((Paint)color);
        }
    }
}

