/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.skin.VirtualContainerBase;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import org.apache.sis.gui.coverage.GridCell;
import org.apache.sis.gui.coverage.GridError;
import org.apache.sis.gui.coverage.GridRow;
import org.apache.sis.gui.coverage.GridView;
import org.apache.sis.internal.gui.Styles;

final class GridViewSkin
extends VirtualContainerBase<GridView, GridRow>
implements EventHandler<MouseEvent> {
    private final HBox headerRow = new HBox();
    private final Rectangle topBackground;
    private final Rectangle leftBackground;
    int firstVisibleColumn;
    double leftPosition;
    double rightPosition;
    double headerWidth;
    double cellWidth;
    double cellInnerWidth;
    private boolean layoutAll;
    private boolean hasErrors;
    private final Rectangle selection;
    private final Rectangle selectedRow;
    private final Rectangle selectedColumn;

    GridViewSkin(GridView gridView) {
        super((Control)gridView);
        VirtualFlow virtualFlow = this.getVirtualFlow();
        virtualFlow.setCellFactory(GridRow::new);
        virtualFlow.setFocusTraversable(true);
        virtualFlow.setFixedCellSize(GridView.getSizeValue(gridView.cellHeight));
        gridView.cellHeight.addListener((observableValue, number, number2) -> this.cellHeightChanged((Number)number2));
        gridView.cellWidth.addListener((observableValue, number, number2) -> this.cellWidthChanged((Number)number2, true));
        gridView.headerWidth.addListener((observableValue, number, number2) -> this.cellWidthChanged((Number)number2, false));
        this.topBackground = new Rectangle();
        this.leftBackground = new Rectangle();
        this.leftBackground.fillProperty().bind(gridView.headerBackground);
        this.topBackground.fillProperty().bind(gridView.headerBackground);
        this.selection = new Rectangle();
        this.selectedRow = new Rectangle();
        this.selectedColumn = new Rectangle();
        this.selection.setFill((Paint)Styles.SELECTION_BACKGROUND);
        this.selectedRow.setFill((Paint)Color.SILVER);
        this.selectedColumn.setFill((Paint)Color.SILVER);
        this.selection.setVisible(false);
        this.selectedRow.setVisible(false);
        this.selectedColumn.setVisible(false);
        this.selection.setManaged(false);
        this.selectedRow.setManaged(false);
        this.selectedColumn.setManaged(false);
        virtualFlow.setOnMouseEntered((EventHandler)gridView.statusBar);
        virtualFlow.setOnMouseExited(mouseEvent -> this.hideSelection());
        Region region = gridView.statusBar.getView();
        region.setManaged(false);
        this.getChildren().addAll((Object[])new Node[]{this.topBackground, this.leftBackground, this.selectedColumn, this.selectedRow, this.headerRow, this.selection, region, virtualFlow});
    }

    public final void handle(MouseEvent mouseEvent) {
        boolean bl;
        double d = mouseEvent.getX() - (this.leftPosition + this.headerWidth);
        boolean bl2 = bl = d >= 0.0;
        if (bl) {
            double d2 = Math.floor(d / this.cellWidth);
            boolean bl3 = bl = d2 >= 0.0;
            if (bl) {
                GridRow gridRow = (GridRow)((Object)mouseEvent.getSource());
                double d3 = gridRow.getLayoutY();
                boolean bl4 = bl = d3 < this.getVirtualFlow().getHeight();
                if (bl) {
                    d = d2 * this.cellWidth + this.leftBackground.getWidth() + gridRow.getLayoutX();
                    this.selection.setX(d);
                    this.selection.setY(d3 += this.topBackground.getHeight());
                    this.selectedRow.setY(d3);
                    this.selectedColumn.setX(d);
                    ((GridView)this.getSkinnable()).formatCoordinates(this.firstVisibleColumn + (int)d2, gridRow.getIndex());
                }
            }
        }
        this.selection.setVisible(bl);
        this.selectedRow.setVisible(bl);
        this.selectedColumn.setVisible(bl);
        if (!bl) {
            ((GridView)this.getSkinnable()).statusBar.handle((MouseEvent)null);
        }
    }

    private void hideSelection() {
        this.selection.setVisible(false);
        this.selectedRow.setVisible(false);
        this.selectedColumn.setVisible(false);
        ((GridView)this.getSkinnable()).statusBar.handle((MouseEvent)null);
    }

    private void cellHeightChanged(Number number) {
        Flow flow = (Flow)this.getVirtualFlow();
        double d = number.doubleValue();
        if (!(d >= 1.0)) {
            d = 1.0;
        }
        flow.setFixedCellSize(d);
        this.selection.setVisible(false);
        this.selection.setHeight(d);
        this.contentChanged(false);
    }

    private void cellWidthChanged(Number number, boolean bl) {
        GridView gridView = (GridView)this.getSkinnable();
        double d = gridView.getContentWidth();
        for (Node node : this.getChildren()) {
            if (!(node instanceof GridRow)) continue;
            ((GridRow)node).setPrefWidth(d);
        }
        if (bl) {
            this.selection.setVisible(false);
            this.selection.setWidth(number.doubleValue());
        }
        this.layoutAll = true;
        this.contentChanged(false);
    }

    final void errorOccurred(GridError gridError) {
        this.hasErrors = true;
        this.getChildren().add((Object)gridError);
    }

    final void removeError(GridError gridError) {
        ObservableList observableList = this.getChildren();
        observableList.remove((Object)gridError);
        this.hasErrors = observableList.get(observableList.size() - 1) instanceof GridError;
        this.contentChanged(false);
    }

    final void contentChanged(boolean bl) {
        if (bl) {
            this.updateItemCount();
            this.getChildren().removeIf(node -> node instanceof GridError);
            this.layoutAll = true;
            this.hasErrors = false;
        }
        ((Flow)this.getVirtualFlow()).changed(null, null, null);
    }

    protected VirtualFlow<GridRow> createVirtualFlow() {
        return new Flow((GridView)this.getSkinnable());
    }

    protected void updateItemCount() {
        this.getVirtualFlow().setCellCount(this.getItemCount());
    }

    public int getItemCount() {
        return ((GridView)this.getSkinnable()).getImageHeight();
    }

    protected void layoutChildren(double d, double d2, double d3, double d4) {
        GridRow gridRow;
        super.layoutChildren(d, d2, d3, d4);
        GridView gridView = (GridView)this.getSkinnable();
        double d5 = Math.min(gridView.cellSpacing.get(), this.cellWidth);
        if (!(d5 >= 0.0)) {
            d5 = 0.0;
        }
        Flow flow = (Flow)this.getVirtualFlow();
        double d6 = flow.getFixedCellSize();
        double d7 = d6 + 2.0 * d5;
        double d8 = gridView.statusBar.getView().getHeight();
        double d9 = d2 + d7;
        double d10 = d4 - d7 - d8;
        this.layoutAll |= flow.getWidth() != d3 || flow.getHeight() != d10;
        flow.resizeRelocate(d, d9, d3, d10);
        double d11 = this.leftPosition;
        this.headerWidth = GridView.getSizeValue(gridView.headerWidth);
        this.cellWidth = GridView.getSizeValue(gridView.cellWidth);
        this.cellInnerWidth = this.cellWidth - d5;
        this.leftPosition = flow.getHorizontalPosition();
        this.rightPosition = this.leftPosition + d3;
        this.firstVisibleColumn = (int)(this.leftPosition / this.cellWidth);
        this.topBackground.setX(d);
        this.topBackground.setY(d2);
        this.topBackground.setWidth(d3);
        this.topBackground.setHeight(d7);
        this.leftBackground.setX(d);
        this.leftBackground.setY(d9);
        this.leftBackground.setWidth(this.headerWidth);
        this.leftBackground.setHeight(flow.getVisibleHeight());
        this.selection.setWidth(this.cellWidth);
        this.selectedRow.setWidth(this.headerWidth);
        this.selectedColumn.setWidth(this.cellWidth);
        this.selection.setHeight(d6);
        this.selectedRow.setHeight(d6);
        this.selectedColumn.setHeight(d7);
        this.selectedRow.setX(d);
        this.selectedColumn.setY(d2);
        if (d5 < this.headerWidth) {
            this.headerWidth -= d5;
            this.leftPosition += d5;
        }
        if (this.layoutAll || d11 != this.leftPosition) {
            Object object;
            int n;
            this.layoutInArea((Node)this.headerRow, d, d2, d3, d7, Double.NEGATIVE_INFINITY, HPos.LEFT, VPos.TOP);
            this.layoutInArea((Node)gridView.statusBar.getView(), d, d4 - d8, d3, d8, Double.NEGATIVE_INFINITY, HPos.RIGHT, VPos.BOTTOM);
            gridRow = this.headerRow.getChildren();
            int n2 = gridRow.size();
            int n3 = (int)Math.ceil((d3 - this.headerWidth) / this.cellWidth) - n2;
            if (n3 != 0) {
                if (n3 < 0) {
                    gridRow.remove(n3 + n2, n2);
                } else {
                    GridCell[] gridCellArray = new GridCell[n3];
                    Font font = Font.font(null, (FontWeight)FontWeight.BOLD, (double)-1.0);
                    for (n = 0; n < n3; ++n) {
                        object = new GridCell();
                        object.setFont(font);
                        gridCellArray[n] = object;
                    }
                    gridRow.addAll((Object[])gridCellArray);
                }
            }
            double d12 = d + this.headerWidth;
            n = this.firstVisibleColumn;
            object = gridRow.iterator();
            while (object.hasNext()) {
                Node node = (Node)object.next();
                ((GridCell)node).setText(gridView.formatHeaderValue(n++, false));
                this.layoutInArea(node, d12, d2, this.cellWidth, d7, Double.NEGATIVE_INFINITY, HPos.RIGHT, VPos.CENTER);
                d12 += this.cellWidth;
            }
            boolean bl = this.layoutAll = n2 <= n3;
        }
        if (this.selection.isVisible()) {
            gridRow = (GridRow)flow.getFirstVisibleCell();
            double d13 = this.selection.getY() - (gridRow.getLayoutY() + d7);
            int n = (int)Math.rint(d13 / d6) + gridRow.getIndex();
            gridRow = (GridRow)flow.getCell(n);
            d13 = gridRow.getLayoutY() + d7;
            double d14 = gridRow.getLayoutX() + this.leftBackground.getWidth();
            double d15 = Math.rint((this.selection.getX() - d14) / this.cellWidth);
            double d16 = d15 * this.cellWidth + d14;
            this.selection.setX(d16);
            this.selection.setY(d13);
            this.selectedRow.setY(d13);
            this.selectedColumn.setX(d16);
            ((GridView)this.getSkinnable()).formatCoordinates(this.firstVisibleColumn + (int)d15, n);
        }
        if (this.hasErrors) {
            this.computeErrorBounds(flow);
        }
    }

    private void computeErrorBounds(Flow flow) {
        Node node;
        java.awt.Rectangle rectangle = new java.awt.Rectangle();
        GridRow gridRow = (GridRow)flow.getFirstVisibleCell();
        int n = 0;
        if (gridRow != null) {
            rectangle.x = this.firstVisibleColumn;
            rectangle.y = n = gridRow.getIndex();
            rectangle.width = (int)((flow.getWidth() - this.leftBackground.getWidth()) / this.cellWidth);
            rectangle.height = (int)(flow.getVisibleHeight() / flow.getFixedCellSize());
        }
        ObservableList observableList = this.getChildren();
        int n2 = observableList.size();
        while (--n2 >= 0 && (node = (Node)observableList.get(n2)) instanceof GridError) {
            GridError gridError = (GridError)node;
            boolean bl = false;
            java.awt.Rectangle rectangle2 = gridError.getVisibleRegion(rectangle);
            if (!rectangle2.isEmpty()) {
                double d = flow.getFixedCellSize();
                double d2 = (double)rectangle2.width * this.cellWidth;
                double d3 = (double)rectangle2.height * d;
                this.layoutInArea((Node)gridError, this.cellWidth * (double)(rectangle2.x - this.firstVisibleColumn) + this.leftBackground.getWidth(), d * (double)(rectangle2.y - n) + this.topBackground.getHeight(), d2, d3, Double.NEGATIVE_INFINITY, HPos.CENTER, VPos.CENTER);
                bl = gridError.getHeight() <= d3 && gridError.getWidth() <= d2;
            }
            gridError.setVisible(bl);
        }
    }

    static final class Flow
    extends VirtualFlow<GridRow>
    implements ChangeListener<Number> {
        Flow(GridView gridView) {
            this.getHbar().valueProperty().addListener((ChangeListener)this);
            gridView.bandProperty.addListener((ChangeListener)this);
            gridView.cellSpacing.addListener((ChangeListener)this);
        }

        final double getHorizontalPosition() {
            return this.getHbar().getValue();
        }

        final double getVisibleHeight() {
            double d = this.getHeight();
            ScrollBar scrollBar = this.getHbar();
            if (scrollBar.isVisible()) {
                d -= scrollBar.getHeight();
            }
            return d;
        }

        public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
            this.reconfigureCells();
        }
    }
}

